/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser.protocols;

import de.enough.polish.bluetooth.L2CapStreamConnection;
import de.enough.polish.browser.ProtocolHandler;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.HashMap;
import de.enough.polish.util.Locale;
import java.io.IOException;
import java.io.OutputStream;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.ServiceRecord;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class HttpBluetoothProtocolHandler
extends ProtocolHandler {
    private static final String USER_AGENT = "J2ME-Polish/" + System.getProperty("microedition.platform");
    private HashMap requestProperties;
    private final ServiceRecord serviceRecord;

    public HttpBluetoothProtocolHandler(ServiceRecord serviceRecord) {
        this("http", new HashMap(), serviceRecord);
    }

    public HttpBluetoothProtocolHandler(HashMap requestProperties, ServiceRecord serviceRecord) {
        this("http", requestProperties, serviceRecord);
    }

    public HttpBluetoothProtocolHandler(String protocolName, ServiceRecord serviceRecord) {
        this(protocolName, new HashMap(), serviceRecord);
    }

    public HttpBluetoothProtocolHandler(String protocolName, HashMap requestProperties, ServiceRecord serviceRecord) {
        super(protocolName);
        this.serviceRecord = serviceRecord;
        if (requestProperties == null) {
            requestProperties = new HashMap();
        }
        this.requestProperties = requestProperties;
        if (requestProperties.get("User-Agent") == null) {
            requestProperties.put("User-Agent", USER_AGENT);
        }
        if (requestProperties.get("Accept") == null) {
            requestProperties.put("Accept", "text/html, text/xml, text/*, image/png, image/*, application/xhtml+xml, */*");
        }
        if (requestProperties.get("Accept-Language") == null) {
            requestProperties.put("Accept-Language", Locale.LANGUAGE);
        }
        if (requestProperties.get("UA-pixels") == null && StyleSheet.currentScreen != null) {
            requestProperties.put("UA-pixels", StyleSheet.currentScreen.getWidth() + "x" + StyleSheet.currentScreen.getHeight());
        }
    }

    public StreamConnection getConnection(String url) throws IOException {
        String btUrl = this.serviceRecord.getConnectionURL(0, false);
        String max = LocalDevice.getProperty("bluetooth.l2cap.receiveMTU.max");
        if (max != null) {
            btUrl = btUrl + ";ReceiveMTU=" + max + ";TransmitMTU=" + max;
        }
        L2CAPConnection connection = (L2CAPConnection)Connector.open(btUrl);
        L2CapStreamConnection streamConnection = new L2CapStreamConnection(connection);
        OutputStream out = streamConnection.openOutputStream();
        out.write(url.getBytes());
        out.close();
        return streamConnection;
    }
}

