/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser.html;

import de.enough.polish.browser.html.FormListener;
import de.enough.polish.browser.html.HtmlBrowser;
import de.enough.polish.browser.html.HtmlSelect;
import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.TextField;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.KeyValueList;
import de.enough.polish.util.TextUtil;
import java.util.Enumeration;
import java.util.Hashtable;

public class HtmlForm {
    public static final String GET = "GET";
    public static final String POST = "POST";
    private final String formName;
    private final String actionUrl;
    private final String method;
    private final ArrayList formItems = new ArrayList();
    private Hashtable hiddenElememts;
    private final HtmlBrowser browser;
    private final String encoding;
    private final FormListener formListener;

    public HtmlForm(String name, String actionUrl, String method, String encoding, HtmlBrowser browser, FormListener formListener) {
        this.formName = name;
        this.actionUrl = actionUrl;
        this.encoding = encoding;
        this.browser = browser;
        this.formListener = formListener;
        this.method = method.toUpperCase();
    }

    public String getAction() {
        return this.actionUrl;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isGet() {
        return GET.equals(this.method);
    }

    public boolean isPost() {
        return POST.equals(this.method);
    }

    public String getName() {
        return this.formName;
    }

    public void addItem(Item item) {
        this.formItems.add(item);
    }

    public Item[] getItems() {
        return (Item[])this.formItems.toArray(new Item[this.formItems.size()]);
    }

    public void addHiddenElement(String name, String value) {
        if (this.hiddenElememts == null) {
            this.hiddenElememts = new Hashtable();
        }
        if (value == null) {
            value = "";
        }
        this.hiddenElememts.put(name, value);
    }

    public KeyValueList getFormElements() {
        return this.getFormElements(null, null);
    }

    public KeyValueList getFormElements(FormListener listener, Item submitItem) {
        Item item;
        int size = this.hiddenElememts != null ? this.hiddenElememts.size() + this.formItems.size() : this.formItems.size();
        KeyValueList elements = new KeyValueList(size);
        if (this.hiddenElememts != null) {
            Enumeration enumeration = this.hiddenElememts.keys();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String value = (String)this.hiddenElememts.get(name);
                if (listener != null) {
                    value = listener.verifySubmitFormValue(this.actionUrl, name, value);
                }
                if (value == null) {
                    value = "";
                }
                elements.add(name, value);
            }
        }
        Object[] items = this.formItems.getInternalArray();
        for (int i = 0; i < items.length && (item = (Item)items[i]) != null; ++i) {
            String name;
            if ("submit".equals(item.getAttribute("type")) && item != submitItem || (name = (String)item.getAttribute("name")) == null) continue;
            String value = (String)item.getAttribute("value");
            if (item instanceof TextField) {
                TextField textField = (TextField)item;
                value = textField.getString();
            } else if (item instanceof ChoiceGroup) {
                ChoiceGroup choiceGroup = (ChoiceGroup)item;
                HtmlSelect htmlSelect = (HtmlSelect)choiceGroup.getAttribute("select");
                if (htmlSelect != null) {
                    value = htmlSelect.getValue(choiceGroup.getSelectedIndex());
                } else {
                    boolean[] choices = new boolean[choiceGroup.size()];
                    choiceGroup.getSelectedFlags(choices);
                    for (int j = 0; j < choices.length; ++j) {
                        if (!choices[j]) continue;
                        Item choiceItem = choiceGroup.get(j);
                        elements.add(name, choiceItem.getAttribute("value"));
                    }
                    continue;
                }
            }
            if (listener != null) {
                value = listener.verifySubmitFormValue(this.actionUrl, name, value);
            }
            if (value == null) {
                value = "";
            }
            elements.add(name, value);
        }
        return elements;
    }

    protected void doPostSubmitCall(Item submitItem) {
        StringBuffer postData = new StringBuffer();
        KeyValueList elements = this.getFormElements(this.formListener, submitItem);
        boolean addAnd = false;
        for (int i = 0; i < elements.size(); ++i) {
            String name = (String)elements.getKey(i);
            String value = (String)elements.getValue(i);
            value = TextUtil.encodeUrl(value);
            if (addAnd) {
                postData.append('&');
            }
            postData.append(name).append('=').append(value);
            addAnd = true;
        }
        this.browser.go(this.browser.makeAbsoluteURL(this.actionUrl), postData.toString());
    }

    protected String createGetSubmitCall(Item submitItem) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.browser.makeAbsoluteURL(this.actionUrl));
        KeyValueList elements = this.getFormElements(this.formListener, submitItem);
        int separatorChar = 63;
        for (int i = 0; i < elements.size(); ++i) {
            String name = (String)elements.getKey(i);
            String value = (String)elements.getValue(i);
            value = TextUtil.encodeUrl(value);
            sb.append((char)separatorChar);
            sb.append(name).append('=').append(value);
            separatorChar = 38;
        }
        return sb.toString();
    }

    public void submit() {
        this.submit((Item)null);
    }

    public void submit(String submitItem) {
        Item item;
        if (submitItem == null) {
            this.submit((Item)null);
        }
        Object[] items = this.formItems.getInternalArray();
        for (int i = 0; i < items.length && (item = (Item)items[i]) != null; ++i) {
            if (!"submit".equals(item.getAttribute("type")) || !submitItem.equals(item.getAttribute("name"))) continue;
            this.submit(item);
            return;
        }
        throw new IllegalArgumentException();
    }

    public void submit(Item submitItem) {
        if (this.isPost()) {
            this.doPostSubmitCall(submitItem);
        } else {
            String url = this.createGetSubmitCall(submitItem);
            this.browser.go(url);
        }
    }
}

