/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.bluetooth;

import de.enough.polish.bluetooth.BluetoothDevice;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Arrays;
import de.enough.polish.util.Debug;
import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class DiscoveryHelper
implements DiscoveryListener {
    public static final int SEARCH_MODE_GIAC = 10390323;
    public static final int SEARCH_MODE_LIAC = 10390272;
    public static final int DEVICE_CLASS_MAJOR_PC = 256;
    public static final int DEVICE_CLASS_MAJOR_MOBILE = 512;
    public static final int DEVICE_CLASS_MAJOR_LAN = 768;
    public static final int DEVICE_CLASS_MAJOR_AUDIO = 1024;
    public static final int DEVICE_CLASS_MAJOR_PERIPHAL = 1280;
    public static final int DEVICE_CLASS_MAJOR_IMAGING = 1536;
    private static DiscoveryHelper INSTANCE;
    private ArrayList discoveredDevices = new ArrayList();
    private ArrayList discoveredServices = new ArrayList();
    private int transctionId;
    private int searchedClassMajor;
    private int searchedClassMinor;

    private DiscoveryHelper() {
    }

    public static BluetoothDevice[] findDevices() throws BluetoothStateException {
        return DiscoveryHelper.findDevices(10390323, -1, -1);
    }

    public static BluetoothDevice[] findDevices(int searchMode) throws BluetoothStateException {
        return DiscoveryHelper.findDevices(searchMode, -1, -1);
    }

    public static BluetoothDevice[] findDevices(int searchMode, int deviceClassMajor) throws BluetoothStateException {
        return DiscoveryHelper.findDevices(searchMode, deviceClassMajor, -1);
    }

    public static BluetoothDevice[] findDevices(int searchMode, int deviceClassMajor, int deviceClassMinor) throws BluetoothStateException {
        DiscoveryHelper.checkInstance();
        return INSTANCE.findDevicesImpl(searchMode, deviceClassMajor, deviceClassMinor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BluetoothDevice[] findDevicesImpl(int searchMode, int deviceClassMajor, int deviceClassMinor) throws BluetoothStateException {
        this.searchedClassMajor = deviceClassMajor;
        this.searchedClassMinor = deviceClassMinor;
        LocalDevice device = LocalDevice.getLocalDevice();
        if (device == null) {
            return new BluetoothDevice[0];
        }
        DiscoveryAgent discAgent = device.getDiscoveryAgent();
        device.setDiscoverable(searchMode);
        DiscoveryHelper discoveryHelper = INSTANCE;
        synchronized (discoveryHelper) {
            discAgent.startInquiry(searchMode, INSTANCE);
            try {
                INSTANCE.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Object[] devices = new BluetoothDevice[DiscoveryHelper.INSTANCE.discoveredDevices.size()];
        Arrays.cast(DiscoveryHelper.INSTANCE.discoveredDevices.getInternalArray(), devices);
        DiscoveryHelper.INSTANCE.discoveredDevices.clear();
        return devices;
    }

    public static ServiceRecord findService(String uuid) throws BluetoothStateException {
        return DiscoveryHelper.findService(uuid, 10390323);
    }

    public static ServiceRecord findService(String uuid, int searchMode) throws BluetoothStateException {
        UUID[] uuids = new UUID[]{new UUID(uuid, false)};
        int[] attributes = null;
        return DiscoveryHelper.findService(uuids, attributes, searchMode);
    }

    public static ServiceRecord findService(String uuid, RemoteDevice[] devices) throws BluetoothStateException {
        return DiscoveryHelper.findService(uuid, -1, devices);
    }

    public static ServiceRecord findService(String uuid, int searchMode, int deviceClassMajor) throws BluetoothStateException {
        BluetoothDevice[] devices = DiscoveryHelper.findDevices(searchMode, deviceClassMajor);
        return DiscoveryHelper.findService(uuid, devices);
    }

    public static Connection findAndConnectService(String uuid, int searchMode, int deviceClassMajor) throws BluetoothStateException {
        ServiceRecord record = DiscoveryHelper.findService(uuid, searchMode, deviceClassMajor);
        if (record == null) {
            return null;
        }
        try {
            String url = record.getConnectionURL(0, false);
            Connection con = Connector.open(url, 3);
            return con;
        }
        catch (IOException e) {
            throw new BluetoothStateException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection findAndConnectService(String uuid, int searchMode, int deviceClassMajor, boolean useAndStoreConnectionUrl) throws BluetoothStateException {
        ServiceRecord record;
        if (useAndStoreConnectionUrl) {
            RecordStore store = null;
            try {
                Connection con;
                store = RecordStore.openRecordStore(uuid, false);
                RecordEnumeration recEnum = store.enumerateRecords(null, null, false);
                String url = new String(recEnum.nextRecord());
                Connection connection = con = Connector.open(url, 3);
                return connection;
            }
            catch (Exception e) {
            }
            finally {
                if (store != null) {
                    try {
                        store.closeRecordStore();
                    }
                    catch (Exception e) {}
                }
            }
        }
        if ((record = DiscoveryHelper.findService(uuid, searchMode, deviceClassMajor)) == null) {
            return null;
        }
        try {
            String url = record.getConnectionURL(0, false);
            Connection con = Connector.open(url, 3);
            if (useAndStoreConnectionUrl) {
                RecordStore store = null;
                try {
                    store = RecordStore.openRecordStore(uuid, true);
                    byte[] data = url.getBytes();
                    if (store.getNumRecords() == 0) {
                        store.addRecord(data, 0, data.length);
                    } else {
                        RecordEnumeration recEnum = store.enumerateRecords(null, null, false);
                        int id = recEnum.nextRecordId();
                        store.setRecord(id, data, 0, data.length);
                    }
                }
                catch (Exception e) {
                    Debug.debug("error", "de.enough.polish.bluetooth.DiscoveryHelper", 327, (Object)"Unable to store last connection URL.", e);
                }
                finally {
                    if (store != null) {
                        try {
                            store.closeRecordStore();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            return con;
        }
        catch (IOException e) {
            throw new BluetoothStateException(e.toString());
        }
    }

    public static ServiceRecord findService(String uuid, BluetoothDevice[] devices) throws BluetoothStateException {
        return DiscoveryHelper.findService(uuid, -1, devices);
    }

    public static ServiceRecord findService(String uuid, int attribute, RemoteDevice[] devices) throws BluetoothStateException {
        UUID[] uuids = new UUID[]{new UUID(uuid, false)};
        int[] attributes = null;
        if (attribute != -1) {
            attributes = new int[]{attribute};
        }
        return DiscoveryHelper.findService(uuids, attributes, devices);
    }

    public static ServiceRecord findService(String uuid, int attribute, BluetoothDevice[] devices) throws BluetoothStateException {
        UUID[] uuids = new UUID[]{new UUID(uuid, false)};
        int[] attributes = null;
        if (attribute != -1) {
            attributes = new int[]{attribute};
        }
        return DiscoveryHelper.findService(uuids, attributes, devices);
    }

    public static ServiceRecord findService(UUID[] ids, int[] attributes, int searchMode) throws BluetoothStateException {
        return DiscoveryHelper.findService(ids, attributes, DiscoveryHelper.findDevices(searchMode));
    }

    public static ServiceRecord findService(UUID[] ids, int[] attributes, RemoteDevice[] devices) throws BluetoothStateException {
        DiscoveryHelper.checkInstance();
        return INSTANCE.findServicesImpl(ids, attributes, devices);
    }

    public static ServiceRecord findService(UUID[] ids, int[] attributes, BluetoothDevice[] devices) throws BluetoothStateException {
        DiscoveryHelper.checkInstance();
        return INSTANCE.findServicesImpl(ids, attributes, devices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRecord findServicesImpl(UUID[] ids, int[] attributes, Object[] devices) throws BluetoothStateException {
        LocalDevice localDevice = LocalDevice.getLocalDevice();
        if (localDevice == null) {
            return null;
        }
        DiscoveryAgent discAgent = localDevice.getDiscoveryAgent();
        for (int i = 0; i < devices.length; ++i) {
            Object obj = devices[i];
            RemoteDevice remoteDevice = obj instanceof RemoteDevice ? (RemoteDevice)obj : ((BluetoothDevice)obj).getDevice();
            this.transctionId = discAgent.searchServices(attributes, ids, remoteDevice, this);
            DiscoveryHelper discoveryHelper = this;
            synchronized (discoveryHelper) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.discoveredServices.size() > 0) break;
        }
        if (this.discoveredServices.size() > 0) {
            ServiceRecord serviceRecord = (ServiceRecord)this.discoveredServices.get(0);
            this.discoveredServices.clear();
            return serviceRecord;
        }
        return null;
    }

    private static void checkInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DiscoveryHelper();
        }
    }

    public void deviceDiscovered(RemoteDevice device, DeviceClass deviceClass) {
        if (this.searchedClassMajor != -1 && deviceClass.getMajorDeviceClass() != this.searchedClassMajor) {
            return;
        }
        if (this.searchedClassMinor != -1 && deviceClass.getMinorDeviceClass() != this.searchedClassMinor) {
            return;
        }
        this.discoveredDevices.add(new BluetoothDevice(device, deviceClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int discType) {
        DiscoveryHelper discoveryHelper = this;
        synchronized (discoveryHelper) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int transID, int respCode) {
        DiscoveryHelper discoveryHelper = this;
        synchronized (discoveryHelper) {
            this.notify();
        }
    }

    public void servicesDiscovered(int transId, ServiceRecord[] services) {
        for (int i = 0; i < services.length; ++i) {
            ServiceRecord serviceRecord = services[i];
            this.discoveredServices.add(serviceRecord);
        }
    }
}

