/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.bluetooth;

import java.io.IOException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.RemoteDevice;

public class BluetoothDevice {
    private RemoteDevice device;
    private DeviceClass deviceClass;
    private int majorClass;
    private int minorClass;
    private int serviceClasses;

    public BluetoothDevice(RemoteDevice device, DeviceClass deviceClass) {
        this.device = device;
        this.deviceClass = deviceClass;
        this.majorClass = deviceClass.getMajorDeviceClass();
        this.minorClass = deviceClass.getMinorDeviceClass();
        this.serviceClasses = deviceClass.getServiceClasses();
    }

    public RemoteDevice getDevice() {
        return this.device;
    }

    public void setDevice(RemoteDevice device) {
        this.device = device;
    }

    public DeviceClass getDeviceClass() {
        return this.deviceClass;
    }

    public void setDeviceClass(DeviceClass deviceClass) {
        this.deviceClass = deviceClass;
        this.majorClass = deviceClass.getMajorDeviceClass();
        this.minorClass = deviceClass.getMinorDeviceClass();
        this.serviceClasses = deviceClass.getServiceClasses();
    }

    public int getMajorDeviceClass() {
        return this.majorClass;
    }

    public int getMinorDeviceClass() {
        return this.minorClass;
    }

    public int getServiceClasses() {
        return this.serviceClasses;
    }

    public String getBluetoothAddress() {
        return this.device.getBluetoothAddress();
    }

    public boolean equals(Object o) {
        if (o instanceof BluetoothDevice) {
            o = ((BluetoothDevice)o).device;
        }
        return this.device.equals(o);
    }

    public int hashCode() {
        return this.device.hashCode();
    }

    public String getFriendlyName() throws IOException {
        return this.device.getFriendlyName(false);
    }
}

