/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.util;

import com.youversion.ApiBase;
import com.youversion.util.DateParser;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class JsonHelper {
    public static String getString(JSONObject json, String key) throws JSONException {
        return JsonHelper.getString(json, key, "");
    }

    public static String getString(JSONObject json, String key, String defaultValue) throws JSONException {
        if (json.has(key) && !json.isNull(key)) {
            return json.getString(key);
        }
        return defaultValue;
    }

    public static int getInt(JSONObject json, String key) throws JSONException {
        return JsonHelper.getInt(json, key, 0);
    }

    public static int getInt(JSONObject json, String key, int defaultValue) throws JSONException {
        if (json.has(key) && !json.isNull(key) && !json.getString(key).equals("")) {
            return json.getInt(key);
        }
        return defaultValue;
    }

    public static long getLong(JSONObject json, String key) throws JSONException {
        return JsonHelper.getLong(json, key, 0L);
    }

    public static long getLong(JSONObject json, String key, long defaultValue) throws JSONException {
        if (json.has(key) && !json.isNull(key) && !json.getString(key).equals("")) {
            return json.getLong(key);
        }
        return defaultValue;
    }

    public static float getFloat(JSONObject json, String key) throws JSONException {
        return JsonHelper.getFloat(json, key, 0.0f);
    }

    public static float getFloat(JSONObject json, String key, float defaultValue) throws JSONException {
        if (json.has(key) && !json.isNull(key) && !json.getString(key).equals("")) {
            return Float.parseFloat(json.getString(key));
        }
        return defaultValue;
    }

    public static Date getIsoDateTime(JSONObject json, String key) throws JSONException {
        return JsonHelper.getIsoDateTime(json, key, null);
    }

    public static Date getIsoDateTime(JSONObject json, String key, Date defaultValue) throws JSONException {
        if (json.has(key) && !json.isNull(key) && !json.getString(key).equals("")) {
            return new Date(DateParser.parseISO(json.getString(key)));
        }
        return defaultValue;
    }

    public static Date getDate(JSONObject json, String key) throws JSONException {
        return JsonHelper.getDate(json, key, null);
    }

    public static Date getDate(JSONObject json, String key, Date defaultValue) throws JSONException {
        if (json.has(key) && !json.isNull(key) && !json.getString(key).equals("")) {
            String date = json.getString(key);
            int year = Integer.parseInt(date.substring(0, 4));
            int month = Integer.parseInt(date.substring(5, 7));
            int day = Integer.parseInt(date.substring(8, 10));
            Calendar c = Calendar.getInstance();
            c.set(1, year);
            c.set(2, month - 1);
            c.set(5, day);
            c.set(10, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            return c.getTime();
        }
        return defaultValue;
    }

    public static boolean getBoolean(JSONObject json, String key) throws JSONException {
        return JsonHelper.getBoolean(json, key, false);
    }

    public static boolean getBoolean(JSONObject json, String key, boolean defaultValue) throws JSONException {
        if (json.has(key) && !json.isNull(key) && !json.getString(key).equals("")) {
            String val = json.getString(key).toLowerCase();
            return val.equals("t") || val.equals("true") || val.equals("1");
        }
        return defaultValue;
    }

    public static JSONObject getJSONObject(JSONObject json, String key) throws JSONException {
        return JsonHelper.getJSONObject(json, key, null);
    }

    public static JSONObject getJSONObject(JSONObject json, String key, JSONObject defaultValue) throws JSONException {
        if (json.has(key) && !json.isNull(key)) {
            return json.getJSONObject(key);
        }
        return defaultValue;
    }

    public static JSONArray getJSONArray(JSONObject json, String key) throws JSONException {
        return JsonHelper.getJSONArray(json, key, null);
    }

    public static JSONArray getJSONArray(JSONObject json, String key, JSONArray defaultValue) throws JSONException {
        if (json.has(key) && !json.isNull(key)) {
            return json.getJSONArray(key);
        }
        return defaultValue;
    }

    public static String[] getStringArray(JSONObject json, String key) throws JSONException {
        return JsonHelper.getStringArray(json, key, null);
    }

    public static String[] getStringArray(JSONObject json, String key, String[] defaultValue) throws JSONException {
        if (json.has(key) && !json.isNull(key)) {
            JSONArray jsonArray = json.getJSONArray(key);
            String[] stringArray = new String[jsonArray.length()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = jsonArray.getString(i);
            }
            return stringArray;
        }
        return defaultValue;
    }

    public static String getLocaleString(JSONObject json, String key) throws JSONException {
        if (json.isNull(key)) {
            return null;
        }
        JSONObject values = json.getJSONObject(key);
        String locale = ApiBase.getLocale();
        String selection = "default";
        if (locale != null) {
            String lang;
            if (values.has(locale)) {
                selection = locale;
            } else if (locale.length() > 2 && values.has(lang = locale.substring(0, 2))) {
                selection = lang;
            }
        }
        return values.getString(selection);
    }

    public static Hashtable toHashtable(JSONObject json) throws JSONException {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if (json != null) {
            Enumeration e = json.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object value = json.get(key);
                map.put(key, value);
            }
        }
        return map;
    }

    public static JSONObject fromHashtable(Hashtable map) throws JSONException {
        JSONObject json = new JSONObject();
        if (map != null && map.size() > 0) {
            Enumeration e = map.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object value = map.get(key);
                json.put(key, value);
            }
        }
        return json;
    }

    public static Vector toVector(JSONArray data) throws JSONException {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < data.length(); ++i) {
            if (data.isNull(i)) continue;
            result.addElement(data.get(i).toString());
        }
        return result;
    }
}

