/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.polish.extensions.item;

import com.youversion.objects.ReadingPlan;
import com.youversion.objects.ReadingPlanSubscription;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class PlanPreviewProgressItem
extends Container {
    private final ReadingPlan plan;
    private final Gauge progressItem;
    private final StringItem textItem;
    private StringItem startItem;
    private StringItem endItem;

    public PlanPreviewProgressItem(ReadingPlan plan) {
        super(StyleSheet.plan_progressStyle);
        this.plan = plan;
        double percentageCompleted = plan.getSubscription().getCompletionPercentage();
        int currentDay = plan.getCurrentDay();
        int totalDays = plan.getTotalDays();
        String currentDayStr = "" + currentDay;
        String totalDaysStr = "" + totalDays;
        String percentageCompletedStr = "" + percentageCompleted;
        percentageCompletedStr = percentageCompletedStr.substring(0, percentageCompletedStr.indexOf(46) + 2);
        String[] params = new String[]{currentDayStr, totalDaysStr, percentageCompletedStr};
        String formattedProgress = Locale.get(3, params);
        this.progressItem = new Gauge(null, true, 100, (int)percentageCompleted, StyleSheet.plan_preview_progressStyle);
        this.progressItem.setAppearanceMode(0);
        this.add(this.progressItem);
        this.textItem = new StringItem(null, formattedProgress, 0, StyleSheet.plan_preview_progress_textStyle);
        this.add(this.textItem);
        ReadingPlanSubscription subscription = plan.getSubscription();
        if (subscription != null) {
            this.startItem = new StringItem(Locale.get(113), Locale.formatDate(subscription.getStart()), StyleSheet.plan_preview_subscriptionStyle);
            this.add(this.startItem);
            this.endItem = new StringItem(Locale.get(93), Locale.formatDate(subscription.getEnd()), StyleSheet.plan_preview_subscriptionStyle);
            this.add(this.endItem);
        }
    }

    public ReadingPlan getPlan() {
        return this.plan;
    }
}

