/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.polish.extensions.item;

import com.youversion.objects.Bookmark;
import com.youversion.polish.extensions.item.Spacer;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.backgrounds.SimpleBackground;

public class BookmarkItem
extends Container {
    protected Bookmark bookmark;

    public BookmarkItem(Bookmark bookmark) {
        super(StyleSheet.bookmarkStyle);
        StringItem titleItem;
        this.bookmark = bookmark;
        String highlightColor = this.bookmark.getHighlightColor();
        Spacer spacer = new Spacer(StyleSheet.bookmark_highlightStyle);
        if (highlightColor != null && !highlightColor.equals("")) {
            spacer.setBackground(new SimpleBackground(Integer.parseInt(highlightColor, 16)));
        }
        this.add(spacer);
        Container container = new Container(StyleSheet.bookmark_contentStyle);
        if (this.bookmark.getTitle() != null && !this.bookmark.getTitle().equals("")) {
            if (this.bookmark.getTitle().trim().equals(this.bookmark.getHuman().trim())) {
                StringItem reference = new StringItem(null, this.bookmark.getHuman() + " (" + this.bookmark.getVersion() + ")", 0, StyleSheet.bookmark_titleStyle);
                container.add(reference);
            } else {
                titleItem = new StringItem(null, this.bookmark.getTitle(), 0, StyleSheet.bookmark_titleStyle);
                container.add(titleItem);
                StringItem reference = new StringItem(null, this.bookmark.getHuman() + " (" + this.bookmark.getVersion() + ")", 0, StyleSheet.bookmark_textStyle);
                container.add(reference);
            }
        } else {
            titleItem = new StringItem(null, this.bookmark.getHuman() + " (" + this.bookmark.getVersion() + ")", 0, StyleSheet.bookmark_titleStyle);
            container.add(titleItem);
        }
        if (this.bookmark.getLabels() != null && !this.bookmark.getLabels().equals("")) {
            StringItem labels = new StringItem(null, this.bookmark.getLabels(), 0, StyleSheet.bookmark_modeStyle);
            container.add(labels);
        }
        this.add(container);
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }
}

