/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.polish.extensions;

import com.youversion.polish.extensions.ImageResources;
import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class ImageResourceBackground
extends Background {
    private String imageUrl;
    private boolean loaded;
    protected Image image;
    protected int imageWidth;
    protected int imageHeight;
    int clipX;
    int clipY;
    int clipWidth;
    int clipHeight;

    public ImageResourceBackground(String url) {
        this.imageUrl = url;
        this.load();
    }

    protected void load() {
        if (!this.loaded) {
            this.image = ImageResources.get(this.imageUrl, true);
            this.imageWidth = this.image.getWidth();
            this.imageHeight = this.image.getHeight();
            this.loaded = true;
        }
    }

    protected void storeClipping(Graphics g) {
        this.clipX = g.getClipX();
        this.clipY = g.getClipY();
        this.clipWidth = g.getClipWidth();
        this.clipHeight = g.getClipHeight();
    }

    protected void restoreClipping(Graphics g) {
        g.setClip(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
    }

    public ImageResourceBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.clipHeight = dataInputStream.readInt();
        this.clipWidth = dataInputStream.readInt();
        this.clipX = dataInputStream.readInt();
        this.clipY = dataInputStream.readInt();
        this.image = (Image)Serializer.deserialize(dataInputStream);
        this.imageHeight = dataInputStream.readInt();
        this.imageUrl = (String)Serializer.deserialize(dataInputStream);
        this.imageWidth = dataInputStream.readInt();
        this.loaded = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.clipHeight);
        dataOutputStream.writeInt(this.clipWidth);
        dataOutputStream.writeInt(this.clipX);
        dataOutputStream.writeInt(this.clipY);
        Serializer.serialize(this.image, dataOutputStream);
        dataOutputStream.writeInt(this.imageHeight);
        Serializer.serialize(this.imageUrl, dataOutputStream);
        dataOutputStream.writeInt(this.imageWidth);
        dataOutputStream.writeBoolean(this.loaded);
    }
}

