/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.objects.Language;
import com.youversion.util.JsonHelper;
import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.json.me.JSONObject;

public class Version
implements Externalizable {
    protected String abbreviation;
    protected String title;
    protected Language language = Language.English;
    protected String booklist;
    protected String copyright;
    protected boolean audio;
    protected boolean offlineAndroid;
    protected boolean offlineBlackBerry;
    protected boolean offlineIOS;
    protected String minOfflineBuild;
    protected String maxOfflineBuild;
    protected String textDirection;

    public boolean isAudio() {
        return this.audio;
    }

    public void setAudio(boolean audio) {
        this.audio = audio;
    }

    public boolean isOfflineAndroid() {
        return this.offlineAndroid;
    }

    public void setOfflineAndroid(boolean offlineAndroid) {
        this.offlineAndroid = offlineAndroid;
    }

    public boolean isOfflineBlackBerry() {
        return this.offlineBlackBerry;
    }

    public void setOfflineBlackBerry(boolean offlineBlackBerry) {
        this.offlineBlackBerry = offlineBlackBerry;
    }

    public boolean isOfflineIOS() {
        return this.offlineIOS;
    }

    public void setOfflineIOS(boolean offlineIOS) {
        this.offlineIOS = offlineIOS;
    }

    public String getMinOfflineBuild() {
        return this.minOfflineBuild;
    }

    public void setMinOfflineBuild(String minOfflineBuild) {
        this.minOfflineBuild = minOfflineBuild;
    }

    public String getMaxOfflineBuild() {
        return this.maxOfflineBuild;
    }

    public void setMaxOfflineBuild(String maxOfflineBuild) {
        this.maxOfflineBuild = maxOfflineBuild;
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.equals("");
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String getBooklist() {
        return this.booklist;
    }

    public void setBooklist(String booklist) {
        this.booklist = booklist;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(String textDirection) {
        this.textDirection = textDirection;
    }

    public static Version unloadJSON(JSONObject obj) {
        try {
            JSONObject lang = obj.getJSONObject("language");
            Version v = ApiBase.getApiFactory().newVersion();
            v.setBooklist(obj.getString("booklist"));
            v.setCopyright(obj.getString("copyright"));
            v.setLanguage(ApiBase.getApiFactory().newLanguage(lang.getString("iso"), lang.getString("human")));
            v.setTitle(obj.getString("title"));
            v.setOfflineAndroid(obj.getBoolean("offline_android"));
            v.setOfflineBlackBerry(obj.getBoolean("offline_blackberry"));
            v.setOfflineIOS(obj.getBoolean("offline_ios"));
            v.setMinOfflineBuild(JsonHelper.getString(obj, "min_offline_build"));
            v.setMaxOfflineBuild(JsonHelper.getString(obj, "max_offline_build"));
            v.setAudio(JsonHelper.getBoolean(obj, "audio"));
            v.setTextDirection(JsonHelper.getString(obj, "text_direction"));
            return v;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String toString() {
        return this.getAbbreviation();
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.abbreviation = (String)Serializer.deserialize(dataInputStream);
        this.audio = dataInputStream.readBoolean();
        this.booklist = (String)Serializer.deserialize(dataInputStream);
        this.copyright = (String)Serializer.deserialize(dataInputStream);
        this.language = (Language)Serializer.deserialize(dataInputStream);
        this.maxOfflineBuild = (String)Serializer.deserialize(dataInputStream);
        this.minOfflineBuild = (String)Serializer.deserialize(dataInputStream);
        this.offlineAndroid = dataInputStream.readBoolean();
        this.offlineBlackBerry = dataInputStream.readBoolean();
        this.offlineIOS = dataInputStream.readBoolean();
        this.textDirection = (String)Serializer.deserialize(dataInputStream);
        this.title = (String)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Serializer.serialize(this.abbreviation, dataOutputStream);
        dataOutputStream.writeBoolean(this.audio);
        Serializer.serialize(this.booklist, dataOutputStream);
        Serializer.serialize(this.copyright, dataOutputStream);
        Serializer.serialize(this.language, dataOutputStream);
        Serializer.serialize(this.maxOfflineBuild, dataOutputStream);
        Serializer.serialize(this.minOfflineBuild, dataOutputStream);
        dataOutputStream.writeBoolean(this.offlineAndroid);
        dataOutputStream.writeBoolean(this.offlineBlackBerry);
        dataOutputStream.writeBoolean(this.offlineIOS);
        Serializer.serialize(this.textDirection, dataOutputStream);
        Serializer.serialize(this.title, dataOutputStream);
    }
}

