/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.Reference;
import com.youversion.objects.ReferenceCollection;
import com.youversion.util.DateParser;
import java.util.Date;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class ReadingPlanCalendar {
    protected int mPlanId;
    protected Vector mDays = new Vector();

    public static ReadingPlanCalendar unloadJSON(JSONArray items) {
        ReadingPlanCalendar emptyCollection = ApiBase.getApiFactory().newReadingPlanCalendar();
        if (items == null) {
            return emptyCollection;
        }
        ReadingPlanCalendar collection = ApiBase.getApiFactory().newReadingPlanCalendar();
        for (int i = 0; i < items.length(); ++i) {
            JSONObject item;
            try {
                item = items.getJSONObject(i);
            }
            catch (JSONException e) {
                ApiBase.getDebugHelper().logError("ReadingPlanCalendar::unloadJSON failed", e);
                return emptyCollection;
            }
            try {
                collection.mDays.addElement(ReadingPlanCalendarDay.unloadJSON(item));
                continue;
            }
            catch (YouVersionApiException e) {
                ApiBase.getDebugHelper().logError("ReadingPlanCalendar::unloadJSON failed", e);
                return emptyCollection;
            }
        }
        return collection;
    }

    public ReadingPlanCalendarDay elementAt(int location) {
        return (ReadingPlanCalendarDay)this.mDays.elementAt(location);
    }

    public int size() {
        return this.mDays.size();
    }

    public int getPlanId() {
        return this.mPlanId;
    }

    public void setPlanId(int id) {
        this.mPlanId = id;
    }

    public static class ReadingPlanCalendarDay {
        protected int mDay;
        protected Date mDate;
        protected boolean mCompletedDay;
        protected ReferenceCollection mReferences = ApiBase.getApiFactory().newReferenceCollection();
        protected ReferenceCollection mCompleted = ApiBase.getApiFactory().newReferenceCollection();
        protected ReferenceCollection mRemaining = ApiBase.getApiFactory().newReferenceCollection();

        public static ReadingPlanCalendarDay unloadJSON(JSONObject json) throws YouVersionApiException {
            Throwable innerEx = null;
            try {
                Reference newRef;
                int i;
                ReadingPlanCalendarDay item = ApiBase.getApiFactory().newReadingPlanCalendarDay();
                item.setDay(json.getInt("day"));
                item.setDate(new Date(DateParser.parseDate(json.getString("date"))));
                item.setCompletedDay(json.getBoolean("completed"));
                JSONArray array = json.getJSONArray("references");
                int count = array.length();
                for (i = 0; i < count; ++i) {
                    newRef = ApiBase.getApiFactory().newReference(array.getString(i), null);
                    item.mReferences.addElement(newRef);
                }
                array = json.getJSONArray("references_completed");
                count = array.length();
                for (i = 0; i < count; ++i) {
                    newRef = ApiBase.getApiFactory().newReference(array.getString(i), null);
                    item.mCompleted.addElement(newRef);
                }
                array = json.getJSONArray("references_remaining");
                count = array.length();
                for (i = 0; i < count; ++i) {
                    newRef = ApiBase.getApiFactory().newReference(array.getString(i), null);
                    item.mRemaining.addElement(newRef);
                }
                return item;
            }
            catch (Throwable t) {
                innerEx = t;
                throw new YouVersionApiException("ReadingPlanCalendarDay.unloadJSON failed: " + innerEx.getMessage(), innerEx);
            }
        }

        public int getDay() {
            return this.mDay;
        }

        public void setDay(int value) {
            this.mDay = value;
        }

        public Date getDate() {
            return this.mDate;
        }

        public void setDate(Date value) {
            this.mDate = value;
        }

        public boolean isCompletedDay() {
            return this.mCompletedDay;
        }

        public void setCompletedDay(boolean value) {
            this.mCompletedDay = value;
        }

        public ReferenceCollection getReferences() {
            return this.mReferences;
        }

        public void setReferences(ReferenceCollection value) {
            this.mReferences = value;
        }

        public ReferenceCollection getCompleted() {
            return this.mCompleted;
        }

        public void setCompleted(ReferenceCollection value) {
            this.mCompleted = value;
        }

        public ReferenceCollection getRemaining() {
            return this.mRemaining;
        }

        public void setRemaining(ReferenceCollection value) {
            this.mRemaining = value;
        }
    }
}

