/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.ReadingPlanSubscription;
import com.youversion.util.DateHelper;
import com.youversion.util.JsonHelper;
import java.util.Calendar;
import java.util.Date;
import org.json.me.JSONObject;

public class ReadingPlan {
    protected int id;
    protected String name;
    protected int totalDays;
    protected String type;
    protected boolean lockedTimeline;
    protected String copyright;
    protected String about;
    protected String version;
    protected Date created;
    protected String slug;
    protected String formattedLength;
    protected Date defaultStart;
    protected ReadingPlanSubscription subscription;
    protected String publisherUrl;
    protected String shortUrl;

    public static ReadingPlan unloadJSON(JSONObject json) throws YouVersionApiException {
        Throwable innerEx = null;
        try {
            ReadingPlan obj = ApiBase.getApiFactory().newReadingPlan();
            obj.id = JsonHelper.getInt(json, "id");
            obj.name = JsonHelper.getLocaleString(json, "name");
            obj.publisherUrl = JsonHelper.getString(json, "publisher_url");
            obj.shortUrl = JsonHelper.getString(json, "short_url");
            obj.totalDays = JsonHelper.getInt(json, "total_days");
            obj.type = JsonHelper.getString(json, "type");
            obj.lockedTimeline = JsonHelper.getBoolean(json, "locked_timeline");
            obj.copyright = JsonHelper.getLocaleString(json, "copyright");
            obj.about = JsonHelper.getLocaleString(json, "about");
            obj.version = JsonHelper.getString(json, "version");
            obj.created = JsonHelper.getIsoDateTime(json, "created");
            obj.slug = JsonHelper.getString(json, "slug");
            obj.formattedLength = JsonHelper.getLocaleString(json, "formatted_length");
            obj.defaultStart = JsonHelper.getDate(json, "default_start");
            if (json.has("completion_percentage")) {
                obj.subscription = ReadingPlanSubscription.unloadJSON(json);
            }
            return obj;
        }
        catch (Throwable t) {
            innerEx = t;
            throw new YouVersionApiException("ReadingPlan.unloadJSON failed: " + innerEx.getMessage(), innerEx);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShortUrl(String shortUrl) {
        this.shortUrl = shortUrl;
    }

    public String getShortUrl() {
        return this.shortUrl;
    }

    public void setPublisherUrl(String publisherUrl) {
        this.publisherUrl = publisherUrl;
    }

    public String getPublisherUrl() {
        return this.publisherUrl;
    }

    public int getTotalDays() {
        return this.totalDays;
    }

    public void setTotalDays(int totalDays) {
        this.totalDays = totalDays;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isLockedTimeline() {
        return this.lockedTimeline;
    }

    public void setLockedTimeline(boolean lockedTimeline) {
        this.lockedTimeline = lockedTimeline;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getAbout() {
        return this.about;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public String getFormattedLength() {
        return this.formattedLength;
    }

    public void setFormattedLength(String formattedLength) {
        this.formattedLength = formattedLength;
    }

    public ReadingPlanSubscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(ReadingPlanSubscription subscription) {
        this.subscription = subscription;
    }

    public boolean isSubscribed() {
        return this.subscription != null;
    }

    public void setDefaultStart(Date defaultStart) {
        this.defaultStart = defaultStart;
    }

    public Date getDefaultStart() {
        return this.defaultStart;
    }

    public int getCurrentDay() {
        int day = 1;
        if (this.subscription != null) {
            int dayDiff = DateHelper.getNumberOfDays(this.subscription.getStart(), Calendar.getInstance().getTime());
            day = Math.min(dayDiff + 1, this.subscription.getTotalDays());
        } else if (this.defaultStart != null) {
            Calendar calStart = Calendar.getInstance();
            calStart.setTime(this.defaultStart);
            calStart.set(1, Calendar.getInstance().get(1));
            day = DateHelper.getDayOfYear(Calendar.getInstance()) - DateHelper.getDayOfYear(calStart) + 1;
            day = Math.min(day, this.getTotalDays());
        }
        if (day < 1) {
            day = 1;
        }
        return day;
    }
}

