/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.util.JsonHelper;
import java.util.Date;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class Notification {
    protected int id;
    protected String type;
    protected Date published;
    protected Date expired;
    protected Date created;
    protected String contentText;
    protected String contentHtml;
    protected boolean persistent;

    public static Notification unloadJSON(JSONObject obj) {
        try {
            Notification x = ApiBase.getApiFactory().newNotification();
            x.setId(obj.getInt("id"));
            x.setType(obj.getString("type"));
            x.setPublished(JsonHelper.getIsoDateTime(obj, "published"));
            x.setExpired(JsonHelper.getIsoDateTime(obj, "expired"));
            x.setCreated(JsonHelper.getIsoDateTime(obj, "created"));
            x.setContentText(obj.getString("content_text"));
            x.setContentHtml(obj.getString("content_html"));
            x.setPersistent(obj.getBoolean("persistent"));
            return x;
        }
        catch (JSONException e) {
            ApiBase.getDebugHelper().logError("Notification.unloadJSON failed", e);
            return null;
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getPublished() {
        return this.published;
    }

    public void setPublished(Date published) {
        this.published = published;
    }

    public Date getExpired() {
        return this.expired;
    }

    public void setExpired(Date expired) {
        this.expired = expired;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getContentText() {
        return this.contentText;
    }

    public void setContentText(String contentText) {
        this.contentText = contentText;
    }

    public String getContentHtml() {
        return this.contentHtml;
    }

    public void setContentHtml(String contentHtml) {
        this.contentHtml = contentHtml;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }
}

