/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.objects.BookmarkLabel;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class BookmarkLabelCollection {
    protected Vector mData = new Vector();
    protected int mTotal = 0;

    public static BookmarkLabelCollection fromJson(JSONObject data) throws JSONException {
        BookmarkLabelCollection emptyCollection = ApiBase.getApiFactory().newBookmarkLabelCollection();
        if (data == null) {
            return emptyCollection;
        }
        BookmarkLabelCollection collection = ApiBase.getApiFactory().newBookmarkLabelCollection();
        collection.setTotal(data.getInt("total"));
        JSONArray items = data.getJSONArray("labels");
        for (int i = 0; i < items.length(); ++i) {
            JSONObject item;
            try {
                item = items.getJSONObject(i);
            }
            catch (JSONException e) {
                return emptyCollection;
            }
            collection.addElement(BookmarkLabel.fromJson(item));
        }
        return collection;
    }

    public void setTotal(int total) {
        this.mTotal = total;
    }

    public int getTotal() {
        return this.mTotal;
    }

    public BookmarkLabel elementAt(int location) {
        return (BookmarkLabel)this.mData.elementAt(location);
    }

    public int size() {
        return this.mData.size();
    }

    public void addElement(BookmarkLabel v) {
        this.mData.addElement(v);
    }

    public void addAll(BookmarkLabelCollection v) {
        for (int i = 0; i < v.size(); ++i) {
            this.addElement(v.elementAt(i));
        }
    }

    public void removeElementAt(int index) {
        this.mData.removeElementAt(index);
    }

    public void clear() {
        this.mData.removeAllElements();
    }
}

