/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.objects;

import com.youversion.ApiBase;
import com.youversion.objects.Reference;
import com.youversion.objects.ReferenceCollection;
import com.youversion.util.JsonHelper;
import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class Bookmark
implements Externalizable {
    protected long id;
    protected int userId;
    protected String username;
    protected String userAvatarUrl;
    protected String version;
    protected String osis;
    protected String human;
    protected Reference chapter;
    protected ReferenceCollection references;
    protected Date created;
    protected String labels;
    protected String highlightColor;
    protected String title;

    public Bookmark() {
    }

    public Bookmark(String version, String osis) {
        this.version = version;
        this.setOsis(osis);
    }

    public Bookmark(String version, Reference reference) {
        this(version, reference.getOsis());
        this.setChapter(reference);
        this.setHuman(reference.getHumanString());
    }

    public Bookmark(long id, String version, String osis) {
        this.id = id;
        this.version = version;
        this.setOsis(osis);
    }

    public static Bookmark unloadJSON(JSONObject json) throws JSONException {
        if (json == null) {
            throw new JSONException("json is null");
        }
        Bookmark bookmark = ApiBase.getApiFactory().newBookmark();
        bookmark.id = JsonHelper.getLong(json, "id");
        bookmark.setUserId(json.getInt("user_id"));
        bookmark.setUsername(json.getString("username"));
        JSONObject avatarUrls = json.getJSONObject("user_avatar_url");
        bookmark.setUserAvatarUrl(avatarUrls.getString("px_48x48"));
        bookmark.version = JsonHelper.getString(json, "version");
        JSONObject reference = json.getJSONObject("reference");
        bookmark.setOsis(JsonHelper.getString(reference, "osis"));
        bookmark.setHuman(JsonHelper.getString(reference, "human"));
        bookmark.setChapter(Reference.unloadJSON(json.getJSONObject("reference_chapter")));
        bookmark.setReferences(ReferenceCollection.unloadJSON(json.getJSONArray("references")));
        bookmark.created = JsonHelper.getDate(json, "created");
        bookmark.setTitle(JsonHelper.getString(json, "title", null));
        bookmark.setLabels(JsonHelper.getString(json, "labels", null));
        bookmark.setHighlightColor(JsonHelper.getString(json, "highlight_color", null));
        return bookmark;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getHuman() {
        return this.human;
    }

    public void setHuman(String human) {
        this.human = human;
    }

    public String getOsis() {
        return this.osis;
    }

    public void setOsis(String osis) {
        this.osis = osis;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUserAvatarUrl() {
        return this.userAvatarUrl;
    }

    public void setUserAvatarUrl(String userAvatarUrl) {
        this.userAvatarUrl = userAvatarUrl;
    }

    public Reference getChapter() {
        return this.chapter;
    }

    public void setChapter(Reference chapter) {
        this.chapter = chapter;
    }

    public ReferenceCollection getReferences() {
        return this.references;
    }

    public void setReferences(ReferenceCollection references) {
        this.references = references;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(String highlightColor) {
        this.highlightColor = highlightColor;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.chapter = (Reference)Serializer.deserialize(dataInputStream);
        this.created = (Date)Serializer.deserialize(dataInputStream);
        this.highlightColor = (String)Serializer.deserialize(dataInputStream);
        this.human = (String)Serializer.deserialize(dataInputStream);
        this.id = dataInputStream.readLong();
        this.labels = (String)Serializer.deserialize(dataInputStream);
        this.osis = (String)Serializer.deserialize(dataInputStream);
        this.references = (ReferenceCollection)Serializer.deserialize(dataInputStream);
        this.title = (String)Serializer.deserialize(dataInputStream);
        this.userAvatarUrl = (String)Serializer.deserialize(dataInputStream);
        this.userId = dataInputStream.readInt();
        this.username = (String)Serializer.deserialize(dataInputStream);
        this.version = (String)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Serializer.serialize(this.chapter, dataOutputStream);
        Serializer.serialize(this.created, dataOutputStream);
        Serializer.serialize(this.highlightColor, dataOutputStream);
        Serializer.serialize(this.human, dataOutputStream);
        dataOutputStream.writeLong(this.id);
        Serializer.serialize(this.labels, dataOutputStream);
        Serializer.serialize(this.osis, dataOutputStream);
        Serializer.serialize(this.references, dataOutputStream);
        Serializer.serialize(this.title, dataOutputStream);
        Serializer.serialize(this.userAvatarUrl, dataOutputStream);
        dataOutputStream.writeInt(this.userId);
        Serializer.serialize(this.username, dataOutputStream);
        Serializer.serialize(this.version, dataOutputStream);
    }
}

