/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.settings;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.views.core.BaseForm;
import com.youversion.application.views.theme.DayLightTheme;
import com.youversion.application.views.theme.LowLightTheme;
import com.youversion.objects.User;
import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.ItemStateListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class SettingsForm
extends BaseForm
implements ItemCommandListener,
ItemStateListener {
    protected static final String OBJECT = "obj";
    protected StringItem signIn = null;
    protected StringItem signOut = null;
    protected StringItem readerOptions = null;
    protected ChoiceItem lowLightMode = null;
    protected StringItem language = null;
    protected StringItem help = null;

    public SettingsForm() {
        this((Style)null);
    }

    public SettingsForm(Style style) {
        super(style);
        this.setContent();
    }

    public void showNotify() {
        super.showNotify();
        this.setContent();
    }

    public void setContent() {
        this.container.clear();
        this.removeAllCommands();
        User user = OPTIONS.getUser();
        if (user == null) {
            this.signIn = new StringItem(null, Locale.get(124).trim(), 3, StyleSheet.list_itemStyle);
            this.signIn.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.signIn.setItemCommandListener(this);
            this.append(this.signIn);
        } else {
            String username = user.getUsername();
            this.signOut = new StringItem(null, Locale.get(3, username).trim(), 3, StyleSheet.list_itemStyle);
            this.signOut.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.signOut.setItemCommandListener(this);
            this.append(this.signOut);
        }
        this.readerOptions = new StringItem(null, Locale.get(126).trim(), 3, StyleSheet.list_itemStyle);
        this.readerOptions.setDefaultCommand(COMMANDS.CMD_SELECT);
        this.readerOptions.setItemCommandListener(this);
        this.append(this.readerOptions);
        boolean lowLightMode = OPTIONS.isLowLightMode();
        ChoiceGroup lowLightGroup = new ChoiceGroup(null, 2, StyleSheet.itemStyle);
        this.lowLightMode = new ChoiceItem(Locale.get(125), null, 2, StyleSheet.checkboxStyle);
        this.lowLightMode.select(lowLightMode);
        lowLightGroup.add(this.lowLightMode);
        lowLightGroup.setItemStateListener(this);
        this.append(lowLightGroup);
        this.language = new StringItem(null, Locale.get(123), 3, StyleSheet.list_itemStyle);
        this.language.setDefaultCommand(COMMANDS.CMD_SELECT);
        this.language.setItemCommandListener(this);
        this.append(this.language);
        this.help = new StringItem(null, Locale.get(2).trim(), 3, StyleSheet.list_itemStyle);
        this.help.setDefaultCommand(COMMANDS.CMD_SELECT);
        this.help.setItemCommandListener(this);
        this.append(this.help);
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public String getTitle() {
        return Locale.get(127);
    }

    public void commandAction(Command c, Item item) {
        if (COMMANDS.CMD_SELECT == c) {
            if (this.signIn == item) {
                EVENT_SYSTEM.queueEvent(990008);
            } else if (this.signOut == item) {
                OPTIONS.setOption(1, new Object[]{null, null, null});
                this.setContent();
            } else if (this.readerOptions == item) {
                EVENT_SYSTEM.queueEvent(990007);
            } else if (this.language == item) {
                EVENT_SYSTEM.queueEvent(990040);
            } else if (this.help == item) {
                EVENT_SYSTEM.queueEvent(990054);
            }
        }
    }

    public void itemStateChanged(Item item) {
        if (item instanceof ChoiceGroup) {
            boolean lowLightMode = this.lowLightMode.isSelected();
            OPTIONS.setOption(4, new Boolean(lowLightMode));
            if (lowLightMode) {
                new LowLightTheme().apply();
            } else {
                new DayLightTheme().apply();
            }
            EVENT_SYSTEM.queueEvent(998881);
        }
    }
}

