/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.reader;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.model.BibleReaderManager;
import com.youversion.application.model.reader.ChapterDescriptor;
import com.youversion.application.views.reader.BibleReaderChangeForm;
import com.youversion.objects.Book;
import com.youversion.objects.BookCollection;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;
import java.util.Vector;

public class BibleBooksForm
extends BibleReaderChangeForm
implements ItemCommandListener {
    protected static final String KEY_BOOK = "obj";

    public BibleBooksForm() {
        this((Style)null);
    }

    public BibleBooksForm(Style style) {
        super(style);
        BibleReaderManager bibleReaderManager = BibleReaderManager.getInstance();
        ChapterDescriptor workChapterDescriptor = bibleReaderManager.getWorkChapterDescriptor();
        BookCollection bookCollection = workChapterDescriptor.getBookCollection();
        Vector orderedBooks = bookCollection.getOrdered();
        for (int index = 0; index < orderedBooks.size(); ++index) {
            Book b = (Book)orderedBooks.elementAt(index);
            StringItem item = new StringItem(null, b.getHuman(), StyleSheet.list_itemStyle);
            item.setDefaultCommand(COMMANDS.CMD_SELECT);
            item.addCommand(COMMANDS.CMD_SELECT);
            item.setItemCommandListener(this);
            item.setAttribute(KEY_BOOK, b);
            this.container.add(item);
        }
        COMMANDS.CMD_READER_CHANGE.removeSubCommands();
        this.addCommand(COMMANDS.CMD_READER_CHANGE);
        this.addSubCommand(COMMANDS.CMD_READER_CHANGE_VERSION, COMMANDS.CMD_READER_CHANGE);
        this.addSubCommand(COMMANDS.CMD_READER_CHANGE_LANGUAGE, COMMANDS.CMD_READER_CHANGE);
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public String getTitle() {
        return Locale.get(20);
    }

    public void commandAction(Command c, Displayable d) {
        if (COMMANDS.CMD_READER_CHANGE_VERSION == c) {
            EVENT_SYSTEM.queueEvent(990001);
        } else if (COMMANDS.CMD_READER_CHANGE_LANGUAGE == c) {
            EVENT_SYSTEM.queueEvent(990005);
        } else {
            super.commandAction(c, d);
        }
    }

    public void commandAction(Command c, Item item) {
        if (COMMANDS.CMD_SELECT == c) {
            BibleReaderManager bibleReaderManager = BibleReaderManager.getInstance();
            ChapterDescriptor workChapterDescriptor = bibleReaderManager.getWorkChapterDescriptor();
            Book book = (Book)item.getAttribute(KEY_BOOK);
            workChapterDescriptor.setBook(book);
            EVENT_SYSTEM.queueEvent(990003);
        }
    }
}

