/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.reader;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.model.BibleReaderManager;
import com.youversion.application.model.reader.ChapterDescriptor;
import com.youversion.application.views.reader.BibleReaderChangeForm;
import com.youversion.objects.Book;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class BibleBookChaptersForm
extends BibleReaderChangeForm
implements ItemCommandListener {
    protected static final String KEY_CHAPTER = "obj";

    public BibleBookChaptersForm() {
        this((Style)null);
    }

    public BibleBookChaptersForm(Style style) {
        super(style);
        BibleReaderManager bibleReaderManager = BibleReaderManager.getInstance();
        ChapterDescriptor workChapterDescriptor = bibleReaderManager.getWorkChapterDescriptor();
        Book book = workChapterDescriptor.getBook();
        for (int i = 1; i <= book.getChapters(); ++i) {
            String chapterStr = "" + i;
            StringItem item = new StringItem(null, Locale.get(4, chapterStr), StyleSheet.list_itemStyle);
            item.setDefaultCommand(COMMANDS.CMD_SELECT);
            item.setItemCommandListener(this);
            item.setAttribute(KEY_CHAPTER, new Integer(i));
            this.container.add(item);
        }
        COMMANDS.CMD_READER_CHANGE.removeSubCommands();
        this.addCommand(COMMANDS.CMD_READER_CHANGE);
        this.addSubCommand(COMMANDS.CMD_READER_CHANGE_BOOK, COMMANDS.CMD_READER_CHANGE);
        this.addSubCommand(COMMANDS.CMD_READER_CHANGE_VERSION, COMMANDS.CMD_READER_CHANGE);
        this.addSubCommand(COMMANDS.CMD_READER_CHANGE_LANGUAGE, COMMANDS.CMD_READER_CHANGE);
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public String getTitle() {
        return Locale.get(21);
    }

    public void commandAction(Command c, Displayable d) {
        if (COMMANDS.CMD_READER_CHANGE_BOOK == c) {
            EVENT_SYSTEM.queueEvent(990002);
        } else if (COMMANDS.CMD_READER_CHANGE_VERSION == c) {
            EVENT_SYSTEM.queueEvent(990001);
        } else if (COMMANDS.CMD_READER_CHANGE_LANGUAGE == c) {
            EVENT_SYSTEM.queueEvent(990005);
        } else {
            super.commandAction(c, d);
        }
    }

    public void commandAction(Command c, Item item) {
        if (COMMANDS.CMD_SELECT == c) {
            BibleReaderManager bibleReaderManager = BibleReaderManager.getInstance();
            ChapterDescriptor workChapterDescriptor = bibleReaderManager.getWorkChapterDescriptor();
            Integer chapterNumber = (Integer)item.getAttribute(KEY_CHAPTER);
            workChapterDescriptor.setChapterNumber(chapterNumber);
            if (bibleReaderManager.getContext() == 0) {
                EVENT_SYSTEM.queueEvent(990004, new Object[]{chapterNumber, workChapterDescriptor.getBook(), workChapterDescriptor.getVersion()});
            } else {
                EVENT_SYSTEM.queueEvent(990051, new Object[]{chapterNumber, workChapterDescriptor.getBook(), workChapterDescriptor.getVersion()});
            }
        }
    }
}

