/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.plans;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.ReadingPlansManager;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.ReadingPlan;
import com.youversion.objects.ReadingPlanDay;
import com.youversion.polish.extensions.item.PlanPreviewProgressItem;
import com.youversion.polish.extensions.item.Spacer;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;
import javax.microedition.io.ConnectionNotFoundException;

public class BibleReadingPlanForm
extends BaseForm
implements ItemCommandListener,
CommandListener {
    protected ReadingPlan currentPlan;
    protected StringItem startPlanButton;
    protected StringItem stopPlanButton;
    protected StringItem viewPlanButton;
    protected StringItem sharePlanButton;
    protected StringItem catchMeUpButton;
    protected StringItem calendarViewButton;
    protected StringItem url;

    public BibleReadingPlanForm() {
        this((Style)null);
    }

    public BibleReadingPlanForm(Style style) {
        super(style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(ReadingPlan readingPlan) {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.removeAllCommands();
            this.currentPlan = readingPlan;
            ReadingPlansManager.getInstance().setCurrentPlan(this.currentPlan);
            if (this.currentPlan.getSubscription() == null) {
                this.startPlanButton = new StringItem(null, Locale.get(109), StyleSheet.plan_start_buttonStyle);
                this.startPlanButton.setAppearanceMode(3);
                this.startPlanButton.setDefaultCommand(COMMANDS.CMD_SELECT);
                this.startPlanButton.setItemCommandListener(this);
                this.append(this.startPlanButton);
                this.viewPlanButton = new StringItem(null, Locale.get(107), StyleSheet.buttonStyle);
                this.viewPlanButton.setAppearanceMode(3);
                this.viewPlanButton.setDefaultCommand(COMMANDS.CMD_SELECT);
                this.viewPlanButton.setItemCommandListener(this);
                this.append(this.viewPlanButton);
            } else {
                this.viewPlanButton = new StringItem(null, Locale.get(115), StyleSheet.plan_start_buttonStyle);
                this.viewPlanButton.setAppearanceMode(3);
                this.viewPlanButton.setDefaultCommand(COMMANDS.CMD_SELECT);
                this.viewPlanButton.setItemCommandListener(this);
                this.append(this.viewPlanButton);
                this.catchMeUpButton = new StringItem(null, Locale.get(90), StyleSheet.buttonStyle);
                this.catchMeUpButton.setAppearanceMode(3);
                this.catchMeUpButton.setDefaultCommand(COMMANDS.CMD_SELECT);
                this.catchMeUpButton.setItemCommandListener(this);
                this.append(this.catchMeUpButton);
            }
            this.sharePlanButton = new StringItem(null, Locale.get(112), StyleSheet.buttonStyle);
            this.sharePlanButton.setAppearanceMode(3);
            this.sharePlanButton.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.sharePlanButton.setItemCommandListener(this);
            this.append(this.sharePlanButton);
            if (this.currentPlan.getSubscription() != null) {
                this.stopPlanButton = new StringItem(null, Locale.get(114), StyleSheet.buttonStyle);
                this.stopPlanButton.setAppearanceMode(3);
                this.stopPlanButton.setDefaultCommand(COMMANDS.CMD_SELECT);
                this.stopPlanButton.setItemCommandListener(this);
                this.append(this.stopPlanButton);
            }
            this.calendarViewButton = new StringItem(null, Locale.get(88), StyleSheet.buttonStyle);
            this.calendarViewButton.setAppearanceMode(3);
            this.calendarViewButton.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.calendarViewButton.setItemCommandListener(this);
            this.append(this.calendarViewButton);
            Spacer spacer = new Spacer(StyleSheet.spacerStyle);
            this.append(spacer);
            String planNameStr = this.currentPlan.getName();
            StringItem planName = new StringItem(null, planNameStr, StyleSheet.labelStyle);
            planName.setAppearanceMode(0);
            this.append(planName);
            if (this.currentPlan.getSubscription() != null) {
                PlanPreviewProgressItem planProgress = new PlanPreviewProgressItem(this.currentPlan);
                planProgress.setAppearanceMode(0);
                this.append(planProgress);
            }
            StringItem planDescription = new StringItem(null, this.currentPlan.getAbout(), StyleSheet.textStyle);
            planDescription.setAppearanceMode(0);
            this.append(planDescription);
            spacer = new Spacer(StyleSheet.spacerStyle);
            this.append(spacer);
            StringItem planAbout = new StringItem(null, Locale.get(108), StyleSheet.labelStyle);
            planAbout.setAppearanceMode(0);
            this.append(planAbout);
            StringItem copyright = new StringItem(null, this.currentPlan.getCopyright(), StyleSheet.textStyle);
            copyright.setAppearanceMode(0);
            this.append(copyright);
            spacer = new Spacer(StyleSheet.spacerStyle);
            this.append(spacer);
            StringItem planUrl = new StringItem(null, Locale.get(111), StyleSheet.labelStyle);
            planUrl.setAppearanceMode(0);
            this.append(planUrl);
            this.url = new StringItem(null, this.currentPlan.getPublisherUrl(), StyleSheet.list_itemStyle);
            this.url.setAppearanceMode(3);
            this.url.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.url.setItemCommandListener(this);
            this.append(this.url);
            this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
        }
    }

    public String getTitle() {
        return Locale.get(110);
    }

    public void commandAction(Command c, Item item) {
        if (item == this.viewPlanButton) {
            ReadingPlanDay readingPlanDay = new ReadingPlanDay();
            readingPlanDay.setPlan(this.currentPlan);
            if (this.currentPlan.getSubscription() != null) {
                readingPlanDay.setCurrent(this.currentPlan.getCurrentDay());
            } else {
                readingPlanDay.setCurrent(1);
            }
            EVENT_SYSTEM.queueEvent(990035, readingPlanDay);
        } else if (item == this.sharePlanButton) {
            String planName = this.currentPlan.getName();
            String shareText = Locale.get(2, planName);
            EVENT_SYSTEM.queueEvent(990011, new String[]{shareText, this.currentPlan.getShortUrl()});
        } else if (item == this.catchMeUpButton) {
            EVENT_SYSTEM.queueEvent(200024, 2, this.currentPlan);
        } else if (item == this.startPlanButton) {
            Event subscribeEvent = new Event(200025, 2, this.currentPlan);
            if (OPTIONS.isLoggedIn()) {
                EVENT_SYSTEM.queueEvent(subscribeEvent);
            } else {
                Event loginEvent = new Event(990008, subscribeEvent);
                EVENT_SYSTEM.queueEvent(990014, new Object[]{Locale.get(142), Locale.get(150), loginEvent});
            }
        } else if (item == this.stopPlanButton) {
            EVENT_SYSTEM.queueEvent(200026, 2, this.currentPlan);
        } else if (item == this.calendarViewButton) {
            EVENT_SYSTEM.queueEvent(990052, this.currentPlan);
        } else if (item == this.url) {
            String link = this.currentPlan.getPublisherUrl();
            try {
                StyleSheet.midlet.platformRequest(link);
            }
            catch (ConnectionNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

