/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.plans;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.model.ReadingPlansManager;
import com.youversion.application.model.plans.ReadingPlansDescriptor;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.ReadingPlan;
import com.youversion.objects.ReadingPlanCollection;
import com.youversion.polish.extensions.item.PlanProgressItem;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class BiblePlansMyPlansForm
extends BaseForm
implements ItemCommandListener {
    protected static final String KEY_PLAN = "obj";
    private ReadingPlansDescriptor readingPlansDescriptor;
    private Container loadingContainer;
    private Gauge loadingGauge;
    protected Container plansContainer;
    protected StringItem selectPlanLabel;
    protected Container plansList;

    public BiblePlansMyPlansForm() {
        this((Style)null);
    }

    public BiblePlansMyPlansForm(Style style) {
        super(style);
        ReadingPlansManager readingPlansManager = ReadingPlansManager.getInstance();
        this.readingPlansDescriptor = readingPlansManager.getMyPlansDescriptor();
        this.plansList = new Container(StyleSheet.itemStyle);
        this.plansContainer = new Container(StyleSheet.itemStyle);
        this.loadingContainer = new Container(false, StyleSheet.splash_screenStyle);
        this.loadingGauge = new Gauge(null, false, -1, 2, StyleSheet.loading_gaugeStyle);
        this.loadingContainer.add(this.loadingGauge);
    }

    public String getTitle() {
        return Locale.get(94);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoading() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.removeAllCommands();
            this.append(this.loadingContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.removeAllCommands();
            ReadingPlanCollection collection = this.readingPlansDescriptor.getCollection();
            int page = this.readingPlansDescriptor.getPage();
            if (collection != null && collection.size() > 0) {
                this.populatePlans(collection);
                this.populateMenu(page, collection);
                this.append(this.plansContainer);
            } else {
                StringItem noPlansFound = new StringItem(null, Locale.get(103), 0);
                this.append(noPlansFound);
            }
            this.addCommand(COMMANDS.CMD_ALL_PLANS);
            this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
        }
    }

    protected Item generateItemForPlan(ReadingPlan plan) {
        PlanProgressItem item = new PlanProgressItem(plan);
        item.setDefaultCommand(COMMANDS.CMD_SELECT);
        item.setItemCommandListener(this);
        item.setAttribute(KEY_PLAN, plan);
        return item;
    }

    protected void populatePlans(ReadingPlanCollection collection) {
        this.plansContainer.clear();
        this.plansList.clear();
        this.plansContainer.add(this.plansList);
        if (collection.size() == 0) {
            this.plansContainer.setVisible(false);
            return;
        }
        this.plansContainer.setVisible(true);
        for (int i = 0; i < collection.size(); ++i) {
            this.plansList.add(this.generateItemForPlan(collection.elementAt(i)));
        }
    }

    protected void populateMenu(int page, ReadingPlanCollection collection) {
        int total = collection.getTotal();
        int pages = (int)Math.ceil(1.0 * (double)total / 25.0);
        if (page > 1) {
            this.addCommand(COMMANDS.CMD_PREVIOUS_PAGE);
        }
        if (page < pages) {
            this.addCommand(COMMANDS.CMD_NEXT_PAGE);
        }
    }

    public void commandAction(Command c, Item item) {
        if (COMMANDS.CMD_SELECT == c) {
            ReadingPlan readingPlan = (ReadingPlan)item.getAttribute(KEY_PLAN);
            EVENT_SYSTEM.queueEvent(990013, readingPlan);
        }
    }

    public void commandAction(Command c, Displayable d) {
        int page = this.readingPlansDescriptor.getPage();
        if (COMMANDS.CMD_NEXT_PAGE == c) {
            Integer requestedPage = new Integer(page + 1);
            EVENT_SYSTEM.queueEvent(200020, 2, new Object[]{requestedPage});
        } else if (COMMANDS.CMD_PREVIOUS_PAGE == c) {
            Integer requestedPage = new Integer(page - 1);
            EVENT_SYSTEM.queueEvent(200020, 2, new Object[]{requestedPage});
        } else if (COMMANDS.CMD_ALL_PLANS == c) {
            EVENT_SYSTEM.queueEvent(990012);
        } else {
            super.commandAction(c, d);
        }
    }

    public boolean handleKeyReleased(int keycode, int gameAction) {
        if (this.readingPlansDescriptor == null || this.readingPlansDescriptor.getCollection() == null || this.readingPlansDescriptor.getPage() == null) {
            return super.handleKeyReleased(keycode, gameAction);
        }
        ReadingPlanCollection collection = this.readingPlansDescriptor.getCollection();
        if (collection != null && collection.size() > 0) {
            int page = this.readingPlansDescriptor.getPage();
            int total = collection.getTotal();
            int pages = (int)Math.ceil(1.0 * (double)total / 25.0);
            if (page > 1 && gameAction == 2) {
                this.handleCommand(COMMANDS.CMD_PREVIOUS_PAGE);
                return true;
            }
            if (page < pages && gameAction == 5) {
                this.handleCommand(COMMANDS.CMD_NEXT_PAGE);
                return true;
            }
        }
        return super.handleKeyReleased(keycode, gameAction);
    }
}

