/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.plans;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.model.ReadingPlansManager;
import com.youversion.application.model.plans.ReadingPlansDescriptor;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.ReadingPlan;
import com.youversion.objects.ReadingPlanCategory;
import com.youversion.objects.ReadingPlanCollection;
import com.youversion.polish.extensions.item.Spacer;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;
import java.util.Vector;

public class BiblePlansAllPlansForm
extends BaseForm
implements ItemCommandListener {
    private static final String KEY_PAYLOAD = "obj";
    private Container headerContainer;
    private StringItem headerLabel;
    private StringItem upButton;
    private ReadingPlansDescriptor readingPlansDescriptor;
    private Container loadingContainer;
    private Gauge loadingGauge;
    private Container categoryContainer;
    private StringItem selectedCategoryLabel;
    private Container categorySelect;
    private Container plansContainer;
    private StringItem selectedPlanLabel;
    private Container plansList;

    public BiblePlansAllPlansForm() {
        this((Style)null);
    }

    public BiblePlansAllPlansForm(Style style) {
        super(style);
        ReadingPlansManager readingPlansManager = ReadingPlansManager.getInstance();
        this.readingPlansDescriptor = readingPlansManager.getAllPlansDescriptor();
        this.headerContainer = new Container(StyleSheet.itemStyle);
        this.categoryContainer = new Container(StyleSheet.itemStyle);
        this.categorySelect = new Container(StyleSheet.itemStyle);
        this.plansContainer = new Container(StyleSheet.itemStyle);
        this.plansList = new Container(StyleSheet.itemStyle);
        this.loadingContainer = new Container(false, StyleSheet.splash_screenStyle);
        this.loadingGauge = new Gauge(null, false, -1, 2, StyleSheet.loading_gaugeStyle);
        this.loadingContainer.add(this.loadingGauge);
    }

    public String getTitle() {
        return Locale.get(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.removeAllCommands();
            ReadingPlanCollection collection = this.readingPlansDescriptor.getCollection();
            int page = this.readingPlansDescriptor.getPage();
            this.selectedCategoryLabel = new StringItem(null, Locale.get(98), StyleSheet.labelStyle);
            this.selectedCategoryLabel.setAppearanceMode(0);
            this.categoryContainer.add(this.selectedCategoryLabel);
            this.selectedPlanLabel = new StringItem(null, Locale.get(99), StyleSheet.labelStyle);
            this.selectedPlanLabel.setAppearanceMode(0);
            this.populateHeader(collection);
            this.populateCategories(collection);
            this.populatePlans(collection);
            this.populateMenu(page, collection);
            this.append(this.headerContainer);
            this.append(this.categoryContainer);
            this.append(this.plansContainer);
            this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
        }
    }

    protected Item generateItemForCategory(ReadingPlanCategory category) {
        StringItem item = new StringItem(null, category.getLabel(), StyleSheet.list_itemStyle);
        item.setAppearanceMode(3);
        item.setDefaultCommand(COMMANDS.CMD_SELECT);
        item.setItemCommandListener(this);
        item.setAttribute(KEY_PAYLOAD, category);
        return item;
    }

    protected Item generateItemForPlan(ReadingPlan plan) {
        StringItem item = new StringItem(plan.getName().trim(), plan.getFormattedLength(), StyleSheet.plan_list_itemStyle);
        item.setDefaultCommand(COMMANDS.CMD_SELECT);
        item.setItemCommandListener(this);
        item.setAttribute(KEY_PAYLOAD, plan);
        return item;
    }

    protected void populatePlans(ReadingPlanCollection collection) {
        this.plansContainer.clear();
        this.plansList.clear();
        this.plansContainer.add(this.selectedPlanLabel);
        this.plansContainer.add(this.plansList);
        if (collection.size() == 0) {
            this.plansContainer.setVisible(false);
            return;
        }
        this.plansContainer.setVisible(true);
        for (int i = 0; i < collection.size(); ++i) {
            this.plansList.add(this.generateItemForPlan(collection.elementAt(i)));
        }
    }

    protected void populateCategories(ReadingPlanCollection collection) {
        this.categorySelect.clear();
        this.categoryContainer.clear();
        this.categoryContainer.add(this.selectedCategoryLabel);
        this.categoryContainer.add(this.categorySelect);
        if (collection.getCategory().getChildren() == null || collection.getCategory().getChildren().size() == 0) {
            this.categoryContainer.setVisible(false);
            return;
        }
        this.categoryContainer.setVisible(true);
        Vector subcategories = collection.getCategory().getChildren();
        for (int i = 0; i < subcategories.size(); ++i) {
            this.categorySelect.add(this.generateItemForCategory((ReadingPlanCategory)subcategories.elementAt(i)));
        }
        Spacer spacer = new Spacer(StyleSheet.spacerStyle);
        this.categoryContainer.add(spacer);
    }

    protected void populateHeader(ReadingPlanCollection collection) {
        this.headerContainer.clear();
        if (collection.getCategory().isRoot()) {
            this.headerContainer.clear();
            this.headerContainer.setVisible(false);
            return;
        }
        this.headerContainer.setVisible(true);
        String label = collection.getCategory().getLabel();
        this.headerLabel = new StringItem(null, Locale.get(1, label), StyleSheet.labelStyle);
        this.headerLabel.setAppearanceMode(0);
        this.headerContainer.add(this.headerLabel);
        this.upButton = new StringItem(null, Locale.get(97), StyleSheet.buttonStyle);
        this.upButton.setAppearanceMode(3);
        this.upButton.setDefaultCommand(COMMANDS.CMD_SELECT);
        this.upButton.setItemCommandListener(this);
        if (collection.getCategory().getParent() != null) {
            this.upButton.setAttribute(KEY_PAYLOAD, collection.getCategory().getParent());
        } else {
            this.upButton.setAttribute(KEY_PAYLOAD, new ReadingPlanCategory());
        }
        this.headerContainer.add(this.upButton);
        Spacer spacer = new Spacer(StyleSheet.spacerStyle);
        this.headerContainer.add(spacer);
    }

    protected void populateMenu(int page, ReadingPlanCollection collection) {
        int total = collection.getTotal();
        int pages = (int)Math.ceil(1.0 * (double)total / 25.0);
        if (page > 1) {
            this.addCommand(COMMANDS.CMD_PREVIOUS_PAGE);
        }
        if (page < pages) {
            this.addCommand(COMMANDS.CMD_NEXT_PAGE);
        }
        this.addCommand(COMMANDS.CMD_MY_PLANS);
    }

    public void commandAction(Command c, Item item) {
        if (COMMANDS.CMD_SELECT == c) {
            Object payload = item.getAttribute(KEY_PAYLOAD);
            if (payload instanceof ReadingPlanCategory) {
                ReadingPlanCategory selectedCategory = (ReadingPlanCategory)payload;
                String requestCategory = selectedCategory.getCategory();
                EVENT_SYSTEM.queueEvent(990012, 2, new Object[]{requestCategory, new Integer(1)});
            } else if (payload instanceof ReadingPlan) {
                EVENT_SYSTEM.queueEvent(990013, payload);
            }
        }
    }

    public void commandAction(Command c, Displayable d) {
        String category = this.readingPlansDescriptor.getCategory();
        int page = this.readingPlansDescriptor.getPage();
        if (COMMANDS.CMD_NEXT_PAGE == c) {
            Integer requestedPage = new Integer(page + 1);
            EVENT_SYSTEM.queueEvent(200014, 2, new Object[]{category, requestedPage});
        } else if (COMMANDS.CMD_PREVIOUS_PAGE == c) {
            Integer requestedPage = new Integer(page - 1);
            EVENT_SYSTEM.queueEvent(200014, 2, new Object[]{category, requestedPage});
        } else if (COMMANDS.CMD_MY_PLANS == c) {
            EVENT_SYSTEM.queueEvent(990038);
        } else {
            super.commandAction(c, d);
        }
    }

    public boolean handleKeyReleased(int keycode, int gameAction) {
        if (this.readingPlansDescriptor == null || this.readingPlansDescriptor.getCollection() == null || this.readingPlansDescriptor.getPage() == null) {
            return super.handleKeyReleased(keycode, gameAction);
        }
        ReadingPlanCollection collection = this.readingPlansDescriptor.getCollection();
        int page = this.readingPlansDescriptor.getPage();
        int total = collection.getTotal();
        int pages = (int)Math.ceil(1.0 * (double)total / 25.0);
        if (page > 1 && gameAction == 2) {
            this.handleCommand(COMMANDS.CMD_PREVIOUS_PAGE);
            return true;
        }
        if (page < pages && gameAction == 5) {
            this.handleCommand(COMMANDS.CMD_NEXT_PAGE);
            return true;
        }
        return super.handleKeyReleased(keycode, gameAction);
    }
}

