/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.notes;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.model.ReferenceNotesManager;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.Note;
import com.youversion.objects.NoteCollection;
import com.youversion.polish.extensions.item.NoteItem;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class ReferenceNotesForm
extends BaseForm
implements ItemCommandListener,
CommandListener {
    Container header = new Container(StyleSheet.itemStyle);
    Container results = new Container(StyleSheet.itemStyle);

    public ReferenceNotesForm() {
        this((Style)null);
    }

    public ReferenceNotesForm(Style style) {
        super(style);
        this.addFormContent();
    }

    public void hideNotify() {
        super.hideNotify();
        EVENT_SYSTEM.queueEvent(998882, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFormContent() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.header.clear();
            this.results.clear();
            this.append(this.header);
            this.append(this.results);
            ReferenceNotesManager manager = ReferenceNotesManager.getInstance();
            if (manager.getNoteCollection() != null) {
                this.populateResults(manager.getNoteCollection());
            } else if (this.results.size() == 0) {
                StringItem noNotes = new StringItem(null, Locale.get(68), 0);
                this.results.add(noNotes);
            }
            this.populateMenu();
        }
    }

    public void populateMenu() {
        this.removeAllCommands();
        ReferenceNotesManager manager = ReferenceNotesManager.getInstance();
        NoteCollection notes = manager.getNoteCollection();
        if (notes != null) {
            int total = notes.getTotal();
            int noOfPages = (int)Math.ceil(1.0 * (double)total / 25.0);
            if (manager.getPage() > 1) {
                this.addCommand(COMMANDS.CMD_PREVIOUS_PAGE);
            }
            if (manager.getPage() < noOfPages) {
                this.addCommand(COMMANDS.CMD_NEXT_PAGE);
            }
        }
        if (manager.getMode().equals("all")) {
            this.addCommand(COMMANDS.CMD_ITEM_MY_NOTES);
        } else {
            this.addCommand(COMMANDS.CMD_ITEM_COMMUNITY_NOTES);
        }
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public void commandAction(Command c, Displayable d) {
        ReferenceNotesManager manager = ReferenceNotesManager.getInstance();
        if (COMMANDS.CMD_NEXT_PAGE == c) {
            if (manager.getMode() == "my") {
                EVENT_SYSTEM.queueEvent(200030, 2, new Object[]{new Integer(manager.getPage() + 1), manager.getReferences(), null});
            } else {
                EVENT_SYSTEM.queueEvent(200032, 2, new Object[]{new Integer(manager.getPage() + 1), manager.getReferences()});
            }
        } else if (COMMANDS.CMD_PREVIOUS_PAGE == c) {
            if (manager.getMode() == "my") {
                EVENT_SYSTEM.queueEvent(200030, 2, new Object[]{new Integer(manager.getPage() - 1), manager.getReferences(), null});
            } else {
                EVENT_SYSTEM.queueEvent(200032, 2, new Object[]{new Integer(manager.getPage() - 1), manager.getReferences()});
            }
        } else if (COMMANDS.CMD_ITEM_COMMUNITY_NOTES == c) {
            EVENT_SYSTEM.queueEvent(200032, 2, new Object[]{new Integer(1), manager.getReferences()});
        } else if (COMMANDS.CMD_ITEM_MY_NOTES == c) {
            EVENT_SYSTEM.queueEvent(200030, 2, new Object[]{new Integer(1), manager.getReferences(), null});
        } else {
            super.commandAction(c, d);
        }
    }

    public void commandAction(Command c, Item item) {
        if (c == COMMANDS.CMD_SELECT && item instanceof NoteItem) {
            EVENT_SYSTEM.queueEvent(990043, ((NoteItem)item).getNote());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateResults(NoteCollection results) {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.results.clear();
            for (int i = 0; i < results.size(); ++i) {
                NoteItem item = new NoteItem((Note)results.elementAt(i));
                item.setDefaultCommand(COMMANDS.CMD_SELECT);
                item.setItemCommandListener(this);
                this.results.add(item);
            }
            if (this.results.size() == 0) {
                StringItem noNotes = new StringItem(null, Locale.get(68), 0);
                this.results.add(noNotes);
            }
        }
    }

    public boolean handleKeyReleased(int keycode, int gameAction) {
        ReferenceNotesManager manager = ReferenceNotesManager.getInstance();
        if (manager.getNoteCollection() == null) {
            return super.handleKeyReleased(keycode, gameAction);
        }
        int total = manager.getNoteCollection().getTotal();
        int noOfPages = (int)Math.ceil(1.0 * (double)total / 25.0);
        if (manager.getPage() > 1 && gameAction == 2) {
            this.handleCommand(COMMANDS.CMD_PREVIOUS_PAGE);
            return true;
        }
        if (manager.getPage() < noOfPages && gameAction == 5) {
            this.handleCommand(COMMANDS.CMD_NEXT_PAGE);
            return true;
        }
        return super.handleKeyReleased(keycode, gameAction);
    }

    public String getTitle() {
        ReferenceNotesManager manager = ReferenceNotesManager.getInstance();
        if (manager.getMode().equals("all")) {
            return Locale.get(76);
        }
        return Locale.get(75);
    }
}

