/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.notes;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.EditNoteManager;
import com.youversion.application.model.reader.BookmarkChapterDescriptor;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.Bookmark;
import com.youversion.objects.Note;
import com.youversion.objects.Reference;
import com.youversion.objects.ReferenceCollection;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class EditNoteReferencesForm
extends BaseForm
implements ItemCommandListener {
    public static final String OBJECT = "object";
    private StringItem addReferences;

    public EditNoteReferencesForm() {
        this((Style)null);
    }

    public EditNoteReferencesForm(Style style) {
        super(style);
    }

    public String getTitle() {
        return Locale.get(56);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFormContent() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.removeAllCommands();
            EditNoteManager manager = EditNoteManager.getInstance();
            Note note = manager.getNote();
            ReferenceCollection references = manager.getTempReferences();
            if (references.size() > 0) {
                for (int i = 0; i < references.size(); ++i) {
                    Reference ref = references.elementAt(i);
                    StringItem referenceItem = new StringItem(null, ref.getHumanString(), 3, StyleSheet.list_itemStyle);
                    referenceItem.addCommand(COMMANDS.CMD_REMOVE_REFERENCE);
                    referenceItem.setItemCommandListener(this);
                    referenceItem.setAttribute(OBJECT, ref);
                    this.append(referenceItem);
                }
            }
            this.addReferences = new StringItem(null, Locale.get(55), 3, StyleSheet.buttonStyle);
            this.addReferences.setDefaultCommand(COMMANDS.CMD_SELECT);
            this.addReferences.setItemCommandListener(this);
            this.append(this.addReferences);
            this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
        }
    }

    public void commandAction(Command c, Item item) {
        if (c == COMMANDS.CMD_REMOVE_REFERENCE) {
            Object obj = item.getAttribute(OBJECT);
            if (obj instanceof Reference) {
                Reference ref = (Reference)obj;
                this.container.remove(item);
                EditNoteManager manager = EditNoteManager.getInstance();
                for (int i = 0; i < manager.getTempReferences().size(); ++i) {
                    if (manager.getTempReferences().elementAt(i) != ref) continue;
                    manager.getTempReferences().removeElementAt(i);
                }
            }
        } else if (item == this.addReferences) {
            Bookmark lastReaderBookmark = (Bookmark)OPTIONS.getOption(3);
            BookmarkChapterDescriptor bookmarkChapterDescriptor = new BookmarkChapterDescriptor(lastReaderBookmark);
            EVENT_SYSTEM.queueEvent(990051, bookmarkChapterDescriptor);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == COMMANDS.CMD_NAVIGATION_BACK) {
            EditNoteManager manager = EditNoteManager.getInstance();
            ReferenceCollection work = manager.getTempReferences();
            ReferenceCollection current = manager.getNote().getReferences();
            if (work.size() != current.size()) {
                EVENT_SYSTEM.queueEvent(5, manager.getNote());
            } else {
                for (int i = 0; i < work.size(); ++i) {
                    if (current.contains(work.elementAt(i))) continue;
                    EVENT_SYSTEM.queueEvent(5, manager.getNote());
                    break;
                }
            }
            super.commandAction(c, d);
        } else {
            super.commandAction(c, d);
        }
    }
}

