/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.live;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.LiveManager;
import com.youversion.application.model.reader.BookmarkChapterDescriptor;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.Bookmark;
import com.youversion.objects.LiveEvent;
import com.youversion.objects.LiveEventItem;
import com.youversion.objects.LiveEventItemGiving;
import com.youversion.objects.LiveEventItemLink;
import com.youversion.objects.LiveEventItemPoll;
import com.youversion.objects.LiveEventItemReference;
import com.youversion.objects.LiveEventItemShare;
import com.youversion.objects.Reference;
import com.youversion.objects.User;
import com.youversion.objects.Verse;
import com.youversion.objects.VerseCollection;
import com.youversion.polish.extensions.item.LiveEventContentItem;
import com.youversion.polish.extensions.item.LiveEventLinkItem;
import com.youversion.utils.TextUtil;
import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TextField;
import de.enough.polish.util.Locale;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;

public class LiveEventItemForm
extends BaseForm
implements ItemCommandListener {
    private static final String KEY_RESPONSE_INDEX = "obj";
    private LiveEvent liveEvent = LiveManager.getInstance().getLiveEvent();
    private LiveEventItem liveEventItem;
    private TextField qaResponseField;
    private StringItem qaSubmitButton;
    private TextField prayerRequestField;
    private TextField prayerNameField;
    private TextField prayerMailField;
    private StringItem prayerSubmitButton;
    private StringItem shareButton;

    public LiveEventItemForm() {
        this((Style)null);
    }

    public LiveEventItemForm(Style style) {
        super(style);
        LiveEventContentItem contentItem;
        Object liveEventObject = LiveManager.getInstance().getLiveEventItem();
        if (liveEventObject instanceof LiveEvent) {
            contentItem = new LiveEventContentItem(-1, null);
            this.setContent(-1, null, contentItem.getContentList());
        } else if (liveEventObject instanceof LiveEventItem) {
            this.liveEventItem = (LiveEventItem)liveEventObject;
            contentItem = new LiveEventContentItem(this.liveEventItem.getTypeId(), this.liveEventItem.getTitle());
            this.setContent(this.liveEventItem.getTypeId(), this.liveEventItem, contentItem.getContentList());
        } else {
            throw new IllegalArgumentException("invalid live event item");
        }
        this.append(contentItem);
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public String getTitle() {
        return this.liveEvent.getTitle();
    }

    public void setContent(int typeId, LiveEventItem liveEventItem, Container contentList) {
        try {
            switch (typeId) {
                case 1: {
                    this.setReferenceContent((LiveEventItemReference)liveEventItem, contentList);
                    break;
                }
                case 4: 
                case 5: 
                case 9: {
                    this.setLinkContent((LiveEventItemLink)liveEventItem, contentList);
                    break;
                }
                case 2: 
                case 3: {
                    this.setNotesContent(liveEventItem, contentList);
                    break;
                }
                case 7: {
                    this.setQuestionAnswerContent(liveEventItem, contentList);
                    break;
                }
                case 6: {
                    this.setPollContent((LiveEventItemPoll)liveEventItem, contentList);
                    break;
                }
                case 8: {
                    this.setPrayerContent(liveEventItem, contentList);
                    break;
                }
                case 10: {
                    this.setGivingContent((LiveEventItemGiving)liveEventItem, contentList);
                    break;
                }
                case 11: {
                    this.setShareContent((LiveEventItemShare)liveEventItem, contentList);
                    break;
                }
                default: {
                    this.setEventInfoContent(this.liveEvent, contentList);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setEventInfoContent(LiveEvent liveEvent, Container contentList) {
        String[] params = new String[]{liveEvent.getSubtitle(), liveEvent.getGroupName(), liveEvent.getLiveDatetimeRange()};
        String descriptionText = Locale.get(0, params);
        StringItem descriptionItem = new StringItem(null, descriptionText, StyleSheet.live_content_textStyle);
        contentList.add(descriptionItem);
    }

    private void setReferenceContent(LiveEventItemReference liveEventItemReference, Container contentList) {
        LiveEventLinkItem linkItem = new LiveEventLinkItem(liveEventItemReference);
        linkItem.setDefaultCommand(COMMANDS.CMD_SELECT);
        linkItem.setItemCommandListener(this);
        contentList.add(linkItem);
        VerseCollection verseCollection = liveEventItemReference.getVerses();
        StringItem versesTextItem = this.getVersesText(verseCollection);
        contentList.add(versesTextItem);
    }

    private StringItem getVersesText(VerseCollection verseCollection) {
        StringBuffer versesTextBuffer = new StringBuffer();
        for (int index = 0; index < verseCollection.size(); ++index) {
            Verse verse = verseCollection.elementAt(index);
            String verseContent = TextUtil.stripBadCharactersFromVerseText(verse.getContent());
            versesTextBuffer.append(verseContent);
        }
        StringItem versesTextItem = new StringItem(null, versesTextBuffer.toString().trim(), StyleSheet.live_content_textStyle);
        return versesTextItem;
    }

    private void setLinkContent(LiveEventItemLink liveEventItemLink, Container contentList) {
        StringItem textItem = new StringItem(null, liveEventItemLink.getDescription(), StyleSheet.live_content_textStyle);
        contentList.add(textItem);
        LiveEventLinkItem linkItem = new LiveEventLinkItem(liveEventItemLink.getUrl());
        linkItem.setDefaultCommand(COMMANDS.CMD_SELECT);
        linkItem.setItemCommandListener(this);
        contentList.add(linkItem);
    }

    private void setNotesContent(LiveEventItem liveEventItem, Container contentList) {
        StringItem descriptionItem = new StringItem(null, liveEventItem.getData(), StyleSheet.live_content_textStyle);
        contentList.add(descriptionItem);
    }

    private void setQuestionAnswerContent(LiveEventItem liveEventItem, Container contentList) {
        StringItem questionItem = new StringItem(null, liveEventItem.getData(), StyleSheet.live_content_textStyle);
        contentList.add(questionItem);
        this.qaResponseField = new TextField(null, null, 512, 0, StyleSheet.textfieldStyle);
        this.qaResponseField.setHelpText(Locale.get(36));
        contentList.add(this.qaResponseField);
        StringItem noticeItem = new StringItem(null, Locale.get(35), StyleSheet.live_content_noticeStyle);
        contentList.add(noticeItem);
        this.qaSubmitButton = new StringItem(null, Locale.get(37), StyleSheet.buttonStyle);
        this.qaSubmitButton.setDefaultCommand(COMMANDS.CMD_SELECT);
        this.qaSubmitButton.setItemCommandListener(this);
        contentList.add(this.qaSubmitButton);
    }

    private void setPrayerContent(LiveEventItem liveEventItem, Container contentList) {
        StringItem descriptionItem = new StringItem(null, liveEventItem.getData(), StyleSheet.live_content_textStyle);
        contentList.add(descriptionItem);
        this.prayerRequestField = new TextField(null, null, 512, 0, StyleSheet.textfieldStyle);
        this.prayerRequestField.setHelpText(Locale.get(32));
        contentList.add(this.prayerRequestField);
        this.prayerNameField = new TextField(null, null, 512, 0, StyleSheet.textfieldStyle);
        this.prayerNameField.setHelpText(Locale.get(30));
        contentList.add(this.prayerNameField);
        this.prayerMailField = new TextField(null, null, 512, 0, StyleSheet.textfieldStyle);
        this.prayerMailField.setHelpText(Locale.get(29));
        contentList.add(this.prayerMailField);
        StringItem noticeItem = new StringItem(null, Locale.get(31), StyleSheet.live_content_noticeStyle);
        contentList.add(noticeItem);
        this.prayerSubmitButton = new StringItem(null, Locale.get(33), StyleSheet.buttonStyle);
        this.prayerSubmitButton.setDefaultCommand(COMMANDS.CMD_SELECT);
        this.prayerSubmitButton.setItemCommandListener(this);
        contentList.add(this.prayerSubmitButton);
    }

    private void setShareContent(LiveEventItemShare liveEventItemShare, Container contentList) {
        StringItem descriptionItem = new StringItem(null, liveEventItemShare.getPrefilledMessage(), StyleSheet.live_content_textStyle);
        contentList.add(descriptionItem);
        this.shareButton = new StringItem(null, Locale.get(147), StyleSheet.buttonStyle);
        this.shareButton.setDefaultCommand(COMMANDS.CMD_SELECT);
        this.shareButton.setItemCommandListener(this);
        contentList.add(this.shareButton);
    }

    private void setGivingContent(LiveEventItemGiving liveEventItemGiving, Container contentList) {
        StringItem descriptionItem = new StringItem(null, liveEventItemGiving.getDescription(), StyleSheet.live_content_textStyle);
        contentList.add(descriptionItem);
        LiveEventLinkItem linkItem = new LiveEventLinkItem(liveEventItemGiving.getGivingData());
        linkItem.setDefaultCommand(COMMANDS.CMD_SELECT);
        linkItem.setItemCommandListener(this);
        contentList.add(linkItem);
    }

    private void setPollContent(LiveEventItemPoll liveEventItemPoll, Container contentList) {
        StringItem descriptionItem = new StringItem(null, liveEventItemPoll.getQuestion(), StyleSheet.live_content_textStyle);
        contentList.add(descriptionItem);
        Vector responses = liveEventItemPoll.getResponses();
        for (int index = 0; index < responses.size(); ++index) {
            String response = (String)responses.elementAt(index);
            ChoiceItem responseItem = new ChoiceItem(response, null, 2, StyleSheet.checkboxStyle);
            responseItem.setDefaultCommand(COMMANDS.CMD_SELECT);
            responseItem.setAttribute(KEY_RESPONSE_INDEX, new Integer(index));
            responseItem.setItemCommandListener(this);
            contentList.add(responseItem);
        }
    }

    public void commandAction(Command c, Item item) {
        if (item == this.prayerSubmitButton) {
            Integer id = new Integer(this.liveEventItem.getId());
            String request = this.prayerRequestField.getText();
            String name = this.prayerNameField.getText();
            String mail = this.prayerMailField.getText();
            if (LiveEventItemForm.isInputValid(request) && LiveEventItemForm.isInputValid(name) && LiveEventItemForm.isInputValid(mail)) {
                Object[] payload = new Object[]{id, request, name, mail};
                EVENT_SYSTEM.queueEvent(200038, payload);
            } else {
                String errorMessage = Locale.get(28);
                LiveEventItemForm.showError(errorMessage);
            }
        } else if (item == this.qaSubmitButton) {
            Integer id = new Integer(this.liveEventItem.getId());
            User user = OPTIONS.getUser();
            String uniqueId = user.getUsername();
            String response = this.qaResponseField.getText();
            if (LiveEventItemForm.isInputValid(response)) {
                Object[] payload = new Object[]{id, uniqueId, response};
                Event qaEvent = new Event(200040, payload);
                if (OPTIONS.isLoggedIn()) {
                    EVENT_SYSTEM.queueEvent(qaEvent);
                } else {
                    OPTIONS.handleLogin(qaEvent);
                }
            } else {
                String errorMessage = Locale.get(28);
                LiveEventItemForm.showError(errorMessage);
            }
        } else if (item == this.shareButton) {
            LiveEventItemShare liveEventItemShare = (LiveEventItemShare)this.liveEventItem;
            Event shareEvent = new Event(990011, new String[]{liveEventItemShare.getPrefilledMessage(), this.liveEvent.getShortUrl()});
            if (OPTIONS.isLoggedIn()) {
                EVENT_SYSTEM.queueEvent(shareEvent);
            } else {
                OPTIONS.handleLogin(shareEvent);
            }
        } else if (item instanceof ChoiceItem) {
            LiveEventItemPoll liveEventItemPoll = (LiveEventItemPoll)this.liveEventItem;
            Integer id = new Integer(liveEventItemPoll.getId());
            User user = OPTIONS.getUser();
            String uniqueId = user.getUsername();
            Integer pollIndex = (Integer)item.getAttribute(KEY_RESPONSE_INDEX);
            String response = (String)liveEventItemPoll.getResponses().elementAt(pollIndex);
            Object[] payload = new Object[]{id, uniqueId, response};
            Event pollEvent = new Event(200042, payload);
            if (OPTIONS.isLoggedIn()) {
                EVENT_SYSTEM.queueEvent(pollEvent);
            } else {
                OPTIONS.handleLogin(pollEvent);
            }
        } else if (item instanceof LiveEventLinkItem) {
            LiveEventLinkItem liveEventLinkItem = (LiveEventLinkItem)item;
            String url = liveEventLinkItem.getUrl();
            LiveEventItemReference itemReference = liveEventLinkItem.getReference();
            if (url != null) {
                try {
                    StyleSheet.midlet.platformRequest(url);
                }
                catch (ConnectionNotFoundException e) {
                    e.printStackTrace();
                }
            } else if (itemReference != null) {
                VerseCollection verseCollection = itemReference.getVerses();
                Reference reference = verseCollection.elementAt(0).getReference();
                Bookmark bookmark = new Bookmark(itemReference.getVersion(), reference);
                BookmarkChapterDescriptor bookmarkChapterDescriptor = new BookmarkChapterDescriptor(bookmark);
                EVENT_SYSTEM.queueEvent(990004, 2, bookmarkChapterDescriptor);
            }
        }
    }

    private static boolean isInputValid(String text) {
        return text != null && !"".equals(text.trim());
    }

    private static void showError(String message) {
        String title = Locale.get(138);
        Object[] payload = new Object[]{title, message, null};
        EVENT_SYSTEM.queueEvent(990014, payload);
    }

    public void hideNotify() {
        super.hideNotify();
        EVENT_SYSTEM.queueEvent(998882, this);
    }
}

