/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.live;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.model.LiveManager;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.LiveEvent;
import com.youversion.objects.LiveEventItem;
import com.youversion.objects.LiveEventItemCollection;
import com.youversion.polish.extensions.item.LiveEventEntryItem;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.Style;

public class LiveEventForm
extends BaseForm
implements ItemCommandListener {
    private static final String KEY_INDEX = "index";
    private static final Integer INDEX_EVENT_INFO = new Integer(-1);
    private LiveEvent liveEvent;

    public LiveEventForm() {
        this((Style)null);
    }

    public String getTitle() {
        return this.liveEvent.getTitle();
    }

    public LiveEventForm(Style style) {
        super(style);
        LiveManager liveManager = LiveManager.getInstance();
        this.liveEvent = liveManager.getLiveEvent();
        LiveEventEntryItem entryItem = new LiveEventEntryItem(-1, this.liveEvent.getTitle());
        entryItem.setDefaultCommand(COMMANDS.CMD_SELECT);
        entryItem.setAttribute(KEY_INDEX, INDEX_EVENT_INFO);
        entryItem.setItemCommandListener(this);
        this.append(entryItem);
        LiveEventItemCollection liveEventItemCollection = this.liveEvent.getItems();
        for (int index = 0; index < liveEventItemCollection.size(); ++index) {
            LiveEventItem liveEventItem = (LiveEventItem)liveEventItemCollection.elementAt(index);
            entryItem = new LiveEventEntryItem(liveEventItem.getTypeId(), liveEventItem.getTitle());
            entryItem.setDefaultCommand(COMMANDS.CMD_SELECT);
            entryItem.setAttribute(KEY_INDEX, new Integer(index));
            entryItem.setItemCommandListener(this);
            this.append(entryItem);
        }
        this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
    }

    public void commandAction(Command c, Item item) {
        int index = (Integer)item.getAttribute(KEY_INDEX);
        if (index == INDEX_EVENT_INFO) {
            LiveManager.getInstance().setLiveEventItem(this.liveEvent);
        } else {
            LiveEventItemCollection collection = this.liveEvent.getItems();
            LiveEventItem liveEventItem = (LiveEventItem)collection.elementAt(index);
            LiveManager.getInstance().setLiveEventItem(liveEventItem);
        }
        EVENT_SYSTEM.queueEvent(990049, 2);
    }
}

