/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views.bookmarks;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.model.BookmarksManager;
import com.youversion.application.model.reader.BookmarkChapterDescriptor;
import com.youversion.application.views.AlertForm;
import com.youversion.application.views.core.BaseForm;
import com.youversion.objects.Bookmark;
import com.youversion.objects.BookmarkCollection;
import com.youversion.polish.extensions.item.BookmarkItem;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class BookmarksForm
extends BaseForm
implements ItemCommandListener {
    protected static final String KEY_BOOKMARK = "obj";
    private BookmarkCollection bookmarks;
    private int page;
    private Container loadingContainer = new Container(false, StyleSheet.splash_screenStyle);
    private Gauge loadingGauge = new Gauge(null, false, -1, 2, StyleSheet.loading_gaugeStyle);

    public BookmarksForm() {
        this((Style)null);
    }

    public BookmarksForm(Style style) {
        super(style);
        this.loadingContainer.add(this.loadingGauge);
    }

    public String getTitle() {
        if (BookmarksManager.getInstance().getCurrentLabelFilter() == null) {
            return Locale.get(19);
        }
        String labelText = BookmarksManager.getInstance().getCurrentLabelFilter().getLabel();
        return Locale.get(7, labelText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoading() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.removeAllCommands();
            this.append(this.loadingContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            this.removeAllCommands();
            BookmarksManager bookmarksManager = BookmarksManager.getInstance();
            this.bookmarks = bookmarksManager.getBookmarkCollection();
            this.page = bookmarksManager.getPage();
            if (this.bookmarks != null && this.bookmarks.size() > 0) {
                for (int index = 0; index < this.bookmarks.size(); ++index) {
                    Bookmark bookmark = (Bookmark)this.bookmarks.elementAt(index);
                    BookmarkItem bookmarkItem = new BookmarkItem(bookmark);
                    bookmarkItem.setAttribute(KEY_BOOKMARK, bookmark);
                    bookmarkItem.setDefaultCommand(COMMANDS.CMD_SELECT);
                    bookmarkItem.addCommand(COMMANDS.CMD_BOOKMARKS_DELETE);
                    bookmarkItem.addCommand(COMMANDS.CMD_BOOKMARKS_EDIT);
                    bookmarkItem.setItemCommandListener(this);
                    this.container.add(bookmarkItem);
                }
                int total = this.bookmarks.getTotal();
                int pages = (int)Math.ceil(1.0 * (double)total / 25.0);
                if (this.page > 1) {
                    this.addCommand(COMMANDS.CMD_PREVIOUS_PAGE);
                }
                if (this.page < pages) {
                    this.addCommand(COMMANDS.CMD_NEXT_PAGE);
                }
            } else {
                StringItem noBookmarks = new StringItem(null, Locale.get(17), 0, StyleSheet.textStyle);
                this.container.add(noBookmarks);
            }
            if (bookmarksManager.getCurrentLabelFilter() != null) {
                this.addCommand(COMMANDS.CMD_BOOKMARKS_REMOVE_FILTER);
            }
            this.addCommand(COMMANDS.CMD_BOOKMARKS_SHOW_LABELS);
            this.addCommand(COMMANDS.CMD_NAVIGATION_BACK);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (COMMANDS.CMD_NEXT_PAGE == c) {
            EVENT_SYSTEM.queueEvent(100008, 2, new Integer(this.page + 1));
        } else if (COMMANDS.CMD_PREVIOUS_PAGE == c) {
            EVENT_SYSTEM.queueEvent(100008, 2, new Integer(this.page - 1));
        } else if (COMMANDS.CMD_YES == c) {
            Item item = (Item)COMMANDS.CMD_YES.getData();
            Bookmark bookmark = (Bookmark)item.getAttribute(KEY_BOOKMARK);
            EVENT_SYSTEM.queueEvent(100011, 2, bookmark);
        } else if (COMMANDS.CMD_BOOKMARKS_SHOW_LABELS == c) {
            EVENT_SYSTEM.queueEvent(99056);
        } else if (COMMANDS.CMD_BOOKMARKS_REMOVE_FILTER == c) {
            EVENT_SYSTEM.queueEvent(100017, 2, null);
            EVENT_SYSTEM.queueEvent(100008, 2, new Integer(1));
        } else {
            super.commandAction(c, d);
        }
    }

    public void commandAction(Command c, Item item) {
        if (COMMANDS.CMD_BOOKMARKS_DELETE == c) {
            AlertForm.showQuestionDialog(Locale.get(142), Locale.get(134), this, item);
        } else if (COMMANDS.CMD_SELECT == c) {
            Bookmark bookmark = (Bookmark)item.getAttribute(KEY_BOOKMARK);
            BookmarkChapterDescriptor bookmarkChapterDescriptor = new BookmarkChapterDescriptor(bookmark);
            EVENT_SYSTEM.queueEvent(990004, 2, bookmarkChapterDescriptor);
        } else if (COMMANDS.CMD_BOOKMARKS_EDIT == c) {
            Bookmark bookmark = (Bookmark)item.getAttribute(KEY_BOOKMARK);
            EVENT_SYSTEM.queueEvent(99055, bookmark);
        }
    }

    public boolean handleKeyReleased(int keycode, int gameAction) {
        if (this.bookmarks == null) {
            return false;
        }
        int total = this.bookmarks.getTotal();
        int pages = (int)Math.ceil(1.0 * (double)total / 25.0);
        if (this.page > 1 && gameAction == 2) {
            this.handleCommand(COMMANDS.CMD_PREVIOUS_PAGE);
            return true;
        }
        if (this.page < pages && gameAction == 5) {
            this.handleCommand(COMMANDS.CMD_NEXT_PAGE);
            return true;
        }
        return super.handleKeyReleased(keycode, gameAction);
    }
}

