/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.views;

import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.global.COMMANDS;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.reader.BookmarkChapterDescriptor;
import com.youversion.application.views.core.StaticBaseForm;
import com.youversion.objects.Bookmark;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.IconCustomItem;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.Ticker;
import de.enough.polish.util.Locale;
import javax.microedition.io.ConnectionNotFoundException;

public class DashboardForm
extends StaticBaseForm
implements ItemCommandListener {
    protected static final String OBJECT = "obj";
    protected static final String KEY_READER = "reader";
    protected static final String KEY_BIBLE = "bible";
    protected static final String KEY_PLANS = "plans";
    protected static final String KEY_NOTES = "notes";
    protected static final String KEY_BOOKMARKS = "bookmarks";
    protected static final String KEY_LIVE = "live";
    protected static final String KEY_SETTINGS = "settings";
    protected static final String KEY_HELP = "help";
    protected static final String KEY_ABOUT = "about";
    protected static final String KEY_SEARCH = "search";
    protected static final String KEY_SHARE = "share";
    protected static final String KEY_NOTIFICATIONS = "notifications";

    public DashboardForm() {
        this((Style)null);
    }

    public DashboardForm(Style style) {
        super(style);
    }

    public String getTitle() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFormContent() {
        Object object = this.getPaintLock();
        synchronized (object) {
            this.container.clear();
            if (this.bottomFrame != null) {
                this.bottomFrame.clear();
            }
            if (this.topFrame != null) {
                this.topFrame.clear();
            }
            this.resetScreenCommands();
            Container logoContainer = new Container(StyleSheet.logo_containerStyle);
            IconItem logo = new IconItem(null, null, StyleSheet.logoStyle);
            logo.setAppearanceMode(0);
            logoContainer.add(logo);
            this.append(16, logoContainer);
            Container dashboardItems = new Container(StyleSheet.dashboard_tableStyle);
            dashboardItems.allowCycling = false;
            Container readerContainer = new Container(StyleSheet.dashboard_table_item_containerStyle);
            IconCustomItem readerItem = new IconCustomItem(Locale.get(7).trim(), null, StyleSheet.dashboard_reader_itemStyle);
            readerItem.setAttribute(OBJECT, KEY_READER);
            readerItem.setDefaultCommand(COMMANDS.CMD_SELECT);
            readerItem.setItemCommandListener(this);
            readerContainer.add(readerItem);
            dashboardItems.add(readerContainer);
            Container notesContainer = new Container(StyleSheet.dashboard_table_item_containerStyle);
            IconCustomItem notesItem = new IconCustomItem(Locale.get(4).trim(), null, StyleSheet.dashboard_notes_itemStyle);
            notesItem.setAttribute(OBJECT, KEY_NOTES);
            notesItem.setDefaultCommand(COMMANDS.CMD_SELECT);
            notesItem.setItemCommandListener(this);
            notesContainer.add(notesItem);
            dashboardItems.add(notesContainer);
            Container plansContainer = new Container(StyleSheet.dashboard_table_item_containerStyle);
            IconCustomItem plansItem = new IconCustomItem(Locale.get(6).trim(), null, StyleSheet.dashboard_plans_itemStyle);
            plansItem.setAttribute(OBJECT, KEY_PLANS);
            plansItem.setDefaultCommand(COMMANDS.CMD_SELECT);
            plansItem.setItemCommandListener(this);
            plansContainer.add(plansItem);
            dashboardItems.add(plansContainer);
            Container bookmarksContainer = new Container(StyleSheet.dashboard_table_item_containerStyle);
            IconCustomItem bookmarksItem = new IconCustomItem(Locale.get(1).trim(), null, StyleSheet.dashboard_bookmarks_itemStyle);
            bookmarksItem.setAttribute(OBJECT, KEY_BOOKMARKS);
            bookmarksItem.setDefaultCommand(COMMANDS.CMD_SELECT);
            bookmarksItem.setItemCommandListener(this);
            bookmarksContainer.add(bookmarksItem);
            dashboardItems.add(bookmarksContainer);
            Container liveContainer = new Container(StyleSheet.dashboard_table_item_containerStyle);
            IconCustomItem liveItem = new IconCustomItem(Locale.get(3).trim(), null, StyleSheet.dashboard_live_itemStyle);
            liveItem.setAttribute(OBJECT, KEY_LIVE);
            liveItem.setDefaultCommand(COMMANDS.CMD_SELECT);
            liveItem.setItemCommandListener(this);
            liveContainer.add(liveItem);
            dashboardItems.add(liveContainer);
            Container settingsContainer = new Container(StyleSheet.dashboard_table_item_containerStyle);
            IconCustomItem settingsItem = new IconCustomItem(Locale.get(9).trim(), null, StyleSheet.dashboard_settings_itemStyle);
            settingsItem.setAttribute(OBJECT, KEY_SETTINGS);
            settingsItem.setDefaultCommand(COMMANDS.CMD_SELECT);
            settingsItem.setItemCommandListener(this);
            settingsContainer.add(settingsItem);
            dashboardItems.add(settingsContainer);
            boolean highRes = false;
            if (this.getWidth() >= 360) {
                highRes = true;
            }
            Object dummyDashboardOptions = null;
            this.addCommand(COMMANDS.CMD_DASHBOARD_SHARE, StyleSheet.dashboard_share_itemStyle);
            this.addCommand(COMMANDS.CMD_DASHBOARD_ABOUT, StyleSheet.dashboard_about_itemStyle);
            this.addCommand(COMMANDS.CMD_DASHBOARD_SEARCH, StyleSheet.dashboard_search_itemStyle);
            this.addCommand(COMMANDS.CMD_EXIT, StyleSheet.dashboard_exit_itemStyle);
            this.append(-1, dashboardItems);
            Ticker ticker = new Ticker("18 minutes until the YouVersion Webcast", StyleSheet.tickerStyle);
            ticker.setDefaultCommand(COMMANDS.CMD_SELECT);
            ticker.setAppearanceMode(2);
            ticker.setAttribute(OBJECT, KEY_NOTIFICATIONS);
            this.requestInit();
            this.requestRepaint();
        }
    }

    public void commandAction(Command c, Item item) {
        if (COMMANDS.CMD_SELECT == c) {
            if (item.getAttribute(OBJECT) == KEY_READER) {
                Bookmark lastReaderBookmark = (Bookmark)OPTIONS.getOption(3);
                BookmarkChapterDescriptor bookmarkChapterDescriptor = new BookmarkChapterDescriptor(lastReaderBookmark);
                EVENT_SYSTEM.queueEvent(990004, bookmarkChapterDescriptor);
            } else if (item.getAttribute(OBJECT) == KEY_SETTINGS) {
                EVENT_SYSTEM.queueEvent(990009);
            } else if (item.getAttribute(OBJECT) == KEY_BOOKMARKS) {
                EVENT_SYSTEM.queueEvent(990010);
            } else if (item.getAttribute(OBJECT) == KEY_SHARE) {
                EVENT_SYSTEM.queueEvent(990011, new Object[]{Locale.get(148), Locale.get(149)});
            } else if (item.getAttribute(OBJECT) == KEY_ABOUT) {
                EVENT_SYSTEM.queueEvent(990039);
            } else if (item.getAttribute(OBJECT) == KEY_PLANS) {
                if (((Object[])OPTIONS.getOption(1))[2] != null) {
                    EVENT_SYSTEM.queueEvent(990038);
                } else {
                    EVENT_SYSTEM.queueEvent(990012);
                }
            } else if (item.getAttribute(OBJECT) == KEY_SEARCH) {
                EVENT_SYSTEM.queueEvent(990041);
            } else if (item.getAttribute(OBJECT) == KEY_LIVE) {
                EVENT_SYSTEM.queueEvent(990047);
            } else if (item.getAttribute(OBJECT) == KEY_NOTES) {
                EVENT_SYSTEM.queueEvent(990042);
            } else if (item.getAttribute(OBJECT) != null) {
                String caption = (String)item.getAttribute(OBJECT);
                caption = caption.toUpperCase();
                EVENT_SYSTEM.queueEvent(999999, caption);
            }
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (COMMANDS.CMD_EXIT == c) {
            EVENT_SYSTEM.queueEvent(1);
            EVENT_SYSTEM.queueEvent(2);
        } else if (COMMANDS.CMD_DASHBOARD_SHARE == c) {
            EVENT_SYSTEM.queueEvent(990011, new Object[]{Locale.get(148), Locale.get(149)});
        } else if (COMMANDS.CMD_DASHBOARD_ABOUT == c) {
            EVENT_SYSTEM.queueEvent(990039);
        } else if (COMMANDS.CMD_DASHBOARD_SEARCH == c) {
            EVENT_SYSTEM.queueEvent(990041);
        } else if (COMMANDS.CMD_DASHBOARD_HELP == c) {
            String link = Locale.get(23);
            try {
                StyleSheet.midlet.platformRequest(link);
            }
            catch (ConnectionNotFoundException e) {}
        } else {
            super.commandAction(c, d);
        }
    }
}

