/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.controllers.navigation;

import com.youversion.application.controllers.core.NavigationController;
import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.application.events.core.EventListener;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.EditNoteManager;
import com.youversion.application.model.MyNotesManager;
import com.youversion.application.model.ReferenceNotesManager;
import com.youversion.application.model.ViewNoteManager;
import com.youversion.application.views.core.Notification;
import com.youversion.application.views.notes.EditNoteForm;
import com.youversion.application.views.notes.EditNoteReferencesForm;
import com.youversion.application.views.notes.MyNotesForm;
import com.youversion.application.views.notes.ReferenceNotesForm;
import com.youversion.application.views.notes.ViewNoteForm;
import com.youversion.objects.Note;
import com.youversion.objects.NoteCollection;
import com.youversion.objects.ReferenceCollection;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class NotesController
extends NavigationController
implements EventListener {
    MyNotesForm myNotesForm = null;
    ReferenceNotesForm referenceNotesForm = null;
    EditNoteReferencesForm editNoteReferencesForm = null;
    EditNoteForm editNoteForm = null;

    public void processEvent(Event event) {
        switch (event.getType()) {
            case 990042: {
                this.handleShowMyNotesForm(event);
                break;
            }
            case 200030: {
                NotesController.showLoading();
                break;
            }
            case 990043: {
                ViewNoteForm viewNoteForm = new ViewNoteForm(StyleSheet.base_screenStyle);
                ViewNoteManager.getInstance().setNote((Note)event.getPayload());
                viewNoteForm.addFormContent();
                NotesController.showDisplayable(viewNoteForm);
                break;
            }
            case 990044: {
                this.handleShowReferenceNotesFromAll(event);
                break;
            }
            case 200031: {
                this.handleReceivedMyNotes(event);
                break;
            }
            case 200032: {
                NotesController.showLoading();
                break;
            }
            case 200033: {
                this.handleReceivedPublicNotesForReference(event);
                break;
            }
            case 990046: {
                this.handleShowEditNoteForm(event);
                break;
            }
            case 990050: {
                this.handleShowEditNoteReferencesForm(event);
                break;
            }
            case 200046: {
                NotesController.showLoading();
                break;
            }
            case 200047: {
                NotesController.hideLoading();
                this.handleConfirmationSaveNote(event);
                break;
            }
            case 200048: {
                NotesController.hideLoading();
                this.handleConfirmationCreateNote(event);
                break;
            }
            case 200049: {
                NotesController.showLoading();
                break;
            }
            case 200050: {
                this.handleConfirmDeleteNote(event);
                break;
            }
            case 100013: {
                this.handleUpdateNoteReferences(event);
                break;
            }
            case 5: {
                this.handleNotifyObjectChange(event);
            }
        }
    }

    public void handleNotifyObjectChange(Event event) {
        Object obj = event.getPayload();
        EditNoteManager manager = EditNoteManager.getInstance();
        Note note = manager.getNote();
        if (note == obj) {
            if (this.editNoteForm != null) {
                this.editNoteForm.setChanged(true);
            }
            if (this.editNoteReferencesForm != null) {
                this.editNoteReferencesForm.addFormContent();
            }
        }
    }

    public void handleUpdateNoteReferences(Event event) {
        Object[] payload = (Object[])event.getPayload();
        Note note = (Note)payload[0];
        ReferenceCollection collection = (ReferenceCollection)payload[1];
        note.setReferences(collection);
        EditNoteManager manager = EditNoteManager.getInstance();
        if (manager.getNote() != null && manager.getNote().getId() == note.getId()) {
            manager.setTempReferences(collection);
        }
        if (this.editNoteReferencesForm != null) {
            this.editNoteReferencesForm.addFormContent();
        }
    }

    public void handleConfirmDeleteNote(Event event) {
        EditNoteManager manager = EditNoteManager.getInstance();
        if (manager.getContext() == 1) {
            MyNotesManager myNotes = MyNotesManager.getInstance();
            EVENT_SYSTEM.queueEvent(200030, 2, new Object[]{myNotes.getPage(), null, myNotes.getMode()});
        }
        if (this.myNotesForm != null) {
            Notification.show(Locale.get(49), this.myNotesForm);
        }
    }

    public void handleConfirmationCreateNote(Event event) {
        Note note = (Note)event.getPayload();
        EditNoteManager manager = EditNoteManager.getInstance();
        if (manager.getContext() == 1) {
            MyNotesManager myNotes = MyNotesManager.getInstance();
            EVENT_SYSTEM.queueEvent(200030, 2, new Object[]{myNotes.getPage(), null, myNotes.getMode()});
        }
    }

    public void handleConfirmationSaveNote(Event event) {
        Note note = (Note)event.getPayload();
        EditNoteManager manager = EditNoteManager.getInstance();
        if (manager.getContext() == 1 && this.myNotesForm != null) {
            this.myNotesForm.updateNotes(note);
        }
        if (this.myNotesForm != null) {
            Notification.show(Locale.get(50), this.myNotesForm);
        }
    }

    public void handleShowEditNoteReferencesForm(Event event) {
        Note note = (Note)event.getPayload();
        if (note != EditNoteManager.getInstance().getNote()) {
            EditNoteManager.getInstance().setNote(note);
            EditNoteManager.getInstance().copyReferencesToTemp();
        }
        this.editNoteReferencesForm = new EditNoteReferencesForm(StyleSheet.base_screenStyle);
        this.editNoteReferencesForm.addFormContent();
        NotesController.showDisplayable(this.editNoteReferencesForm);
    }

    public void handleShowEditNoteForm(Event event) {
        Note note = (Note)event.getPayload();
        EditNoteManager.getInstance().setNote(note);
        EditNoteManager.getInstance().copyReferencesToTemp();
        if (this.editNoteForm == null) {
            this.editNoteForm = new EditNoteForm(StyleSheet.base_screenStyle);
        }
        this.editNoteForm.setChanged(false);
        this.editNoteForm.addFormContent();
        NotesController.showDisplayable(this.editNoteForm);
    }

    public void handleReceivedPublicNotesForReference(Event event) {
        Object[] payload = (Object[])event.getPayload();
        Integer page = (Integer)payload[0];
        ReferenceCollection references = (ReferenceCollection)payload[1];
        NoteCollection notes = (NoteCollection)payload[2];
        ReferenceNotesManager manager = ReferenceNotesManager.getInstance();
        manager.setPage(page);
        manager.setNoteCollection(notes);
        manager.setReferences(references);
        manager.setMode("all");
        ReferenceNotesForm form = new ReferenceNotesForm(StyleSheet.base_screenStyle);
        form.addFormContent();
        NotesController.showDisplayable(form);
    }

    public void handleShowReferenceNotesFromAll(Event event) {
        EVENT_SYSTEM.queueEvent(200032, 2, new Object[]{new Integer(1), event.getPayload()});
    }

    public void handleShowMyNotesForm(Event event) {
        if (((Object[])OPTIONS.getOption(1))[2] == null) {
            Event loginEvent = new Event(990008, event);
            EVENT_SYSTEM.queueEvent(990014, new Object[]{Locale.get(142), Locale.get(150), loginEvent});
        } else {
            NotesController.showLoading();
            EVENT_SYSTEM.queueEvent(200030, 2, new Object[]{new Integer(1), null, null});
        }
    }

    public void handleReceivedMyNotes(Event event) {
        Object[] payload = (Object[])event.getPayload();
        Integer localPage = (Integer)payload[0];
        String localMode = (String)payload[2];
        NoteCollection localResults = (NoteCollection)payload[3];
        if (payload[1] == null) {
            MyNotesManager manager = MyNotesManager.getInstance();
            manager.setPage(localPage);
            manager.setNoteCollection(localResults);
            manager.setMode(localMode);
            if (this.myNotesForm == null) {
                this.myNotesForm = new MyNotesForm(StyleSheet.base_screenStyle);
            }
            this.myNotesForm.addFormContent();
            NotesController.showDisplayable(this.myNotesForm);
        } else {
            Integer page = (Integer)payload[0];
            ReferenceCollection references = (ReferenceCollection)payload[1];
            NoteCollection notes = (NoteCollection)payload[2];
            ReferenceNotesManager manager = ReferenceNotesManager.getInstance();
            manager.setPage(page);
            manager.setNoteCollection(notes);
            manager.setReferences(references);
            manager.setMode("my");
            if (this.referenceNotesForm == null) {
                this.referenceNotesForm = new ReferenceNotesForm(StyleSheet.base_screenStyle);
            }
            this.referenceNotesForm.addFormContent();
            NotesController.showDisplayable(this.referenceNotesForm);
        }
    }

    public void release() {
        this.myNotesForm = null;
        this.referenceNotesForm = null;
        this.editNoteReferencesForm = null;
        this.editNoteForm = null;
    }
}

