/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.controllers.navigation;

import com.flurry.javame.FlurryAgent;
import com.youversion.application.controllers.core.NavigationController;
import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.application.events.core.EventListener;
import com.youversion.application.global.GLOBAL;
import com.youversion.application.global.NAVIGATION_HISTORY;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.model.BibleReaderManager;
import com.youversion.application.model.BookmarksManager;
import com.youversion.application.model.LiveManager;
import com.youversion.application.model.MyNotesManager;
import com.youversion.application.model.ReadingPlansManager;
import com.youversion.application.model.ReferenceNotesManager;
import com.youversion.application.model.ViewNoteManager;
import com.youversion.application.views.AboutForm;
import com.youversion.application.views.AlertForm;
import com.youversion.application.views.DashboardForm;
import com.youversion.application.views.HelpForm;
import com.youversion.application.views.ShareForm;
import com.youversion.application.views.SplashForm;
import com.youversion.application.views.bookmarks.BookmarksForm;
import com.youversion.application.views.live.LiveEventSearchForm;
import com.youversion.application.views.notes.MyNotesForm;
import com.youversion.application.views.plans.BiblePlansAllPlansForm;
import com.youversion.application.views.plans.BiblePlansMyPlansForm;
import com.youversion.application.views.reader.BibleReadChapterForm;
import com.youversion.application.views.settings.SettingsForm;
import com.youversion.application.views.settings.SettingsLanguageForm;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Locale;

public class GeneralNavigationController
extends NavigationController
implements EventListener {
    private DashboardForm dashboardForm;
    private SettingsForm settingsForm;

    public void processEvent(Event event) {
        switch (event.getType()) {
            case 990014: {
                Object[] alertPayload = (Object[])event.getPayload();
                String title = (String)alertPayload[0];
                String message = (String)alertPayload[1];
                Event dismissEvent = (Event)alertPayload[2];
                AlertForm alertForm = new AlertForm(title, message, dismissEvent, StyleSheet.alertStyle);
                GeneralNavigationController.showDisplayable(alertForm);
                break;
            }
            case 990011: {
                if (!OPTIONS.isLoggedIn()) {
                    Event loginEvent = new Event(990008, event);
                    EVENT_SYSTEM.queueEvent(990014, new Object[]{Locale.get(142), Locale.get(150), loginEvent});
                    break;
                }
                Object[] sharePayload = (Object[])event.getPayload();
                String text = (String)sharePayload[0];
                String link = (String)sharePayload[1];
                ShareForm shareForm = new ShareForm(text, link, StyleSheet.base_screenStyle);
                GeneralNavigationController.showDisplayable(shareForm);
                break;
            }
            case 990039: {
                AboutForm aboutForm = new AboutForm(StyleSheet.about_screenStyle);
                GeneralNavigationController.showDisplayable(aboutForm);
                break;
            }
            case 990009: {
                if (this.settingsForm == null) {
                    this.settingsForm = new SettingsForm(StyleSheet.base_screenStyle);
                }
                this.settingsForm.setContent();
                GeneralNavigationController.showDisplayable(this.settingsForm);
                break;
            }
            case 990040: {
                SettingsLanguageForm settingsLanguageForm = new SettingsLanguageForm(StyleSheet.base_screenStyle);
                GeneralNavigationController.showDisplayable(settingsLanguageForm);
                break;
            }
            case 999999: {
                throw new IllegalArgumentException("sorry, no dummy form left");
            }
            case 990037: {
                SplashForm splashForm = new SplashForm(StyleSheet.splash_screenStyle);
                NAVIGATION_HISTORY.showDisplayable(splashForm);
                break;
            }
            case 990006: {
                if (this.dashboardForm == null) {
                    this.dashboardForm = new DashboardForm(StyleSheet.dashboardscreenStyle);
                }
                GeneralNavigationController.showDisplayable(this.dashboardForm);
                break;
            }
            case 998881: {
                Screen screen = NAVIGATION_HISTORY.peek();
                if (event.getPayload() == null) {
                    NAVIGATION_HISTORY.pop();
                } else {
                    NAVIGATION_HISTORY.popFrom((Screen)event.getPayload());
                }
                Object releasePayload = this.getReleasePayload(screen);
                EVENT_SYSTEM.queueEvent(1000001, releasePayload);
                break;
            }
            case 998882: {
                NAVIGATION_HISTORY.removeFromStack((Screen)event.getPayload());
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                try {
                    FlurryAgent.onDestroyApp();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                NAVIGATION_HISTORY.getMIDlet().notifyDestroyed();
                break;
            }
            case 770002: {
                GeneralNavigationController.showLoading();
                break;
            }
            case 770003: {
                GeneralNavigationController.hideLoading();
                break;
            }
            case 6: {
                this.handleComplexEvent(event);
                break;
            }
            case 990054: {
                HelpForm helpForm = new HelpForm(StyleSheet.base_screenStyle);
                GeneralNavigationController.showDisplayable(helpForm);
            }
        }
    }

    public void handleComplexEvent(Event event) {
        Event[] payload = (Event[])event.getPayload();
        for (int i = 0; i < payload.length; ++i) {
            EVENT_SYSTEM.queueEvent(payload[i]);
        }
    }

    public Object getReleasePayload(Screen screen) {
        Screen previousScreen = NAVIGATION_HISTORY.peek();
        Object[] payload = null;
        if (screen instanceof BookmarksForm && previousScreen instanceof DashboardForm) {
            payload = new Object[]{GLOBAL.BOOKMARKS_CONTROLLER, BookmarksManager.getInstance()};
        }
        if (screen instanceof BibleReadChapterForm) {
            payload = new Object[]{GLOBAL.BIBLE_NAVIGATION_CONTROLLER, BibleReaderManager.getInstance()};
        }
        if (screen instanceof BiblePlansMyPlansForm || screen instanceof BiblePlansAllPlansForm && previousScreen instanceof DashboardForm) {
            payload = new Object[]{GLOBAL.READING_PLANS_CONTROLLER, ReadingPlansManager.getInstance()};
        }
        if (screen instanceof MyNotesForm && previousScreen instanceof DashboardForm) {
            payload = new Object[]{GLOBAL.NOTES_CONTROLLER, MyNotesManager.getInstance(), ReferenceNotesManager.getInstance(), ViewNoteManager.getInstance()};
        }
        if (screen instanceof LiveEventSearchForm && previousScreen instanceof DashboardForm) {
            payload = new Object[]{GLOBAL.LIVE_CONTROLLER, LiveManager.getInstance()};
        }
        return payload;
    }

    public void release() {
        this.settingsForm = null;
    }
}

