/*
 * Decompiled with CFR 0.152.
 */
package com.youversion.application.controllers.data;

import com.youversion.application.controllers.core.NavigationController;
import com.youversion.application.events.EVENT_SYSTEM;
import com.youversion.application.events.core.Event;
import com.youversion.application.events.core.EventListener;
import com.youversion.application.global.NAVIGATION_HISTORY;
import com.youversion.application.global.OPTIONS;
import com.youversion.application.internal.caching.BibleBooksSource;
import com.youversion.application.internal.caching.BibleChapterSource;
import com.youversion.application.internal.caching.BibleVersionsSource;
import com.youversion.application.internal.caching.BooksFilter;
import com.youversion.application.internal.caching.ChapterFilter;
import com.youversion.application.internal.caching.CustomRMSContentStorage;
import com.youversion.application.internal.caching.CustomRMSStorageIndex;
import com.youversion.application.internal.caching.MeasureSizeTransform;
import com.youversion.application.internal.caching.RmsStorageFilter;
import com.youversion.application.internal.caching.VersionsFilter;
import com.youversion.application.model.BibleReaderManager;
import com.youversion.application.model.BookmarksManager;
import com.youversion.application.model.reader.BookmarkChapterDescriptor;
import com.youversion.application.model.reader.ChapterDescriptor;
import com.youversion.application.views.core.Notification;
import com.youversion.internal.Chapter;
import com.youversion.objects.Book;
import com.youversion.objects.BookCollection;
import com.youversion.objects.Bookmark;
import com.youversion.objects.BookmarkCollection;
import com.youversion.objects.BookmarkLabelCollection;
import com.youversion.objects.Reference;
import com.youversion.objects.ReferenceCollection;
import com.youversion.objects.Version;
import com.youversion.objects.VersionCollection;
import com.youversion.utils.BookmarksUtil;
import de.enough.polish.content.ContentDescriptor;
import de.enough.polish.content.ContentException;
import de.enough.polish.content.ContentLoader;
import de.enough.polish.content.storage.StorageIndex;
import de.enough.polish.ui.Screen;
import de.enough.polish.util.Debug;
import de.enough.polish.util.Locale;
import javax.microedition.rms.RecordStore;

public class CacheController
extends NavigationController
implements EventListener {
    public static final String KEY_PAYLOAD = "payload";
    ContentLoader content;
    BibleChapterSource chapterSource;
    BibleVersionsSource versionsSource;
    BibleBooksSource booksSource;
    CustomRMSContentStorage rmsStorage;
    MeasureSizeTransform measureSizeTransform = new MeasureSizeTransform();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheController() {
        long maximumCacheSize = (int)Runtime.getRuntime().totalMemory() / 4;
        long maxRmsSize = 0L;
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore("test", true);
            long totalRmsSize = rs.getSize() + rs.getSizeAvailable();
            maxRmsSize = (long)((double)(totalRmsSize * 1024L) * 0.75);
        }
        catch (Exception ex) {
        }
        finally {
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
                RecordStore.deleteRecordStore("test");
            }
            catch (Exception ex) {}
        }
        this.chapterSource = new BibleChapterSource("chapterSource");
        this.chapterSource.setContentFilter(new ChapterFilter());
        this.versionsSource = new BibleVersionsSource("versionsSource");
        this.versionsSource.setContentFilter(new VersionsFilter());
        this.booksSource = new BibleBooksSource("booksSource");
        this.booksSource.setContentFilter(new BooksFilter());
        this.rmsStorage = new CustomRMSContentStorage("cacheData", new CustomRMSStorageIndex(maxRmsSize));
        this.rmsStorage.setContentFilter(new RmsStorageFilter());
        this.rmsStorage.attachSource(this.booksSource);
        this.rmsStorage.attachSource(this.chapterSource);
        this.rmsStorage.attachSource(this.versionsSource);
        this.content = new ContentLoader(new StorageIndex(maximumCacheSize), this.rmsStorage);
        this.content.attachSource(this.rmsStorage);
        this.content.addContentTransform(new MeasureSizeTransform());
        EVENT_SYSTEM.registerListener(this);
    }

    public void release() {
        try {
            this.content.sweep(false);
        }
        catch (ContentException e) {
            Debug.debug("error", "com.youversion.application.controllers.data.CacheController", 125, "error sweeping content loader");
            e.printStackTrace();
        }
    }

    public void processEvent(Event event) {
        BibleReaderManager bibleReaderManager = BibleReaderManager.getInstance();
        ChapterDescriptor workChapterDescriptor = bibleReaderManager.getWorkChapterDescriptor();
        Object payload = event.getPayload();
        switch (event.getType()) {
            case 10000: {
                try {
                    ContentDescriptor descriptor = new ContentDescriptor("version://getStuff");
                    descriptor.setPriority(9999999);
                    descriptor.setTransformID("measureDataSize");
                    Object content = this.content.loadContent(descriptor);
                    if (payload instanceof BookmarkChapterDescriptor) break;
                    EVENT_SYSTEM.queueEvent(10002, 2, content);
                }
                catch (ContentException e) {
                    EVENT_SYSTEM.queueEvent(0, e);
                }
                break;
            }
            case 10001: {
                try {
                    ContentDescriptor descriptor = new ContentDescriptor("version://getStuff");
                    descriptor.setPriority(9999999);
                    descriptor.setTransformID("measureDataSize");
                    Object content = this.content.loadContent(descriptor);
                    VersionCollection versionCollection = (VersionCollection)content;
                    workChapterDescriptor.setVersionCollection(versionCollection);
                    if (payload instanceof BookmarkChapterDescriptor) break;
                    EVENT_SYSTEM.queueEvent(10002, 2, content);
                }
                catch (ContentException e) {
                    EVENT_SYSTEM.queueEvent(0, e);
                }
                break;
            }
            case 10003: {
                Version version;
                if (payload instanceof BookmarkChapterDescriptor) {
                    BookmarkChapterDescriptor bookmarkChapterDescriptor = (BookmarkChapterDescriptor)payload;
                    version = bookmarkChapterDescriptor.getVersion();
                } else if (payload instanceof Version) {
                    version = (Version)payload;
                } else {
                    throw new IllegalArgumentException("wrong payload type for EVENTS.REQUEST_BIBLE_BOOKS");
                }
                String booksRequestUrl = "books://" + version.getAbbreviation();
                try {
                    ContentDescriptor booksRequestDescriptor = new ContentDescriptor(booksRequestUrl);
                    booksRequestDescriptor.setAttribute(KEY_PAYLOAD, version);
                    booksRequestDescriptor.setTransformID("measureDataSize");
                    Object bookRequestResult = this.content.loadContent(booksRequestDescriptor);
                    BookCollection bookCollection = (BookCollection)bookRequestResult;
                    workChapterDescriptor.setBookCollection(bookCollection);
                    if (payload instanceof BookmarkChapterDescriptor) break;
                    EVENT_SYSTEM.queueEvent(10004, 2);
                }
                catch (ContentException e) {
                    e.printStackTrace();
                    EVENT_SYSTEM.queueEvent(0, e);
                }
                break;
            }
            case 10005: {
                Book chapterBook;
                Version chapterVersion;
                Integer chapterNumber = new Integer(-1);
                Integer chapterVerseNumber = new Integer(-1);
                if (payload instanceof BookmarkChapterDescriptor) {
                    BookmarkChapterDescriptor bookmarkChapterDescriptor = (BookmarkChapterDescriptor)payload;
                    chapterVersion = bookmarkChapterDescriptor.getVersion();
                    chapterBook = bookmarkChapterDescriptor.getBook();
                    chapterNumber = bookmarkChapterDescriptor.getChapterNumber();
                    chapterVerseNumber = bookmarkChapterDescriptor.getVerseNumber();
                } else if (payload instanceof Object[]) {
                    Object[] params = (Object[])payload;
                    chapterNumber = (Integer)params[0];
                    chapterBook = (Book)params[1];
                    chapterVersion = (Version)params[2];
                } else {
                    throw new IllegalArgumentException("wrong payload type for EVENTS.REQUEST_BIBLE_BOOK_CHAPTER");
                }
                try {
                    String url = "chapter://" + chapterVersion.getAbbreviation() + "." + chapterBook.getAbbreviation() + "." + chapterNumber.toString();
                    ContentDescriptor descriptor = new ContentDescriptor(url);
                    descriptor.setTransformID("measureDataSize");
                    descriptor.setAttribute(KEY_PAYLOAD, event.getPayload());
                    Object content = this.content.loadContent(descriptor);
                    Chapter chapter = (Chapter)content;
                    workChapterDescriptor.setVersion(chapterVersion);
                    workChapterDescriptor.setBook(chapterBook);
                    workChapterDescriptor.setChapter(chapter);
                    workChapterDescriptor.setChapterNumber(chapterNumber);
                    workChapterDescriptor.setVerseNumber(chapterVerseNumber);
                    workChapterDescriptor.finish();
                    Reference reference = new Reference(chapterBook.getAbbreviation(), chapterNumber, chapterBook.getHuman());
                    Bookmark bookmark = new Bookmark(chapterVersion.getAbbreviation(), reference);
                    OPTIONS.setOption(3, bookmark);
                    EVENT_SYSTEM.queueEvent(100006, 2);
                }
                catch (ContentException e) {
                    e.printStackTrace();
                    EVENT_SYSTEM.queueEvent(0, e);
                }
                break;
            }
            case 100008: {
                if (OPTIONS.isLoggedIn()) {
                    EVENT_SYSTEM.queueEvent(200009, 2, event.getPayload());
                    break;
                }
                BookmarkCollection bookmarkCollection = (BookmarkCollection)OPTIONS.getOption(6);
                if (BookmarksManager.getInstance().getCurrentLabelFilter() != null) {
                    bookmarkCollection = BookmarksUtil.filterByLabel(bookmarkCollection, BookmarksManager.getInstance().getCurrentLabelFilter());
                }
                BookmarksManager.getInstance().setPage(new Integer(1));
                BookmarksManager.getInstance().setBookmarkCollection(bookmarkCollection);
                EVENT_SYSTEM.queueEvent(100009, 2, new Object[]{new Integer(1), bookmarkCollection});
                break;
            }
            case 200010: {
                Integer page = (Integer)((Object[])payload)[0];
                BookmarkCollection bookmarkCollection = (BookmarkCollection)((Object[])payload)[1];
                BookmarksManager.getInstance().setPage(page);
                BookmarksManager.getInstance().setBookmarkCollection(bookmarkCollection);
                EVENT_SYSTEM.queueEvent(100009, 2, event.getPayload());
                break;
            }
            case 200001: {
                EVENT_SYSTEM.queueEvent(100002, 2, event.getPayload());
                break;
            }
            case 20002: {
                EVENT_SYSTEM.queueEvent(10002, 2, event.getPayload());
                break;
            }
            case 20004: {
                EVENT_SYSTEM.queueEvent(10004, 2, event.getPayload());
                break;
            }
            case 200006: {
                EVENT_SYSTEM.queueEvent(100006, 2, event.getPayload());
                break;
            }
            case 880001: {
                Object[] storePayload = (Object[])event.getPayload();
                ContentDescriptor storeDesc = new ContentDescriptor((String)storePayload[0]);
                storeDesc.setPriority(9999999);
                this.rmsStorage.forceStore(storeDesc, storePayload[1]);
                break;
            }
            case 880002: {
                String requestObjectID = (String)event.getPayload();
                ContentDescriptor requestContentDescriptor = new ContentDescriptor(requestObjectID);
                Object requestObjectResult = null;
                try {
                    requestObjectResult = this.rmsStorage.loadContent(requestContentDescriptor);
                }
                catch (ContentException e) {
                    // empty catch block
                }
                EVENT_SYSTEM.queueEvent(880003, new Object[]{requestObjectID, requestObjectResult});
                break;
            }
            case 100010: {
                BookmarkChapterDescriptor bookmarkChapterDescriptor = (BookmarkChapterDescriptor)event.getPayload();
                EVENT_SYSTEM.queueEvent(10001, 2, bookmarkChapterDescriptor);
                EVENT_SYSTEM.queueEvent(10003, 2, bookmarkChapterDescriptor);
                EVENT_SYSTEM.queueEvent(10005, 2, bookmarkChapterDescriptor);
                break;
            }
            case 1: {
                this.content.shutdown();
                break;
            }
            case 100012: {
                this.handleAddToBookmarks(event);
                break;
            }
            case 100011: {
                this.handleDeleteBookmark(event);
                break;
            }
            case 880004: {
                this.handleSweepStorage();
                break;
            }
            case 100014: {
                this.handleAddToDoNotShowList(event);
                break;
            }
            case 100015: {
                this.handleRequestBookmarkLabels(event);
                break;
            }
            case 200052: {
                this.handleBeReceivedBookmarksLabels(event);
            }
        }
    }

    public void handleBeReceivedBookmarksLabels(Event event) {
        Object payload = event.getPayload();
        Integer page = (Integer)((Object[])payload)[0];
        BookmarkLabelCollection bookmarkLabelCollection = (BookmarkLabelCollection)((Object[])payload)[1];
        BookmarksManager.getInstance().setBookmarksLabelsPage(page);
        BookmarksManager.getInstance().setBookmarkLabelCollection(bookmarkLabelCollection);
        EVENT_SYSTEM.queueEvent(100016, 2, event.getPayload());
    }

    public void handleRequestBookmarkLabels(Event event) {
        if (OPTIONS.isLoggedIn()) {
            EVENT_SYSTEM.queueEvent(200051, 2, event.getPayload());
        } else {
            BookmarkLabelCollection result = new BookmarkLabelCollection();
            BookmarkCollection offlineBookmarks = (BookmarkCollection)OPTIONS.getOption(6);
            result = BookmarksUtil.getLabelsForCollection(offlineBookmarks);
            BookmarksManager.getInstance().setBookmarksLabelsPage(new Integer(1));
            BookmarksManager.getInstance().setBookmarkLabelCollection(result);
            EVENT_SYSTEM.queueEvent(100016, 2, new Object[]{new Integer(1), result});
        }
    }

    public void handleAddToDoNotShowList(Event event) {
        String ID = (String)event.getPayload();
        OPTIONS.setDoNotShowAgainStatus(ID, true);
    }

    public void handleSweepStorage() {
        try {
            this.content.sweep(true);
            this.rmsStorage.sweep(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleDeleteBookmark(Event event) {
        if (OPTIONS.isLoggedIn()) {
            EVENT_SYSTEM.queueEvent(200011, 2, event.getPayload());
        } else {
            BookmarkCollection bookmarks = (BookmarkCollection)OPTIONS.getOption(6);
            Bookmark bookmark = (Bookmark)event.getPayload();
            long bookmarkID = bookmark.getId();
            for (int i = 0; i < bookmarks.size(); ++i) {
                Bookmark temp = (Bookmark)bookmarks.elementAt(i);
                if (temp.getId() != bookmarkID) continue;
                bookmarks.removeElementAt(i);
                break;
            }
            OPTIONS.setOption(6, bookmarks);
            Notification.show(Locale.get(15), NAVIGATION_HISTORY.peek());
        }
    }

    public void handleAddToBookmarks(Event event) {
        if (OPTIONS.isLoggedIn()) {
            EVENT_SYSTEM.queueEvent(200012, 2, event.getPayload());
        } else {
            BookmarkCollection bookmarks = (BookmarkCollection)OPTIONS.getOption(6);
            if (event.getPayload() instanceof Bookmark) {
                Bookmark bookmark = (Bookmark)event.getPayload();
                if (bookmark.getHuman() == null) {
                    bookmark.setHuman(bookmark.getReferences().toHumanString());
                }
                if (bookmark.getId() <= 0L) {
                    bookmark.setId(OPTIONS.getNextUniqueID());
                    bookmarks.addElement(bookmark);
                } else {
                    for (int i = 0; i < bookmarks.size(); ++i) {
                        Bookmark temp = (Bookmark)bookmarks.elementAt(i);
                        if (temp.getId() != bookmark.getId()) continue;
                        bookmarks.setElementAt(bookmark, i);
                        break;
                    }
                }
            } else {
                ReferenceCollection createBookmarksReferenceCollection = new ReferenceCollection();
                Object[] createBookmarksPayload = (Object[])event.getPayload();
                String createBookmarksVersion = (String)createBookmarksPayload[0];
                Reference[] createBookmarksReferences = (Reference[])createBookmarksPayload[1];
                for (int i = 0; i < createBookmarksReferences.length; ++i) {
                    Reference ref = createBookmarksReferences[i];
                    Bookmark bookmark = new Bookmark(createBookmarksVersion, ref);
                    bookmark.setId(OPTIONS.getNextUniqueID());
                    bookmarks.addElement(bookmark);
                }
            }
            OPTIONS.setOption(6, bookmarks);
        }
    }

    public static void showDisplayable(Screen disp) {
        NAVIGATION_HISTORY.push(disp);
    }
}

