/*
 * Decompiled with CFR 0.152.
 */
package com.youversion;

import com.youversion.ApiBase;
import com.youversion.ApiConnection;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.NotificationCollection;
import java.util.Hashtable;
import org.json.me.JSONObject;

public class NotificationsApi
extends ApiBase {
    public static final String TYPE_GLOBAL = "global";
    public static final String TYPE_IOS = "ios";
    public static final String TYPE_BLACKBERRY = "blackberry";
    public static final String TYPE_ANDROID = "android";
    public static final String TYPE_J2ME = "j2me";
    public static final String TYPE_WEBOS = "webos";

    public static NotificationCollection items(ApiConnection conn, final String type, final String model, final Integer appVersion) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (type != null) {
                    this.put("type", type);
                }
                if (model != null) {
                    this.put("model", model);
                }
                if (appVersion != null) {
                    this.put("app_version", appVersion);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/notifications/items.json";
        url = url + NotificationsApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (code == 404) {
                return ApiBase.getApiFactory().newNotificationCollection();
            }
            if (NotificationsApi.isSuccess(code)) {
                return NotificationCollection.unloadJSON(parsed.getJSONObject("data"));
            }
            innerEx = NotificationsApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable e) {
            innerEx = new YouVersionApiException(e);
        }
        throw innerEx;
    }
}

