/*
 * Decompiled with CFR 0.152.
 */
package com.youversion;

import com.youversion.ApiBase;
import com.youversion.ApiConnection;
import com.youversion.exceptions.YouVersionApiException;
import com.youversion.objects.Bookmark;
import com.youversion.objects.BookmarkCollection;
import com.youversion.objects.BookmarkLabelCollection;
import com.youversion.objects.Reference;
import com.youversion.util.StringHelper;
import java.util.Hashtable;
import java.util.Vector;
import org.json.me.JSONArray;
import org.json.me.JSONObject;

public class BookmarksApi
extends ApiBase {
    public static BookmarkCollection items(ApiConnection conn, final Integer userId, final String label, final int page) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = -4124111474411834372L;
            {
                if (userId != null) {
                    this.put("user_id", userId.toString());
                }
                if (label != null) {
                    this.put("label", label);
                }
                this.put("page", String.valueOf(page));
            }
        };
        String url = ApiBase.URL_BASE + "/bookmarks/items.json" + BookmarksApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (BookmarksApi.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data");
                return BookmarkCollection.unloadJSON(data);
            }
            if (code == 404) {
                return ApiBase.getApiFactory().newBookmarkCollection();
            }
            innerEx = BookmarksApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static BookmarkCollection create(ApiConnection conn, String username, String password, BookmarkCollection bookmarks) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        String url = ApiBase.URL_BASE + "/bookmarks/create.json";
        try {
            StringBuffer data = new StringBuffer();
            for (int i = 0; i < bookmarks.size(); ++i) {
                Bookmark b = (Bookmark)bookmarks.elementAt(i);
                if (i > 0) {
                    data.append("&");
                }
                data.append("data[]=");
                data.append(StringHelper.urlEncode("reference=" + b.getOsis()));
                data.append(StringHelper.urlEncode("&version=" + b.getVersion()));
                if (b.getTitle() != null) {
                    data.append(StringHelper.urlEncode("&title=" + b.getTitle()));
                }
                if (b.getLabels() != null) {
                    data.append(StringHelper.urlEncode("&labels=" + b.getLabels()));
                }
                if (b.getHighlightColor() == null) continue;
                data.append(StringHelper.urlEncode("&highlight_color=" + b.getHighlightColor()));
            }
            String dataStr = data.toString();
            ApiBase.getDebugHelper().logDebug(dataStr);
            ApiConnection.ApiResponse response = conn.makePostRequest(url, dataStr.getBytes("UTF-8"), username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            JSONArray json = parsed.getJSONArray("data");
            BookmarkCollection collection = ApiBase.getApiFactory().newBookmarkCollection();
            if (json == null) {
                return collection;
            }
            for (int i = 0; i < json.length(); ++i) {
                JSONObject item = json.getJSONObject(i);
                collection.addElement(Bookmark.unloadJSON(item.getJSONObject("data")));
            }
            return collection;
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static Bookmark create(ApiConnection conn, String username, String password, Reference reference, String version, String title, String labels, String highlightColor) throws YouVersionApiException {
        return BookmarksApi.create(conn, username, password, reference.getOsis(), version, title, labels, highlightColor);
    }

    public static Bookmark create(ApiConnection conn, String username, String password, final String reference, final String version, final String title, final String labels, final String highlightColor) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (reference != null) {
                    this.put("reference", reference);
                }
                if (version != null) {
                    this.put("version", version);
                }
                if (title != null) {
                    this.put("title", title);
                }
                if (labels != null) {
                    this.put("labels", labels);
                }
                if (highlightColor != null) {
                    this.put("highlight_color", highlightColor);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/bookmarks/create.json";
        try {
            byte[] data = BookmarksApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            JSONObject json = parsed.getJSONObject("data");
            return Bookmark.unloadJSON(json);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static Bookmark create(ApiConnection conn, String username, String password, Bookmark bookmark) throws YouVersionApiException {
        return BookmarksApi.create(conn, username, password, bookmark.getOsis(), bookmark.getVersion(), bookmark.getTitle(), bookmark.getLabels(), bookmark.getHighlightColor());
    }

    public static boolean delete(ApiConnection conn, String username, String password, Long id) throws YouVersionApiException {
        return BookmarksApi.delete(conn, username, password, id.toString());
    }

    public static boolean delete(ApiConnection conn, String username, String password, Vector ids) throws YouVersionApiException {
        return BookmarksApi.delete(conn, username, password, BookmarksApi.makePlusSeparatedString(ids));
    }

    public static boolean delete(ApiConnection conn, String username, String password, final String ids) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                if (ids != null) {
                    this.put("ids", ids);
                }
            }
        };
        String url = ApiBase.URL_BASE + "/bookmarks/delete.json";
        try {
            byte[] data = BookmarksApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            return BookmarksApi.isSuccess(code);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static Bookmark update(ApiConnection conn, String username, String password, final Bookmark bookmark) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 1L;
            {
                this.put("id", new Long(bookmark.getId()));
                this.put("title", bookmark.getTitle() == null ? "" : bookmark.getTitle());
                this.put("labels", bookmark.getLabels() == null ? "" : bookmark.getLabels());
                this.put("highlight_color", bookmark.getHighlightColor() == null ? "" : bookmark.getHighlightColor());
            }
        };
        String url = ApiBase.URL_BASE + "/bookmarks/update.json";
        try {
            byte[] data = BookmarksApi.buildQueryString(map).substring(1).getBytes("UTF-8");
            ApiConnection.ApiResponse response = conn.makePostRequest(url, data, username, password);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (BookmarksApi.isSuccess(code)) {
                JSONObject item = parsed.getJSONObject("data");
                return Bookmark.unloadJSON(item);
            }
            innerEx = BookmarksApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }

    public static BookmarkLabelCollection labels(ApiConnection conn, final Integer userId, final int page) throws YouVersionApiException {
        YouVersionApiException innerEx = null;
        Hashtable map = new Hashtable(){
            private static final long serialVersionUID = 0L;
            {
                if (userId != null) {
                    this.put("user_id", userId.toString());
                }
                this.put("page", String.valueOf(page));
            }
        };
        String url = ApiBase.URL_BASE + "/bookmarks/labels.json" + BookmarksApi.buildQueryString(map);
        try {
            ApiConnection.ApiResponse response = conn.makeGetRequest(url);
            response.assertSuccess();
            JSONObject parsed = new JSONObject(response.toString()).getJSONObject("response");
            int code = parsed.getInt("code");
            if (BookmarksApi.isSuccess(code)) {
                JSONObject data = parsed.getJSONObject("data");
                return BookmarkLabelCollection.fromJson(data);
            }
            if (code == 404) {
                return ApiBase.getApiFactory().newBookmarkLabelCollection();
            }
            innerEx = BookmarksApi.buildReadException(parsed);
        }
        catch (YouVersionApiException e) {
            innerEx = e;
        }
        catch (Throwable t) {
            innerEx = new YouVersionApiException(t);
        }
        throw innerEx;
    }
}

