/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.xml;

import de.enough.polish.util.Debug;
import de.enough.polish.xml.XmlDomNode;
import de.enough.polish.xml.XmlPullParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class XmlDomParser {
    public static XmlDomNode parseTree(String document) {
        try {
            return XmlDomParser.parseTree(document, null);
        }
        catch (UnsupportedEncodingException e) {
            Debug.debug("error", "de.enough.polish.xml.XmlDomParser", 86, (Object)"Unable to parse stream in default encoding: ", e);
            throw new RuntimeException(e.toString());
        }
    }

    public static XmlDomNode parseTree(String document, String encoding) throws UnsupportedEncodingException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(document.getBytes());
        return XmlDomParser.parseTree(byteArrayInputStream, null);
    }

    public static XmlDomNode parseTree(InputStream in) {
        try {
            return XmlDomParser.parseTree(in, null);
        }
        catch (UnsupportedEncodingException e) {
            Debug.debug("error", "de.enough.polish.xml.XmlDomParser", 123, (Object)"Unable to parse stream in default encoding: ", e);
            throw new RuntimeException(e.toString());
        }
    }

    public static XmlDomNode parseTree(InputStream in, String encoding) throws UnsupportedEncodingException {
        InputStreamReader inputStreamReader = encoding != null ? new InputStreamReader(in, encoding) : new InputStreamReader(in);
        return XmlDomParser.parseTree(inputStreamReader);
    }

    public static XmlDomNode parseTree(Reader reader) {
        XmlDomNode root;
        XmlPullParser parser;
        try {
            parser = new XmlPullParser(reader);
        }
        catch (IOException exception) {
            throw new RuntimeException("Could not create xml parser." + exception);
        }
        XmlDomNode currentNode = root = new XmlDomNode(null, null, -1);
        try {
            while (parser.next() != 1) {
                String newName = parser.getName();
                int newType = parser.getType();
                if (newType == 2) {
                    XmlDomNode newNode;
                    Hashtable<String, String> attributes = null;
                    int attributeCount = parser.getAttributeCount();
                    if (attributeCount > 0) {
                        attributes = new Hashtable<String, String>();
                        for (int i = 0; i < attributeCount; ++i) {
                            attributes.put(parser.getAttributeName(i), parser.getAttributeValue(i));
                        }
                    }
                    currentNode = newNode = new XmlDomNode(currentNode, newName, attributes, newType);
                    continue;
                }
                if (newType == 3) {
                    currentNode = currentNode.getParent();
                    continue;
                }
                if (newType != 4) continue;
                String text = parser.getText();
                currentNode.setText(text);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("parse error:" + exception);
        }
        if (root.getChildCount() == 1) {
            return root.getChild(0);
        }
        return root;
    }
}

