/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.video.control;

import de.enough.polish.ui.AnimationThread;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.video.VideoCallback;
import de.enough.polish.video.VideoContainer;
import de.enough.polish.video.VideoSource;
import de.enough.polish.video.util.VideoUtil;
import javax.microedition.lcdui.Graphics;

public class SeekControlItem
extends Gauge
implements VideoCallback {
    StringItem display;
    VideoContainer video;
    boolean seek = false;
    long current;
    long total;
    int currentSeconds;
    int totalSecond;

    public SeekControlItem(VideoContainer item) {
        this(item, null);
    }

    public SeekControlItem(VideoContainer item, Style style) {
        super(null, true, 100, 0, style);
        this.video = item;
        this.video.addCallback(this);
        this.display = new StringItem(null, "0:00/0:00");
        this.display.setParent(this);
    }

    public void onVideoReady() {
        this.current = 0L;
        this.currentSeconds = 0;
        this.total = this.video.getLength();
        this.totalSecond = VideoUtil.getSeconds(this.total);
        this.setValue(this.currentSeconds);
        this.setMaxValue(this.totalSecond);
    }

    public void onVideoPartReady(VideoSource source) {
    }

    public void onVideoError(Exception e) {
    }

    public void onVideoPause() {
    }

    public void onVideoPlay() {
    }

    public void onVideoStop() {
        this.setValue(0);
    }

    public void onVideoClose() {
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        boolean handled = super.handleKeyPressed(keyCode, gameAction);
        if (this.video.getState() >= 1) {
            if (gameAction == 2 || gameAction == 5) {
                long current = this.getValue() * 1000000;
                long length = this.getMaxValue() * 1000000;
                this.setDisplay(current, length);
                this.seek = true;
                return true;
            }
            if (this.seek && gameAction == 8 && keyCode != 53) {
                int value = this.getValue();
                long time = value * 1000000;
                this.video.seek(time);
                this.seek = false;
                return true;
            }
        }
        return handled;
    }

    public boolean animate() {
        boolean animated = super.animate();
        if (this.video.isFullscreen()) {
            return animated;
        }
        if (!this.seek && this.video.getState() >= 1) {
            this.current = this.video.getTime();
            int seconds = VideoUtil.getSeconds(this.current);
            if (this.currentSeconds != seconds) {
                this.currentSeconds = seconds;
                this.setDisplay(this.current, this.total);
                this.setValue(this.currentSeconds);
                return true;
            }
        }
        return animated;
    }

    void setDisplay(long current, long length) {
        String currentStr = VideoUtil.getTime(current);
        String lengthStr = VideoUtil.getTime(length);
        this.display.setText(currentStr + "/" + lengthStr);
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int displayHeight = this.display.getItemHeight(this.contentWidth, this.contentWidth, this.availableHeight);
        this.display.paint(x, y - displayHeight, leftBorder, rightBorder, g);
        super.paintContent(x, y, leftBorder, rightBorder, g);
    }

    protected void showNotify() {
        super.showNotify();
        AnimationThread.addAnimationItem(this);
    }

    protected void hideNotify() {
        super.hideNotify();
        AnimationThread.removeAnimationItem(this);
    }

    public void onSnapshot(byte[] data, String encoding) {
    }
}

