/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.video;

import de.enough.polish.io.Externalizable;
import de.enough.polish.io.Serializer;
import de.enough.polish.util.Debug;
import de.enough.polish.video.CaptureSource;
import de.enough.polish.video.VideoCallback;
import de.enough.polish.video.VideoContainer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.FramePositioningControl;
import javax.microedition.media.control.VideoControl;
import javax.microedition.media.control.VolumeControl;

public class VideoSource
implements Externalizable {
    public static CaptureSource CAPTURE;
    String id;
    String file;
    transient InputStream stream;
    transient Connection connection;
    String mime;
    transient VideoCallback callback;
    transient Player player;
    transient VideoControl videoControl;
    transient FramePositioningControl framePositioningControl;
    transient VolumeControl volumeControl;
    transient VideoContainer parent;

    private VideoSource(String id, String mime) {
        this.id = id;
        this.mime = mime;
    }

    public VideoSource(String id, String file, String mime) {
        this(id, mime);
        this.file = file;
    }

    public VideoSource(String id, InputStream stream, String mime) {
        this(id, mime);
        this.stream = stream;
    }

    public VideoSource(String id, InputStream stream, Connection connection, String mime) {
        this(id, mime);
        this.stream = stream;
        this.connection = connection;
    }

    protected void setParent(VideoContainer parent) {
        this.parent = parent;
    }

    protected void open() throws Exception {
        try {
            if (this.file != null && !this.file.startsWith("rtsp://") && this != CAPTURE) {
                FileConnection fileConnection = (FileConnection)Connector.open(this.file, 3);
                this.connection = fileConnection;
                this.stream = fileConnection.openInputStream();
            }
            if (this.getStream() != null) {
                this.player = Manager.createPlayer(this.getStream(), this.getMime());
            } else if (this.getFile() != null) {
                this.player = Manager.createPlayer(this.getFile());
            }
            this.player.realize();
            this.player.prefetch();
            this.videoControl = (VideoControl)this.player.getControl("VideoControl");
            this.volumeControl = (VolumeControl)this.player.getControl("VolumeControl");
            this.framePositioningControl = (FramePositioningControl)this.player.getControl("FramePositioningControl");
        }
        catch (Exception e) {
            this.parent.onVideoError(e);
        }
    }

    protected void close() {
        try {
            if (this.player != null) {
                this.player.deallocate();
                this.player.close();
                this.player = null;
            }
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (IOException e) {
            this.callback.onVideoError(e);
            Debug.debug("error", "de.enough.polish.video.VideoSource", 226, (Object)"Unable to close connection", e);
        }
    }

    protected String getId() {
        return this.id;
    }

    protected String getFile() {
        return this.file;
    }

    protected InputStream getStream() {
        return this.stream;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected String getMime() {
        return this.mime;
    }

    public Player getPlayer() {
        return this.player;
    }

    protected VideoControl getVideoControl() {
        return this.videoControl;
    }

    protected FramePositioningControl getFramePositioningControl() {
        return this.framePositioningControl;
    }

    protected VolumeControl getVolumeControl() {
        return this.volumeControl;
    }

    static {
        try {
            CAPTURE = new CaptureSource();
        }
        catch (MediaException e) {
            CAPTURE = null;
            Debug.debug("error", "de.enough.polish.video.VideoSource", 38, "capture is not supported");
        }
    }

    public VideoSource() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.file = (String)Serializer.deserialize(dataInputStream);
        this.id = (String)Serializer.deserialize(dataInputStream);
        this.mime = (String)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Serializer.serialize(this.file, dataOutputStream);
        Serializer.serialize(this.id, dataOutputStream);
        Serializer.serialize(this.mime, dataOutputStream);
    }
}

