/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.video;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Form;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import de.enough.polish.video.CaptureSource;
import de.enough.polish.video.VideoCallback;
import de.enough.polish.video.VideoMultipart;
import de.enough.polish.video.VideoSource;
import de.enough.polish.video.util.VideoUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;
import javax.microedition.media.control.VolumeControl;

public class VideoContainer
extends Container
implements Runnable,
PlayerListener,
VideoCallback {
    public static final int STATE_CLOSED = -1;
    public static final int STATE_NOT_PREPARED = 0;
    public static final int STATE_READY = 1;
    public static final int STATE_PLAYING = 2;
    public static final int STATE_PAUSED = 3;
    public static final int STATE_STOPPED = 4;
    static final String tag = "video";
    VideoSource source;
    VideoSource sourceToClear;
    VideoMultipart multipart;
    VideoMultipart multipartToClear;
    ArrayList callbacks;
    boolean repeat;
    boolean landscape;
    boolean fullscreen;
    private boolean restoreFullscreenInPlay;
    boolean mute;
    int volume = 100;
    Ratio ratio;
    int state;
    int videoX;
    int videoY;
    int videoWidth;
    int videoHeight;
    long videoLength;
    Fullscreen fullScreen;
    Displayable fullScreenParent;
    Thread currentThread;
    boolean resume;
    private final boolean adjustSizeAutomatically;
    private int gameActionEnterFullscreen;
    private boolean startPlayAfterPrepare;
    boolean changingViewMode;
    private Exception lastException;

    public VideoContainer() {
        this(false, null);
    }

    public VideoContainer(Style style) {
        this(false, style);
    }

    public VideoContainer(boolean adjustSizeAutomatically) {
        this(adjustSizeAutomatically, null);
    }

    public VideoContainer(boolean adjustSizeAutomatically, Style style) {
        super(true, style);
        this.adjustSizeAutomatically = adjustSizeAutomatically;
        this.callbacks = new ArrayList();
        this.setState(0);
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
    }

    public void setScreen(Screen screen) {
        this.screen = screen;
    }

    public synchronized void setSource(VideoSource source) {
        this.setState(0);
        this.sourceToClear = this.source;
        this.source = source;
        this.source.setParent(this);
    }

    public VideoSource getSource() {
        return this.source;
    }

    public void setMultipart(VideoMultipart multipart) {
        this.setState(0);
        this.multipartToClear = this.multipart;
        this.multipart = multipart;
        if (this.multipart.hasNext()) {
            this.source = multipart.next();
        }
    }

    void close(VideoSource videoSource) {
        if (videoSource != null) {
            if (this.getState() == 2) {
                try {
                    videoSource.getVideoControl().setVisible(false);
                    videoSource.getPlayer().stop();
                }
                catch (MediaException e) {
                    this.onVideoError(e);
                }
            }
            this.onVideoClose();
            videoSource.close();
        }
    }

    public void close() {
        this.close(this.source);
        this.setState(-1);
    }

    public void addCallback(VideoCallback callback) {
        this.callbacks.add(callback);
    }

    public void removeCallback(VideoCallback callback) {
        this.callbacks.remove(callback);
    }

    public void setEnterFullscreenGameAction(int gameAction) {
        this.gameActionEnterFullscreen = gameAction;
    }

    private VideoCallback callback(int index) {
        return (VideoCallback)this.callbacks.get(index);
    }

    protected void initSource(VideoSource src) throws Exception {
        src.open();
    }

    protected void initDisplay(VideoSource src) throws Exception {
        this.videoX = this.getAbsoluteX() + this.getContentX();
        this.videoY = this.getAbsoluteY() + this.getContentY();
        this.videoHeight = this.getContentHeight();
        this.videoWidth = this.getContentWidth();
        VideoControl videoControl = src.getVideoControl();
        if (videoControl == null) {
            throw new IllegalStateException("no videocontrol");
        }
        videoControl.initDisplayMode(1, Display.getInstance());
        if (!this.fullscreen && !this.restoreFullscreenInPlay) {
            this.setDisplay(videoControl, this.videoX, this.videoY, this.videoWidth, this.videoHeight, this.ratio);
        } else {
            if (this.restoreFullscreenInPlay) {
                this.restoreFullscreenInPlay = false;
                this.fullscreen = true;
            }
            this.setDisplay(this.source.getVideoControl(), 0, 0, Display.getScreenWidth(), Display.getScreenHeight(), this.ratio);
        }
        videoControl.setVisible(true);
    }

    protected void setDisplay(VideoControl control, int x, int y, int width, int height, Ratio ratio) throws Exception {
        control.setVisible(false);
        if (this.isLandscape()) {
            int orginalX = x;
            x = Display.getScreenHeight() - (y + height);
            y = orginalX;
            int orginalWidth = width;
            width = height;
            height = orginalWidth;
        }
        control.setDisplayLocation(x, y);
        control.setDisplaySize(width, height);
        control.setVisible(true);
    }

    protected void initVolume(VideoSource source) throws Exception {
        this.setVolume(this.volume);
        VolumeControl volumeControl = this.source.getVolumeControl();
        if (volumeControl != null) {
            if (this.mute) {
                volumeControl.setLevel(0);
            } else {
                volumeControl.setLevel(this.volume);
            }
        }
    }

    public void prepare() {
        if (this.getState() == 0) {
            this.currentThread = new Thread(this);
            this.currentThread.start();
        }
    }

    public void play() {
        if (this.getState() < 1) {
            this.startPlayAfterPrepare = true;
            this.prepare();
        } else {
            try {
                this.getScreen().addPermanentNativeItem(this);
                this.source.getVideoControl().setVisible(true);
                this.source.getPlayer().start();
                this.setState(2);
            }
            catch (Exception e) {
                this.onVideoError(e);
            }
            this.onVideoPlay();
        }
    }

    public void pause() {
        if (this.getState() == 2) {
            try {
                this.source.getVideoControl().setVisible(false);
                this.source.getPlayer().stop();
                this.setState(3);
            }
            catch (MediaException e) {
                this.onVideoError(e);
            }
            this.onVideoPause();
        }
    }

    public void stop() {
        if (this.fullscreen) {
            this.fullscreen = false;
            this.restoreFullscreenInPlay = true;
        }
        if (this.getState() == 2) {
            try {
                this.source.getVideoControl().setVisible(false);
            }
            catch (Exception e) {
                this.onVideoError(e);
            }
            try {
                this.source.getPlayer().stop();
                this.seek(0L);
                this.setState(4);
                this.onVideoStop();
            }
            catch (Exception e) {
                this.onVideoError(e);
            }
        }
    }

    public void seek(long position) {
        new Seek(this.source, position).start();
    }

    public long getTime() {
        return this.source.getPlayer().getMediaTime();
    }

    public long getLength() {
        return this.source.getPlayer().getDuration();
    }

    public void setVolume(int volume) {
        if (volume < 0 || volume > 100) {
            this.onVideoError(new IllegalArgumentException("volume must be in percent"));
        }
        try {
            VolumeControl volumeControl;
            this.volume = volume;
            if (!this.isMute() && (volumeControl = this.source.getVolumeControl()) != null) {
                volumeControl.setLevel(volume);
            }
        }
        catch (Exception e) {
            this.onVideoError(e);
        }
    }

    public int getVolume() {
        return this.volume;
    }

    public boolean animate() {
        return false;
    }

    public void paint(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (this.getState() == 2) {
            g.setColor(0);
            g.fillRect(this.getAbsoluteX(), this.getAbsoluteY(), this.itemWidth, this.itemHeight);
        } else {
            super.paint(x, y, leftBorder, rightBorder, g);
        }
    }

    public void setFullscreen(boolean fullscreen) {
        if (this.source == null) {
            throw new IllegalStateException();
        }
        this.setFullscreen(this.source, fullscreen);
    }

    public void setFullscreen(VideoSource src, boolean fullscreen) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        VideoControl videoControl = src.getVideoControl();
        if (videoControl == null) {
            throw new IllegalStateException();
        }
        try {
            videoControl.setDisplayFullScreen(fullscreen);
            this.fullscreen = fullscreen;
            this.restoreFullscreenInPlay = false;
        }
        catch (MediaException e) {
            Debug.debug("error", "de.enough.polish.video.VideoContainer", 910, (Object)"Unable to enter fullscreen mode", e);
            this.onVideoError(e);
        }
    }

    public void setPseudoFullscreen(boolean fullscreen) {
        this.setPseudoFullscreen(this.source, fullscreen);
    }

    public void setPseudoFullscreen(VideoSource src, boolean fullscreen) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.changingViewMode = true;
            if (fullscreen) {
                this.fullscreen = fullscreen;
                if (this.fullScreen == null) {
                    this.fullScreen = new Fullscreen(this);
                }
                this.fullScreenParent = Display.getInstance().getCurrent();
                Display.getInstance().setCurrent(this.fullScreen);
                if (this.getState() >= 1) {
                    this.setDisplay(this.source.getVideoControl(), 0, 0, Display.getScreenWidth(), Display.getScreenHeight(), this.ratio);
                }
            } else {
                Display.getInstance().setCurrent(this.fullScreenParent);
                if (this.getState() >= 1) {
                    this.setDisplay(this.source.getVideoControl(), this.videoX, this.videoY, this.videoWidth, this.videoHeight, this.ratio);
                }
                this.fullscreen = fullscreen;
            }
            this.changingViewMode = false;
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.video.VideoContainer", 973, (Object)"exception : ", e.getMessage());
            this.onVideoError(e);
        }
    }

    public synchronized void run() {
        try {
            if (this.getState() == 0) {
                while (!this.isInitialized()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {}
                }
                this.close(this.sourceToClear);
                if (this.source != null) {
                    this.init(this.source);
                    this.setState(1);
                    this.onVideoReady();
                    while (this.multipart != null && this.multipart.hasNext()) {
                        VideoSource oldSource = this.source;
                        VideoSource nextSource = this.multipart.next();
                        this.init(nextSource);
                        this.wait();
                        this.source = nextSource;
                        this.play();
                        oldSource.close();
                    }
                    if (this.startPlayAfterPrepare) {
                        this.startPlayAfterPrepare = false;
                        this.play();
                    }
                } else {
                    Debug.debug("error", "de.enough.polish.video.VideoContainer", 1032, "source is not set");
                }
            }
        }
        catch (Exception e) {
            this.onVideoError(e);
        }
    }

    public synchronized void next() {
        this.notify();
    }

    private void init(VideoSource src) throws Exception {
        this.initSource(src);
        this.initDisplay(src);
        this.initVolume(src);
        src.getPlayer().addPlayerListener(this);
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        VideoControl videoControl;
        super.initContent(firstLineWidth, availWidth, availHeight);
        this.contentWidth = availWidth;
        this.contentHeight = availHeight;
        if (this.adjustSizeAutomatically && this.source != null && (videoControl = this.source.getVideoControl()) != null) {
            this.contentWidth = videoControl.getDisplayWidth();
            this.contentHeight = videoControl.getDisplayHeight();
        }
    }

    public void playerUpdate(Player player, String event, Object data) {
        if (event == null) {
            return;
        }
        if (event.equals("endOfMedia")) {
            if (this.multipart != null) {
                if (!this.multipart.hasNext()) {
                    if (this.isRepeat()) {
                        this.multipart.reset();
                        this.source = this.multipart.next();
                    } else {
                        return;
                    }
                }
                this.next();
            } else if (this.repeat) {
                try {
                    player.start();
                }
                catch (MediaException e) {
                    this.onVideoError(e);
                }
            } else {
                this.stop();
            }
        }
        if (event.equals("error")) {
            this.onVideoError(new Exception("player error"));
        }
    }

    public boolean isLandscape() {
        return this.landscape;
    }

    public void setLandscape(boolean landscape) {
        this.landscape = landscape;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public void setRatio(Ratio ratio) {
        this.ratio = ratio;
    }

    public int getState() {
        return this.state;
    }

    private synchronized void setState(int state) {
        this.state = state;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public void mute(boolean mute) {
        this.mute = mute;
        if (this.getState() >= 1) {
            if (this.mute) {
                this.source.getVolumeControl().setLevel(0);
            } else {
                this.source.getVolumeControl().setLevel(this.volume);
            }
        }
    }

    public boolean isMute() {
        return this.mute;
    }

    void showVideo() {
        if (this.resume && !this.changingViewMode) {
            this.play();
        }
    }

    void hideVideo() {
        if (!this.changingViewMode && this.getState() > -1) {
            this.resume = this.getState() == 2;
            this.pause();
        }
    }

    protected void showNotify() {
        super.showNotify();
        this.showVideo();
    }

    public byte[] capture(String encoding) {
        byte[] data = null;
        if (this.source instanceof CaptureSource) {
            if (this.getState() < 1) {
                this.play();
            }
            try {
                data = ((CaptureSource)this.source).capture(encoding);
                this.onSnapshot(data, encoding);
            }
            catch (MediaException e) {
                this.onVideoError(e);
            }
        }
        return data;
    }

    protected void hideNotify() {
        super.hideNotify();
        this.hideVideo();
    }

    public void onSnapshot(byte[] data, String encoding) {
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callback(i).onSnapshot(data, encoding);
        }
    }

    public void onVideoClose() {
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callback(i).onVideoClose();
        }
    }

    public void onVideoError(Exception e) {
        Debug.debug("error", "de.enough.polish.video.VideoContainer", 1287, (Object)"onVideoError: error=", e);
        this.lastException = e;
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callback(i).onVideoError(e);
        }
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void onVideoPause() {
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callback(i).onVideoPause();
        }
    }

    public void onVideoPlay() {
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callback(i).onVideoPlay();
        }
    }

    public void onVideoReady() {
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callback(i).onVideoReady();
        }
    }

    public void onVideoStop() {
        for (int i = 0; i < this.callbacks.size(); ++i) {
            this.callback(i).onVideoStop();
        }
    }

    public class Seek
    extends Thread
    implements Runnable {
        VideoSource source;
        long position;

        public Seek(VideoSource source, long position) {
            this.source = source;
            this.position = position;
        }

        public void run() {
            try {
                Player player = this.source.getPlayer();
                if (this.source.getFramePositioningControl() != null) {
                    int frame = VideoUtil.getFrame(this.source.getFramePositioningControl(), this.position, player.getDuration());
                    this.source.getFramePositioningControl().seek(frame);
                } else {
                    player.setMediaTime(this.position);
                }
            }
            catch (Exception e) {
                VideoContainer.this.onVideoError(e);
            }
        }
    }

    public static class Test {
        Boolean seekSupported = null;

        public static Player createPlayer(String resource) throws Exception {
            InputStream stream = resource.getClass().getResourceAsStream(resource);
            try {
                Player player = Manager.createPlayer(stream, "video/3gpp");
                player.realize();
                player.prefetch();
                return player;
            }
            catch (IOException e) {
                Debug.debug("error", "de.enough.polish.video.VideoContainer", 198, "Could not create test player");
                return null;
            }
            catch (MediaException e) {
                Debug.debug("error", "de.enough.polish.video.VideoContainer", 202, "Could not create test player");
                return null;
            }
        }

        public static boolean isSeekSupported(Player player) {
            if (player.getControl("FramePositioningControl") != null) {
                return true;
            }
            try {
                player.setMediaTime(0L);
            }
            catch (MediaException e) {
                return false;
            }
            return true;
        }
    }

    public static class Ratio {
        int horizontal;
        int vertical;

        public Ratio(int horizontal, int vertical) {
            this.horizontal = horizontal;
            this.vertical = vertical;
        }

        public int getHorizontal() {
            return this.horizontal;
        }

        public int getVertical() {
            return this.vertical;
        }
    }

    private class Fullscreen
    extends Form {
        VideoContainer parent;

        public Fullscreen(VideoContainer parent) {
            super(null);
            this.parent = parent;
        }

        protected String createCssSelector() {
            return null;
        }

        protected boolean handleKeyPressed(int keyCode, int gameAction) {
            return UiAccess.handleKeyPressed(this.parent.screen, keyCode, gameAction);
        }

        public void showNotify() {
            super.showNotify();
            this.parent.showVideo();
        }

        public void hideNotify() {
            super.hideNotify();
            this.parent.hideVideo();
        }
    }
}

