/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.ArrayList;
import de.enough.polish.util.HashMap;

public class ToStringHelper {
    static String FORMAT_HEADER = " [";
    static String FORMAT_FOOTER = "]";
    static String FORMAT_DESCRIPTION_SEPARATOR = ":";
    static String FORMAT_DESCRIPTION_LIST_SEPARATOR = " , ";
    static String FORMAT_DESCRIPTION_KEYVALUE_SEPARATOR = " : ";
    static String FORMAT_LIST_SEPARATOR = " / ";
    String name;
    StringBuffer buffer = new StringBuffer();
    private boolean isNameInserted;
    private boolean addListSeparator;

    public static ToStringHelper createInstance(String name) {
        return new ToStringHelper(name);
    }

    public ToStringHelper() {
        this(null);
    }

    public ToStringHelper(Object object) {
        this(object.getClass().getName());
    }

    public ToStringHelper(String name) {
        this.buffer.append(FORMAT_HEADER);
        this.name = name;
    }

    void clear() {
        if (this.isNameInserted) {
            this.buffer.delete(0, this.buffer.length());
            this.isNameInserted = false;
            this.buffer.append(FORMAT_HEADER);
        } else {
            this.buffer.delete(FORMAT_HEADER.length(), this.buffer.length());
        }
        this.addListSeparator = false;
    }

    void setName(String name) {
        if (this.isNameInserted) {
            this.buffer.delete(0, this.name.length());
            this.isNameInserted = false;
        }
        this.name = name;
    }

    public ToStringHelper set(String id, long value) {
        if (this.addListSeparator) {
            this.buffer.append(FORMAT_LIST_SEPARATOR);
        }
        this.buffer.append(id).append(FORMAT_DESCRIPTION_SEPARATOR).append(value);
        this.addListSeparator = true;
        return this;
    }

    public ToStringHelper set(String id, boolean value) {
        if (this.addListSeparator) {
            this.buffer.append(FORMAT_LIST_SEPARATOR);
        }
        this.buffer.append(id).append(FORMAT_DESCRIPTION_SEPARATOR).append(value);
        this.addListSeparator = true;
        return this;
    }

    public ToStringHelper set(String id, Object value) {
        if (this.addListSeparator) {
            this.buffer.append(FORMAT_LIST_SEPARATOR);
        }
        this.buffer.append(id).append(FORMAT_DESCRIPTION_SEPARATOR).append(value);
        this.addListSeparator = true;
        return this;
    }

    public ToStringHelper set(String id, String value) {
        if (this.addListSeparator) {
            this.buffer.append(FORMAT_LIST_SEPARATOR);
        }
        this.buffer.append(id).append(FORMAT_DESCRIPTION_SEPARATOR).append('\"').append(value).append('\"');
        this.addListSeparator = true;
        return this;
    }

    public ToStringHelper set(String id, ArrayList value) {
        if (this.addListSeparator) {
            this.buffer.append(FORMAT_LIST_SEPARATOR);
        }
        this.buffer.append(id).append(FORMAT_DESCRIPTION_SEPARATOR);
        int size = value.size();
        for (int i = 0; i < size; ++i) {
            Object object = value.get(i);
            this.buffer.append(object);
            if (i == size - 1) continue;
            this.buffer.append(FORMAT_DESCRIPTION_LIST_SEPARATOR);
        }
        this.addListSeparator = true;
        return this;
    }

    public ToStringHelper set(String id, HashMap value) {
        if (this.addListSeparator) {
            this.buffer.append(FORMAT_LIST_SEPARATOR);
        }
        this.buffer.append(id).append(FORMAT_DESCRIPTION_SEPARATOR);
        String description = id + FORMAT_DESCRIPTION_SEPARATOR;
        Object[] keys = value.keys();
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            Object object = value.get(key);
            this.buffer.append(key).append(FORMAT_DESCRIPTION_KEYVALUE_SEPARATOR).append(object);
            if (i == keys.length - 1) continue;
            this.buffer.append(FORMAT_DESCRIPTION_LIST_SEPARATOR);
        }
        this.addListSeparator = true;
        return this;
    }

    public String toString() {
        if (!this.isNameInserted && this.name != null) {
            this.buffer.insert(0, this.name);
            this.isNameInserted = true;
        }
        this.buffer.append(FORMAT_FOOTER);
        String result = this.buffer.toString();
        this.buffer.delete(this.buffer.length() - FORMAT_FOOTER.length(), this.buffer.length());
        return result;
    }
}

