/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.io.Externalizable;
import de.enough.polish.util.Comparable;
import de.enough.polish.util.Comparator;
import de.enough.polish.util.TimePeriod;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimePoint
implements Externalizable,
Comparator,
Comparable {
    public static Comparator COMPARATOR = new TimePoint();
    private static final int VERSION = 100;
    private static final int[] DAYS_PER_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int millisecond;
    private TimeZone timeZone;
    private Calendar calendar;
    private boolean resetCalendar;

    public TimePoint() {
        this(1970, 1, 1, 0, 0, 0, 0, null);
    }

    public TimePoint(DataInputStream in) throws IOException {
        this.read(in);
    }

    public TimePoint(TimePoint tp) {
        this(tp.year, tp.month, tp.day, tp.hour, tp.minute, tp.second, tp.millisecond, tp.timeZone);
    }

    public TimePoint(Calendar cal) {
        this(cal.get(1), cal.get(2), cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), cal.getTimeZone());
        this.calendar = cal;
    }

    public TimePoint(Date date) {
        this.setDate(date);
    }

    public TimePoint(long timeInMillis) {
        this.setDate(timeInMillis);
    }

    public void setDate(TimePoint tp) {
        this.year = tp.year;
        this.month = tp.month;
        this.day = tp.day;
        this.hour = tp.hour;
        this.minute = tp.minute;
        this.second = tp.second;
        this.millisecond = tp.millisecond;
        this.timeZone = tp.timeZone;
    }

    public void setDate(long timeInMillis) {
        this.setDate(new Date(timeInMillis));
    }

    public void setDate(Date date) {
        if (this.calendar != null) {
            this.calendar.setTime(date);
            this.setDate(this.calendar);
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            this.setDate(cal);
        }
    }

    public void setDate(Calendar cal) {
        this.calendar = cal;
        this.timeZone = cal.getTimeZone() == TimeZone.getDefault() ? null : cal.getTimeZone();
        this.year = cal.get(1);
        this.month = cal.get(2);
        this.day = cal.get(5);
        this.hour = cal.get(11);
        this.minute = cal.get(12);
        this.second = cal.get(13);
        this.millisecond = cal.get(14);
    }

    public void setDate(int year, int month, int day) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
    }

    public void setDate(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setMillisecond(millisecond);
    }

    public TimePoint(int year, int month, int day) {
        this(year, month, day, 0, 0, 0, 0, null);
    }

    public TimePoint(int year, int month, int day, int hour, int minute) {
        this(year, month, day, hour, minute, 0, 0, null);
    }

    public TimePoint(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        this(year, month, day, hour, minute, second, millisecond, null);
    }

    public TimePoint(int year, int month, int day, TimeZone timeZone) {
        this(year, month, day, 0, 0, 0, 0, timeZone);
    }

    public TimePoint(int year, int month, int day, int hour, int minute, TimeZone timeZone) {
        this(year, month, day, hour, minute, 0, 0, timeZone);
    }

    public TimePoint(int year, int month, int day, int hour, int minute, int second, int millisecond, TimeZone timeZone) {
        if (month < 0 || month > 11 || day < 1 || day > 31 || hour < 0 || hour > 23 || minute < 0 || minute > 59 || second < 0 || second > 59 || millisecond < 0 || millisecond > 999) {
            // empty if block
        }
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.millisecond = millisecond;
        this.timeZone = timeZone;
    }

    public static TimePoint now() {
        return new TimePoint(Calendar.getInstance());
    }

    public static TimePoint today() {
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new TimePoint(cal);
    }

    public Calendar getAsCalendar() {
        boolean reset = this.resetCalendar;
        if (this.calendar == null) {
            reset = true;
            this.calendar = this.timeZone != null ? Calendar.getInstance(this.timeZone) : Calendar.getInstance();
        }
        if (reset) {
            this.calendar.set(1, this.year);
            this.calendar.set(2, this.month);
            this.calendar.set(5, this.day);
            this.calendar.set(11, this.hour);
            this.calendar.set(12, this.minute);
            this.calendar.set(13, this.second);
            this.calendar.set(14, this.millisecond);
        }
        return this.calendar;
    }

    public Date getAsDate() {
        return this.getAsCalendar().getTime();
    }

    public boolean isBefore(TimePoint tp) {
        if (this.equalsTimeZone(tp)) {
            return this.year < tp.year || this.year == tp.year && this.month < tp.month || this.year == tp.year && this.month == tp.month && this.day < tp.day || this.year == tp.year && this.month == tp.month && this.day == tp.day && this.hour < tp.hour || this.year == tp.year && this.month == tp.month && this.day == tp.day && this.hour == tp.hour && this.minute < tp.minute || this.year == tp.year && this.month == tp.month && this.day == tp.day && this.hour == tp.hour && this.minute == tp.minute && this.second < tp.second || this.year == tp.year && this.month == tp.month && this.day == tp.day && this.hour == tp.hour && this.minute == tp.minute && this.second == tp.second && this.millisecond < tp.millisecond;
        }
        return this.getAsCalendar().before(tp.getAsCalendar());
    }

    public boolean isBefore(TimePoint tp, int scope) {
        boolean result;
        if (this.equalsTimeZone(tp)) {
            boolean bl = result = this.year < tp.year;
            if (!result && this.year == tp.year && scope <= TimePeriod.SCOPE_MONTH) {
                boolean bl2 = result = this.month < tp.month;
                if (!result && this.month == tp.month && scope <= TimePeriod.SCOPE_DAY) {
                    boolean bl3 = result = this.day < tp.day;
                    if (!result && this.day == tp.day && scope <= TimePeriod.SCOPE_HOUR) {
                        boolean bl4 = result = this.hour < tp.hour;
                        if (!result && this.hour == tp.hour && scope <= TimePeriod.SCOPE_MINUTE) {
                            boolean bl5 = result = this.minute < tp.minute;
                            if (!result && this.minute == tp.minute && scope <= TimePeriod.SCOPE_SECOND) {
                                boolean bl6 = result = this.second < tp.second;
                                if (!result && this.second == tp.second) {
                                    result = this.millisecond < tp.millisecond;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            result = this.getAsCalendar().before(tp.getAsCalendar());
        }
        return result;
    }

    private boolean equalsTimeZone(TimePoint tp) {
        if (this.timeZone == tp.timeZone) {
            return true;
        }
        TimeZone defaultTimeZone = TimeZone.getDefault();
        return defaultTimeZone.equals(this.timeZone) && tp.timeZone == null || this.timeZone == null && defaultTimeZone.equals(tp.timeZone);
    }

    public boolean isAfter(TimePoint tp) {
        if (this.equalsTimeZone(tp)) {
            return this.year > tp.year || this.year == tp.year && this.month > tp.month || this.year == tp.year && this.month == tp.month && this.day > tp.day || this.year == tp.year && this.month == tp.month && this.day == tp.day && this.hour > tp.hour || this.year == tp.year && this.month == tp.month && this.day == tp.day && this.hour == tp.hour && this.minute > tp.minute || this.year == tp.year && this.month == tp.month && this.day == tp.day && this.hour == tp.hour && this.minute == tp.minute && this.second > tp.second || this.year == tp.year && this.month == tp.month && this.day == tp.day && this.hour == tp.hour && this.minute == tp.minute && this.second == tp.second && this.millisecond > tp.millisecond;
        }
        return this.getAsCalendar().after(tp.getAsCalendar());
    }

    public boolean isAfter(TimePoint tp, int scope) {
        boolean result;
        if (this.equalsTimeZone(tp)) {
            boolean bl = result = this.year > tp.year;
            if (!result && this.year == tp.year && scope <= TimePeriod.SCOPE_MONTH) {
                boolean bl2 = result = this.month > tp.month;
                if (!result && this.month == tp.month && scope <= TimePeriod.SCOPE_DAY) {
                    boolean bl3 = result = this.day > tp.day;
                    if (!result && this.day == tp.day && scope <= TimePeriod.SCOPE_HOUR) {
                        boolean bl4 = result = this.hour > tp.hour;
                        if (!result && this.hour == tp.hour && scope <= TimePeriod.SCOPE_MINUTE) {
                            boolean bl5 = result = this.minute > tp.minute;
                            if (!result && this.minute == tp.minute && scope <= TimePeriod.SCOPE_SECOND) {
                                boolean bl6 = result = this.second > tp.second;
                                if (!result && this.second == tp.second) {
                                    result = this.millisecond > tp.millisecond;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            result = this.getAsCalendar().after(tp.getAsCalendar());
        }
        return result;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.calendar = null;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
        this.resetCalendar = true;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException();
        }
        this.month = month;
        this.resetCalendar = true;
    }

    public void addMillisecond(long numberOfMilliseconds) {
        long ms;
        for (ms = (long)this.millisecond + numberOfMilliseconds; ms > 999L; ms -= 1000L) {
            this.addSecond(1);
        }
        while (ms < 0L) {
            this.addSecond(-1);
            ms += 1000L;
        }
        this.setMillisecond((int)ms);
    }

    public void addSecond(int numberOfSeconds) {
        int s;
        for (s = this.second + numberOfSeconds; s > 59; s -= 60) {
            this.addMinute(1);
        }
        while (s < 0) {
            this.addMinute(-1);
            s += 60;
        }
        this.setSecond(s);
    }

    public void addMinute(int numberOfMinutes) {
        int m;
        for (m = this.minute + numberOfMinutes; m > 59; m -= 60) {
            this.addHour(1);
        }
        while (m < 0) {
            this.addHour(-1);
            m += 60;
        }
        this.setMinute(m);
    }

    public void addHour(int numberOfHours) {
        int h;
        for (h = this.hour + numberOfHours; h > 23; h -= 24) {
            this.addDay(1);
        }
        while (h < 0) {
            this.addDay(-1);
            h += 24;
        }
        this.setHour(h);
    }

    public void addDay(int numberOfDays) {
        int d;
        int daysInMonth;
        if (numberOfDays > 0) {
            daysInMonth = this.getDaysInMonth();
            for (d = this.day + numberOfDays; d > daysInMonth; d -= daysInMonth) {
                this.addMonth(1);
                daysInMonth = this.getDaysInMonth();
            }
        }
        while (d < 1) {
            this.addMonth(-1);
            daysInMonth = this.getDaysInMonth();
            d += daysInMonth;
        }
        this.setDay(d);
    }

    public void addMonth(int numberOfMonths) {
        int m = this.month;
        m += numberOfMonths;
        while (m > 11) {
            m -= 12;
            this.addYear(1);
        }
        while (m < 0) {
            m += 12;
            this.addYear(-1);
        }
        this.setMonth(m);
        int daysInMonth = this.getDaysInMonth();
        if (this.day > daysInMonth) {
            this.setDay(daysInMonth);
        }
    }

    public void addYear(int numberOfYears) {
        this.setYear(this.year + numberOfYears);
    }

    public void add(TimePoint tp) {
        if (this.equalsTimeZone(tp)) {
            this.addMillisecond(tp.millisecond);
            this.addSecond(tp.second);
            this.addHour(tp.hour);
            this.addDay(tp.day);
            this.addMinute(tp.minute);
            this.addMonth(tp.month);
            this.addYear(tp.year);
        } else {
            this.setDate(this.getTimeInMillis() + tp.getTimeInMillis());
        }
    }

    public void subtract(TimePoint tp) {
        if (this.equalsTimeZone(tp)) {
            this.addMillisecond(-tp.millisecond);
            this.addSecond(-tp.second);
            this.addMinute(-tp.minute);
            this.addHour(-tp.hour);
            this.addDay(-tp.day);
            this.addMonth(-tp.month);
            this.addYear(-tp.year);
        } else {
            this.setDate(this.getTimeInMillis() - tp.getTimeInMillis());
        }
    }

    public TimePoint difference(TimePoint tp) {
        TimePoint diff;
        if (tp.isBefore(this)) {
            diff = new TimePoint(this);
            diff.subtract(tp);
        } else {
            diff = new TimePoint(tp);
            diff.subtract(this);
        }
        return diff;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("for " + day);
        }
        this.day = day;
        this.resetCalendar = true;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("for " + hour);
        }
        this.hour = hour;
        this.resetCalendar = true;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException();
        }
        this.minute = minute;
        this.resetCalendar = true;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        if (second < 0 || second > 60) {
            throw new IllegalArgumentException();
        }
        this.second = second;
    }

    public int getMillisecond() {
        return this.millisecond;
    }

    public void setMillisecond(int millisecond) {
        if (millisecond < 0 || millisecond > 999) {
            throw new IllegalArgumentException();
        }
        this.millisecond = millisecond;
    }

    public boolean equalsHour(TimePoint tp) {
        return this.hour == tp.hour && this.day == tp.day && this.month == tp.month && this.year == tp.year;
    }

    public boolean equalsDay(TimePoint tp) {
        return this.day == tp.day && this.month == tp.month && this.year == tp.year;
    }

    public boolean equalsMonth(TimePoint tp) {
        return this.month == tp.month && this.year == tp.year;
    }

    public boolean equalsYear(TimePoint tp) {
        return this.year == tp.year;
    }

    public boolean equals(TimePoint tp, int scope) {
        boolean result;
        boolean bl = result = this.year == tp.year;
        if (result && scope <= TimePeriod.SCOPE_MONTH) {
            boolean bl2 = result = this.month == tp.month;
            if (result && scope <= TimePeriod.SCOPE_DAY) {
                boolean bl3 = result = this.day == tp.day;
                if (result && scope <= TimePeriod.SCOPE_HOUR) {
                    boolean bl4 = result = this.hour == tp.hour;
                    if (result && scope <= TimePeriod.SCOPE_MINUTE) {
                        boolean bl5 = result = this.minute == tp.minute;
                        if (result && scope <= TimePeriod.SCOPE_SECOND) {
                            boolean bl6 = result = this.second == tp.second;
                            if (result && scope <= TimePeriod.SCOPE_MILLISECOND) {
                                result = this.millisecond == tp.millisecond;
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof TimePoint) {
            TimePoint tp = (TimePoint)o;
            if (this.equalsTimeZone(tp)) {
                return this.year == tp.year && this.month == tp.month && this.day == tp.day && this.hour == tp.hour && this.minute == tp.minute && this.second == tp.second && this.millisecond == tp.millisecond;
            }
            return this.getAsCalendar().equals(tp.getAsCalendar());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.year | this.month | (this.day | this.hour) >> 8 | (this.minute | this.second | this.millisecond) >> 16;
        if (this.timeZone != null) {
            hashCode |= this.timeZone.getID().hashCode();
        }
        return hashCode;
    }

    public long getTimeInMillis() {
        return this.getAsDate().getTime();
    }

    public void read(DataInputStream in) throws IOException {
        int version = in.readInt();
        if (version > 100) {
            throw new IOException("invalid version " + version);
        }
        boolean notNull = in.readBoolean();
        if (notNull) {
            this.timeZone = TimeZone.getTimeZone(in.readUTF());
        }
        this.year = in.readInt();
        this.month = in.readByte();
        this.day = in.readByte();
        this.hour = in.readByte();
        this.minute = in.readByte();
        this.second = in.readByte();
        this.millisecond = in.readShort();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(100);
        boolean notNull = this.timeZone != null;
        out.writeBoolean(notNull);
        if (notNull) {
            out.writeUTF(this.timeZone.getID());
        }
        out.writeInt(this.year);
        out.writeByte(this.month);
        out.writeByte(this.day);
        out.writeByte(this.hour);
        out.writeByte(this.minute);
        out.writeByte(this.second);
        out.writeShort(this.millisecond);
    }

    public int getDayOfWeek() {
        return this.getAsCalendar().get(7);
    }

    public int getDaysInMonth() {
        int daysInMonth = DAYS_PER_MONTH[this.month];
        if (daysInMonth == 28) {
            int dayOfMonth;
            Calendar cal = this.getAsCalendar();
            int calMonth = cal.get(2);
            if (calMonth != 1) {
                cal.set(5, 1);
                cal.set(2, 1);
                this.resetCalendar = true;
            }
            if ((dayOfMonth = cal.get(5)) == 29) {
                daysInMonth = 29;
            } else {
                cal.set(5, 1);
                long addedTime = 2505600000L;
                Date testDate = new Date(cal.getTime().getTime() + addedTime);
                cal.setTime(testDate);
                this.resetCalendar = true;
                if (cal.get(5) == 29) {
                    daysInMonth = 29;
                }
            }
        }
        return daysInMonth;
    }

    public long getTime() {
        return this.getTimeInMillis();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.year).append('-');
        if (this.month < 9) {
            buffer.append('0');
        }
        buffer.append(this.month + 1).append('-');
        if (this.day < 10) {
            buffer.append('0');
        }
        buffer.append(this.day);
        if (this.hour != 0 || this.minute != 0 || this.second != 0 || this.millisecond != 0) {
            buffer.append(' ');
            if (this.hour < 10) {
                buffer.append('0');
            }
            buffer.append(this.hour).append(':');
            if (this.minute < 10) {
                buffer.append('0');
            }
            buffer.append(this.minute).append(':');
            if (this.second < 10) {
                buffer.append('0');
            }
            buffer.append(this.second).append(':');
            buffer.append(this.millisecond);
        }
        if (this.timeZone != null) {
            buffer.append(": ").append(this.timeZone.getID());
        }
        buffer.append(" ~ ").append(super.toString());
        return buffer.toString();
    }

    public int compare(Object o1, Object o2) {
        TimePoint t1 = (TimePoint)o1;
        return t1.compareTo(o2);
    }

    public int compareTo(Object obj) {
        TimePoint tp = (TimePoint)obj;
        int result = this.equals(tp) ? 0 : (this.isBefore(tp) ? -1 : 1);
        return result;
    }

    public String toRfc822() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.year).append('-');
        if (this.month < 9) {
            buffer.append('0');
        }
        buffer.append(this.month + 1).append('-');
        if (this.day < 10) {
            buffer.append('0');
        }
        buffer.append(this.day);
        buffer.append('T');
        if (this.hour < 10) {
            buffer.append('0');
        }
        buffer.append(this.hour).append(':');
        if (this.minute < 10) {
            buffer.append('0');
        }
        buffer.append(this.minute).append(':');
        if (this.second < 10) {
            buffer.append('0');
        }
        buffer.append(this.second);
        if (this.timeZone != null) {
            int rawOffsetMinutes = this.timeZone.getRawOffset() / 60000;
            if (rawOffsetMinutes > 0) {
                buffer.append("+");
            } else {
                buffer.append("-");
                rawOffsetMinutes *= -1;
            }
            int offsetMinutes = rawOffsetMinutes % 60;
            int offsetHours = rawOffsetMinutes / 60;
            if (offsetHours < 10) {
                buffer.append('0');
            }
            buffer.append(offsetHours);
            if (offsetMinutes < 10) {
                buffer.append('0');
            }
            buffer.append(offsetMinutes);
        } else {
            buffer.append("-0000");
        }
        return buffer.toString();
    }

    public String toRfc3339() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.year).append('-');
        if (this.month < 9) {
            buffer.append('0');
        }
        buffer.append(this.month + 1).append('-');
        if (this.day < 10) {
            buffer.append('0');
        }
        buffer.append(this.day);
        buffer.append('T');
        if (this.hour < 10) {
            buffer.append('0');
        }
        buffer.append(this.hour).append(':');
        if (this.minute < 10) {
            buffer.append('0');
        }
        buffer.append(this.minute).append(':');
        if (this.second < 10) {
            buffer.append('0');
        }
        buffer.append(this.second);
        if (this.timeZone != null) {
            int rawOffsetMinutes = this.timeZone.getRawOffset() / 60000;
            if (rawOffsetMinutes > 0) {
                buffer.append("+");
            } else {
                buffer.append("-");
                rawOffsetMinutes *= -1;
            }
            int offsetMinutes = rawOffsetMinutes % 60;
            int offsetHours = rawOffsetMinutes / 60;
            if (offsetHours < 10) {
                buffer.append('0');
            }
            buffer.append(offsetHours);
            buffer.append(':');
            if (offsetMinutes < 10) {
                buffer.append('0');
            }
            buffer.append(offsetMinutes);
        } else {
            buffer.append("-00:00");
        }
        return buffer.toString();
    }

    public static TimePoint parseRfc3339(String dateTimeText) {
        try {
            int year = Integer.parseInt(dateTimeText.substring(0, 4));
            int month = Integer.parseInt(dateTimeText.substring(5, 7)) - 1;
            int day = Integer.parseInt(dateTimeText.substring(8, 10));
            int hour = 0;
            int minute = 0;
            int second = 0;
            int millisecond = 0;
            TimeZone timeZone = null;
            if (dateTimeText.length() > 10) {
                hour = Integer.parseInt(dateTimeText.substring(11, 13));
                minute = Integer.parseInt(dateTimeText.substring(14, 16));
                if (dateTimeText.length() > 17) {
                    second = Integer.parseInt(dateTimeText.substring(17, 19));
                    if (dateTimeText.length() > 19) {
                        char c = dateTimeText.charAt(19);
                        int index = 20;
                        if (c == '.') {
                            long divider = 1L;
                            while (dateTimeText.length() > index && Character.isDigit(dateTimeText.charAt(index))) {
                                ++index;
                                divider *= 10L;
                            }
                            millisecond = (int)(1000L * Long.parseLong(dateTimeText.substring(20, index)) / divider);
                            c = dateTimeText.charAt(index);
                            ++index;
                        }
                        if (c == 'Z') {
                            timeZone = TimeZone.getTimeZone("GMT");
                        } else if (c == '+' || c == '-') {
                            int tzHour = Integer.parseInt(dateTimeText.substring(index, index + 2));
                            int tzMinute = Integer.parseInt(dateTimeText.substring(index + 3, index + 5));
                            long rawOffset = (long)tzMinute * 60L * 1000L + (long)tzHour * 60L * 60L * 1000L;
                            if (c == '-') {
                                rawOffset *= -1L;
                            }
                            String[] ids = TimeZone.getAvailableIDs();
                            long minDiff = Long.MAX_VALUE;
                            TimeZone minDiffTimeZone = null;
                            for (int i = 0; i < ids.length; ++i) {
                                TimeZone tz = TimeZone.getTimeZone(ids[i]);
                                long diff = (long)tz.getRawOffset() - rawOffset;
                                if (diff == 0L) {
                                    minDiffTimeZone = tz;
                                    break;
                                }
                                if (diff >= minDiff) continue;
                                minDiffTimeZone = tz;
                                minDiff = diff;
                            }
                            if (minDiffTimeZone != null) {
                                timeZone = minDiffTimeZone;
                            }
                        }
                    }
                }
            }
            TimePoint tp = new TimePoint(year, month, day, hour, minute, second, millisecond, timeZone);
            return tp;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("for " + dateTimeText + ": " + e);
        }
    }
}

