/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.Debug;
import de.enough.polish.util.TextUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamUtil {
    public static final int DEFAULT_BUFFER = 8192;

    public static String[] getLines(InputStream in, String encoding, int bufferLength) throws IOException {
        String allLines = StreamUtil.getString(in, encoding, bufferLength);
        String[] lines = TextUtil.split(allLines, '\n');
        return lines;
    }

    public static String getString(InputStream in) throws IOException {
        return StreamUtil.getString(in, null, 8192);
    }

    public static String getString(InputStream in, String encoding, int bufferLength) throws IOException {
        byte[] buffer = StreamUtil.readFully(in, bufferLength);
        if (encoding != null) {
            return new String(buffer, 0, buffer.length, encoding);
        }
        return new String(buffer, 0, buffer.length);
    }

    public static String getStringSafe(InputStream in) {
        return StreamUtil.getStringSafe(in, null, 8192);
    }

    public static String getStringSafe(InputStream in, String encoding, int bufferLength) {
        byte[] buffer = StreamUtil.readFullySafe(in, bufferLength);
        if (encoding != null) {
            try {
                return new String(buffer, 0, buffer.length, encoding);
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.util.StreamUtil", 100, (Object)("Unable to encode string with " + encoding), e);
                return new String(buffer, 0, buffer.length);
            }
        }
        return new String(buffer, 0, buffer.length);
    }

    public static byte[] readFully(InputStream in) throws IOException {
        return StreamUtil.readFully(in, 8192);
    }

    public static byte[] readFully(InputStream in, int bufferLength) throws IOException {
        return StreamUtil.readFully(in, new byte[bufferLength]);
    }

    public static byte[] readFully(InputStream in, byte[] buffer) throws IOException {
        int read;
        int bufferLength = buffer.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((read = in.read(buffer, 0, bufferLength)) != -1) {
            out.write(buffer, 0, read);
        }
        return out.toByteArray();
    }

    public static byte[] readFullySafe(InputStream in) {
        return StreamUtil.readFullySafe(in, 8192);
    }

    public static byte[] readFullySafe(InputStream in, int bufferLength) {
        byte[] buffer = new byte[bufferLength];
        return StreamUtil.readFullySafe(in, buffer);
    }

    public static byte[] readFullySafe(InputStream in, byte[] buffer) {
        if (in == null) {
            return null;
        }
        int bufferLength = buffer.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int read;
            while ((read = in.read(buffer, 0, bufferLength)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            Debug.debug("error", "de.enough.polish.util.StreamUtil", 206, (Object)"Unable to read stream fully ", e);
        }
        return out.toByteArray();
    }
}

