/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.ui.Image;
import de.enough.polish.util.DrawUtil;
import javax.microedition.lcdui.Graphics;

public class RgbImage {
    private int[] rgbData;
    private int width;
    private int height;
    private boolean processTransparency;

    public RgbImage(int width, int height) {
        this(width, height, 0, true);
    }

    public RgbImage(int width, int height, int color2) {
        this(width, height, color2, true);
    }

    public RgbImage(int width, int height, int color2, boolean processTransparency) {
        int[] data = new int[width * height];
        this.width = width;
        this.height = height;
        if ((color2 & 0xFF000000) != 0) {
            for (int i = 0; i < width * height; ++i) {
                data[i] = color2;
            }
        }
        this.rgbData = data;
        this.processTransparency = processTransparency;
    }

    public RgbImage(RgbImage source) {
        this.setRgbData(source.copyRgbData(), source.width, source.processTransparency);
    }

    public RgbImage(int[] rgbData, int width) {
        this(rgbData, width, true);
    }

    public RgbImage(int[] rgbData, int width, boolean processTransparency) {
        this.setRgbData(rgbData, width, processTransparency);
    }

    public RgbImage(javax.microedition.lcdui.Image image, boolean processTransparency) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[] data = new int[w * h];
        image.getRGB(data, 0, w, 0, 0, w, h);
        this.setRgbData(data, w, processTransparency);
    }

    public RgbImage(Image image, boolean processTransparency) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[] data = new int[w * h];
        image.getRGB(data, 0, w, 0, 0, w, h);
        this.setRgbData(data, w, processTransparency);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isProcessTransparency() {
        return this.processTransparency;
    }

    public void setProcessTransparency(boolean processTransparency) {
        this.processTransparency = processTransparency;
    }

    public int[] getRgbData() {
        return this.rgbData;
    }

    public int[] copyRgbData() {
        int[] copy = new int[this.rgbData.length];
        System.arraycopy(this.rgbData, 0, copy, 0, copy.length);
        return copy;
    }

    public void setRgbData(int[] rgbData, int width) {
        this.setRgbData(rgbData, width, this.processTransparency);
    }

    public void setRgbData(int[] rgbData, int width, boolean processTransparency) {
        this.rgbData = rgbData;
        this.width = width;
        this.height = rgbData.length / width;
        this.processTransparency = processTransparency;
    }

    public void paint(int x, int y, Graphics g) {
        DrawUtil.drawRgb(this.rgbData, x, y, this.width, this.height, this.processTransparency, g);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void fill(int color2) {
        for (int i = 0; i < this.rgbData.length; ++i) {
            this.rgbData[i] = color2;
        }
    }
}

