/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

public final class MathUtil {
    private MathUtil() {
    }

    public static long round(double value) {
        if (value < 0.0) {
            return (long)(value - 0.5);
        }
        return (long)(value + 0.5);
    }

    public static int apxSin(int x1k) {
        int p = 1;
        if ((x1k %= 1000) < 0) {
            x1k += 1000;
        }
        if (x1k > 250) {
            if (x1k < 500) {
                x1k = 500 - x1k;
            } else if (x1k < 750) {
                p = -1;
                x1k -= 500;
            } else {
                p = -1;
                x1k = 1000 - x1k;
            }
        }
        x1k = x1k * 3141 * 2 / 1000;
        int sq = x1k * x1k / 1000;
        long ret = x1k * 1000000 + x1k * (-sq / 6 * 1000 + sq * sq / 120);
        return (int)(ret / 1005000L) * p;
    }

    public static int apxCos(int x1k) {
        return MathUtil.apxSin(x1k + 250);
    }

    public static double atan(double x) {
        double res;
        if (Math.abs(x) < 1.0) {
            res = x / (1.0 + 0.28 * x * x);
        } else if (x < 0.0) {
            x = -x;
            res = 1.5707963267948966 - x / (x * x + 0.28);
            res = -res;
        } else {
            res = 1.5707963267948966 - x / (x * x + 0.28);
        }
        return res;
    }

    public static double atan2(double x, double y) {
        if (y == 0.0 && x == 0.0) {
            return 0.0;
        }
        if (x > 0.0) {
            if (y > 0.0) {
                return MathUtil.atan(y / x);
            }
            return Math.PI * 2 - MathUtil.atan(-y / x);
        }
        if (x < 0.0) {
            if (y < 0.0) {
                return Math.PI + MathUtil.atan(y / x);
            }
            return Math.PI - MathUtil.atan(-y / x);
        }
        if (y < 0.0) {
            return 4.71238898038469;
        }
        return 1.5707963267948966;
    }
}

