/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.math.FP;
import de.enough.polish.util.Debug;
import de.enough.polish.util.IntHashMap;
import de.enough.polish.util.MathUtil;
import de.enough.polish.util.RgbImage;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class ImageUtil {
    private static final int INTMAX = 1024;
    private static final int PSEUDO_FLOAT = 10;
    private static final int PSEUDO_POW2 = 1024;
    private static final int PSEUDO_POW2M1 = 1023;
    private static final int SCALE_THRESHOLD_SHIFT = 3;
    public static final int EDGEDETECTION_MAP_HIGHEST_QUALITY = -1;
    public static final int EDGEDETECTION_MAP_HIGH_QUALITY = -16843010;
    public static final int EDGEDETECTION_MAP_MEDIUM = -253693728;
    public static final int EDGEDETECTION_MAP_FAST = -255803200;
    public static final int EDGEDETECTION_MAP_FAST_AND_SIMPLE = 0;
    private static final int TO_GRAY_RED_DESATURATOR_FIX = 19595;
    private static final int TO_GRAY_GREEN_DESATURATOR_FIX = 38469;
    private static final int TO_GRAY_BLUE_DESATURATOR_FIX = 7471;

    private ImageUtil() {
    }

    public static void scale(int scaleFactor, int width, int height, int[] rgbData, int[] scaledRgbData) {
        if (scaleFactor < 100) {
            int targetWidth = width * scaleFactor / 100;
            int targetHeight = height * scaleFactor / 100;
            int xStart = (width - scaleFactor * width / 100) / 2;
            int yStart = (height - scaleFactor * height / 100) / 2;
            int destOffset = 0 - width + yStart * width + xStart;
            int pixelRatio = 102400 / scaleFactor;
            for (int y = 0; y < targetHeight; ++y) {
                int dy = (pixelRatio * y >> 10) * width;
                destOffset += width;
                int srcOffset = 0;
                for (int x = 0; x < targetWidth; ++x) {
                    scaledRgbData[destOffset + x] = rgbData[dy + (srcOffset >> 10)];
                    srcOffset += pixelRatio;
                }
            }
        } else {
            int destOffset = 0;
            int srcOffset = 0;
            int pixelRatio = 102400 / scaleFactor;
            int xStart = (width - width * 100 / scaleFactor) / 2;
            int yStart = (height - height * 100 / scaleFactor) / 2;
            int fixedSrcOffset = xStart + width * yStart;
            for (int y = 0; y < height; ++y) {
                int dy = fixedSrcOffset + width * (y * pixelRatio >> 10);
                srcOffset = 0;
                for (int x = 0; x < width; ++x) {
                    scaledRgbData[destOffset + x] = rgbData[dy + (srcOffset >> 10)];
                    srcOffset += pixelRatio;
                }
                destOffset += width;
            }
        }
    }

    public static void particleScale(int factor, int width, int height, int[] sourceRgb, int[] targetRgb) {
        int distanceY;
        int distanceX;
        if (factor < 100) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < targetRgb.length; ++i) {
            targetRgb[i] = 0;
        }
        int centerX = width >> 1;
        int centerY = height >> 1;
        int startX = distanceX = width - width * 100 / factor >> 1;
        int endX = width - distanceX;
        int startY = distanceY = height - height * 100 / factor >> 1;
        int endY = height - distanceY;
        for (int y = startY; y < endY; ++y) {
            for (int x = startX; x < endX; ++x) {
                int targetY;
                distanceX = centerX - x;
                int targetX = centerX - distanceX * factor / 100;
                if (targetX < 0 || targetX >= width || (targetY = centerY - (distanceY = centerY - y) * factor / 100) < 0 || targetY >= height) continue;
                int sourceIndex = y * width + x;
                int targetIndex = targetY * width + targetX;
                targetRgb[targetIndex] = sourceRgb[sourceIndex];
            }
        }
    }

    public static void scale(int opacity, int scaleFactor, int width, int height, int[] rgbData, int[] scaledRgbData) {
        opacity = opacity << 24 | 0xFFFFFF;
        if (scaleFactor < 100) {
            int xStart = (width * 100 - width * scaleFactor) / 200;
            int yStart = (height * 100 - height * scaleFactor) / 200;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int xTarget = x * scaleFactor / 100 + xStart;
                    int yTarget = y * scaleFactor / 100 + yStart;
                    scaledRgbData[yTarget * width + xTarget] = (rgbData[y * width + x] | 0xFF000000) & opacity;
                }
            }
            return;
        }
        int yStart = (height - height * 100 / scaleFactor) / 2 * width;
        int xStart = (width - width * 100 / scaleFactor) / 2;
        for (int y = 0; y < height; ++y) {
            int c1 = y * width;
            int c2 = yStart + y * 100 / scaleFactor * width;
            for (int x = 0; x < width; ++x) {
                scaledRgbData[c1 + x] = (rgbData[c2 + xStart + x * 100 / scaleFactor] | 0xFF000000) & opacity;
            }
        }
    }

    public static int[] scale(int scaledWidth, int scaledHeight, int scanlength, int sourceWidth, int sourceHeight, int[] rgbData) {
        int[] scaledRgbData = new int[scaledWidth * scaledHeight];
        for (int y = 0; y < scaledHeight; ++y) {
            int c1 = y * scaledWidth;
            int c2 = y * sourceHeight / scaledHeight * scanlength;
            for (int x = 0; x < scaledWidth; ++x) {
                scaledRgbData[c1 + x] = rgbData[c2 + x * sourceWidth / scaledWidth];
            }
        }
        return scaledRgbData;
    }

    public static void scaleDownHq(int[] dest, int[] src, int srcWidth, int scaledWidth, int scaledHeight, int opacity, boolean SKIP_FRACTIONS) {
        ImageUtil.scaleDownHq(dest, src, srcWidth, 0, scaledWidth, scaledHeight, opacity, -16843010, SKIP_FRACTIONS);
    }

    public static void scaleDownHq(int[] dest, int[] src, int srcWidth, int scaleFactor, int scaledWidth, int scaledHeight, int opacity, int EDGEDETECTION_MAP, boolean SKIP_FRACTIONS) {
        int srcHeight = src.length / srcWidth;
        int scaleS = scaleFactor != 0 ? 102400 / scaleFactor : (scaledWidth != 0 ? (srcWidth << 10) / scaledWidth : (srcHeight << 10) / scaledHeight);
        if (scaleS == 1024) {
            System.arraycopy(src, 0, dest, 0, src.length);
            return;
        }
        if (scaleS < 1024) {
            throw new IllegalArgumentException();
        }
        if (scaleS > 5120) {
            throw new IllegalArgumentException(" scale >5 may lead to internal overflows use perspectiveShear instead");
        }
        if (scaledHeight == 0) {
            scaledHeight = (srcHeight << 10) / scaleS;
        }
        if (scaledHeight == 0) {
            scaledWidth = (srcWidth << 10) / scaleS;
        }
        int destPointer = 0;
        int[] tmp = new int[5];
        int srcXdetailed = 0;
        int srcYdetailed = 0;
        int srcYrounded = 0;
        int destPixelItensityMinimum = SKIP_FRACTIONS ? 1024 * scaleS * scaleS >> 20 : 0;
        if (EDGEDETECTION_MAP != -1) {
            ImageUtil.scale(src, scaledWidth, scaledHeight, srcWidth, srcHeight, dest);
        }
        int currentDestEdge = 0;
        for (int scaledY = 0; scaledY < scaledHeight; ++scaledY) {
            for (int scaledX = 0; scaledX < scaledWidth; ++scaledX) {
                destPointer = scaledY * scaledWidth + scaledX;
                currentDestEdge = dest[destPointer] & EDGEDETECTION_MAP;
                if (EDGEDETECTION_MAP == -1 || scaledY == scaledHeight - 1 || scaledY == 0 || (currentDestEdge ^ dest[destPointer + 1] & EDGEDETECTION_MAP) != 0 || (currentDestEdge ^ dest[destPointer - 1] & EDGEDETECTION_MAP) != 0 || (currentDestEdge ^ dest[destPointer + scaledWidth] & EDGEDETECTION_MAP) != 0 || (currentDestEdge ^ dest[destPointer - scaledWidth] & EDGEDETECTION_MAP) != 0) {
                    int smallY;
                    int yIntensityStart = 1024 - (srcYdetailed & 0x3FF);
                    int yIntensityEnd = srcYdetailed + scaleS & 0x3FF;
                    if (yIntensityEnd == 0) {
                        yIntensityEnd = 1024;
                    }
                    int xIntensityStart = 1024 - (srcXdetailed & 0x3FF);
                    int xIntensityEnd = srcXdetailed + scaleS & 0x3FF;
                    if (xIntensityEnd == 0) {
                        xIntensityEnd = 1024;
                    }
                    tmp[0] = 0;
                    tmp[1] = 0;
                    tmp[2] = 0;
                    tmp[3] = 0;
                    tmp[4] = 0;
                    tmp = ImageUtil.helpWithX(src, tmp, srcWidth, srcXdetailed, srcYdetailed >> 10, scaleS, yIntensityStart, xIntensityStart, xIntensityEnd, destPixelItensityMinimum);
                    for (smallY = srcYrounded + 1; smallY <= (srcYdetailed + scaleS >> 10) - 1; ++smallY) {
                        tmp = ImageUtil.helpWithX(src, tmp, srcWidth, srcXdetailed, smallY, scaleS, 1024, xIntensityStart, xIntensityEnd, destPixelItensityMinimum);
                    }
                    tmp = smallY < srcHeight ? ImageUtil.helpWithX(src, tmp, srcWidth, srcXdetailed, smallY, scaleS, yIntensityEnd, xIntensityStart, xIntensityEnd, destPixelItensityMinimum) : ImageUtil.mixPixelIn(tmp, 0, yIntensityEnd, destPixelItensityMinimum);
                    dest[destPointer] = tmp[1] == 0 ? 0 : tmp[1] * opacity / (255 * tmp[0]) << 24 | tmp[2] / tmp[1] << 16 | tmp[3] / tmp[1] << 8 | tmp[4] / tmp[1];
                }
                srcXdetailed += scaleS;
                srcYrounded = srcYdetailed >> 10;
            }
            srcXdetailed = 0;
            srcYrounded = (srcYdetailed += scaleS) >> 10;
        }
    }

    private static int[] helpWithX(int[] src, int[] tmp, int srcWidth, int srcXdetailed, int Yrounded, int scaleS, int yIntenstiy, int xIntensityStart, int xIntensityEnd, int destPixelItensityMinimum) {
        if (yIntenstiy < destPixelItensityMinimum >> 3) {
            return tmp;
        }
        int srcXrounded = srcXdetailed >> 10;
        int Y_srcWidth = Yrounded * srcWidth;
        tmp = ImageUtil.mixPixelIn(tmp, src[Y_srcWidth + srcXrounded], xIntensityStart * yIntenstiy >> 10, destPixelItensityMinimum);
        int smallX = 0;
        for (smallX = srcXrounded + 1; smallX <= (srcXdetailed + scaleS >> 10) - 1; ++smallX) {
            tmp = ImageUtil.mixPixelIn(tmp, src[Y_srcWidth + smallX], yIntenstiy, destPixelItensityMinimum);
        }
        tmp = smallX < srcWidth ? ImageUtil.mixPixelIn(tmp, src[Y_srcWidth + smallX], xIntensityEnd * yIntenstiy >> 10, destPixelItensityMinimum) : ImageUtil.mixPixelIn(tmp, 0, xIntensityEnd * yIntenstiy >> 10, destPixelItensityMinimum);
        return tmp;
    }

    private static int[] mixPixelIn(int[] current, int add, int intensity, int destPixelItensityMinimum) {
        if (add == 0) {
            return current;
        }
        if (intensity < destPixelItensityMinimum >> 3) {
            return current;
        }
        int alpha = add >>> 24;
        current[0] = current[0] + intensity;
        current[1] = current[1] + (add >>> 24 & 0xFF) * intensity;
        current[2] = current[2] + (add >>> 16 & 0xFF) * intensity * alpha;
        current[3] = current[3] + (add >>> 8 & 0xFF) * intensity * alpha;
        current[4] = current[4] + (add & 0xFF) * intensity * alpha;
        return current;
    }

    public static void perspectiveShear(int[] src, int[] dest, int originalWidth, int newWidth, int leftHeight, int rightHeight, int opacity, int EDGEDETECTION_MAP) {
        int destPointer;
        int h;
        int largeHeight;
        int smallHeight;
        int originalHeight = src.length / originalWidth;
        if (leftHeight > rightHeight) {
            smallHeight = rightHeight;
            largeHeight = leftHeight;
        } else {
            smallHeight = leftHeight;
            largeHeight = rightHeight;
        }
        if (largeHeight > originalHeight || newWidth > originalWidth) {
            throw new IllegalArgumentException("just downscaling possible");
        }
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = 0;
        }
        int srcX = 0;
        int srcY = 0;
        int srcYdetailed = 0;
        int shrinkY = 1024 * (largeHeight - smallHeight) / originalWidth / 2;
        int[] tmp = new int[5];
        for (srcX = 0; srcX < originalWidth; ++srcX) {
            h = leftHeight > rightHeight ? (originalHeight - largeHeight) / 2 + (shrinkY * srcX >> 10) : (originalHeight - smallHeight) / 2 - (shrinkY * srcX >> 10);
            int scaleY = 1024 * originalHeight / (originalHeight - (h << 1));
            for (int destY = 0; destY < originalHeight - (h << 1); ++destY) {
                int smallY;
                srcYdetailed = scaleY * destY;
                srcY = srcYdetailed >> 10;
                destPointer = (destY + h) * originalWidth + srcX;
                int srcY_width = srcY * originalWidth;
                if (EDGEDETECTION_MAP != -1 && srcY != originalHeight - 1 && ((src[srcY_width + srcX] ^ src[(srcY + 1) * originalWidth + srcX]) & EDGEDETECTION_MAP) == 0) {
                    dest[destPointer] = src[srcY_width + srcX];
                    dest[destPointer] = dest[destPointer] & 0xFFFFFF | opacity * (dest[destPointer] >>> 24) / 255 << 24;
                    continue;
                }
                tmp[0] = 0;
                tmp[1] = 0;
                tmp[2] = 0;
                tmp[3] = 0;
                tmp[4] = 0;
                int yIntensityStart = 1024 - (srcYdetailed & 0x3FF);
                int yIntensityEnd = srcYdetailed + scaleY & 0x3FF;
                if (yIntensityEnd == 0) {
                    yIntensityEnd = 1024;
                }
                tmp = ImageUtil.mixPixelIn(tmp, src[srcY_width + srcX], yIntensityStart, 0);
                for (smallY = srcY + 1; smallY <= (srcYdetailed + scaleY >> 10) - 1; ++smallY) {
                    tmp = ImageUtil.mixPixelIn(tmp, src[smallY * originalWidth + srcX], 1024, 0);
                }
                tmp = smallY < originalHeight ? ImageUtil.mixPixelIn(tmp, src[smallY * originalWidth + srcX], yIntensityEnd, 0) : ImageUtil.mixPixelIn(tmp, 0, yIntensityEnd, 0);
                dest[destPointer] = tmp[1] == 0 ? 0 : tmp[1] * opacity / (255 * tmp[0]) << 24 | tmp[2] / tmp[1] << 16 | tmp[3] / tmp[1] << 8 | tmp[4] / tmp[1];
            }
        }
        int scaleX = 1024 * originalWidth / newWidth;
        if (scaleX != 1) {
            for (int y = h = (originalHeight - largeHeight) / 2; y < originalHeight - h; ++y) {
                int y_width = y * originalWidth;
                for (int destX = 0; destX < newWidth; ++destX) {
                    int smallX;
                    int srcXdetailed = scaleX * destX;
                    srcX = srcXdetailed >> 10;
                    destPointer = y_width + destX;
                    if (EDGEDETECTION_MAP != -1 && y != originalHeight - 1 && ((dest[y_width + srcX] ^ dest[y_width + srcX + 1]) & EDGEDETECTION_MAP) == 0) {
                        dest[destPointer] = dest[y_width + srcX];
                        continue;
                    }
                    tmp[0] = 0;
                    tmp[1] = 0;
                    tmp[2] = 0;
                    tmp[3] = 0;
                    tmp[4] = 0;
                    int xIntensityStart = 1024 - (srcXdetailed & 0x3FF);
                    int xIntensityEnd = srcXdetailed + scaleX & 0x3FF;
                    if (xIntensityEnd == 0) {
                        xIntensityEnd = 1024;
                    }
                    tmp = ImageUtil.mixPixelIn(tmp, dest[y_width + srcX], xIntensityStart, 0);
                    for (smallX = srcX + 1; smallX <= (srcXdetailed + scaleX >> 10) - 1; ++smallX) {
                        tmp = ImageUtil.mixPixelIn(tmp, dest[y_width + smallX], 1024, 0);
                    }
                    tmp = smallX < originalWidth ? ImageUtil.mixPixelIn(tmp, dest[y_width + smallX], xIntensityEnd, 0) : ImageUtil.mixPixelIn(tmp, 0, xIntensityEnd, 0);
                    dest[destPointer] = tmp[1] == 0 ? 0 : tmp[1] / tmp[0] << 24 | tmp[2] / tmp[1] << 16 | tmp[3] / tmp[1] << 8 | tmp[4] / tmp[1];
                }
                for (int x = newWidth; x < originalWidth; ++x) {
                    dest[y_width + x] = 0;
                }
            }
        }
    }

    public static RgbImage rotate(RgbImage image, int angle) {
        return ImageUtil.rotate(image, angle, image.getWidth() / 2, image.getHeight() / 2);
    }

    public static RgbImage rotate(RgbImage image, int angle, int referenceX, int referenceY) {
        int[] rgbData = image.getRgbData();
        int width = image.getWidth();
        int height = image.getHeight();
        double degreeCos = Math.cos(Math.PI * (double)angle / 180.0);
        double degreeSin = Math.sin(Math.PI * (double)angle / 180.0);
        int rotatedWidth = ImageUtil.getRotatedWidth(angle, width, height, degreeCos, degreeSin);
        int rotatedHeight = ImageUtil.getRotatedHeight(angle, width, height, degreeCos, degreeSin);
        int[] rotatedRgbData = new int[rotatedWidth * rotatedHeight];
        ImageUtil.rotate(rgbData, width, height, referenceX, referenceY, 0xFFFFFF, degreeCos, degreeSin, rotatedRgbData, rotatedWidth, rotatedHeight);
        image.setRgbData(rotatedRgbData, rotatedWidth);
        image.setWidth(rotatedWidth);
        image.setHeight(rotatedHeight);
        return image;
    }

    public static int[] rotate(int[] argbArray, int width, int height, int degree, int backgroundColor) {
        return ImageUtil.rotate(argbArray, width, height, degree, width / 2, height / 2, backgroundColor);
    }

    public static int[] rotate(int[] sourceRgbData, int width, int height, int degree, int referenceX, int referenceY, int backgroundColor) {
        double degreeCos = Math.cos(Math.PI * (double)degree / 180.0);
        double degreeSin = Math.sin(Math.PI * (double)degree / 180.0);
        int rotatedWidth = ImageUtil.getRotatedWidth(degree, width, height, degreeCos, degreeSin);
        int rotatedHeight = ImageUtil.getRotatedHeight(degree, width, height, degreeCos, degreeSin);
        int[] rotatedRgb = new int[rotatedHeight * rotatedWidth];
        ImageUtil.rotate(sourceRgbData, width, height, referenceX, referenceY, backgroundColor, degreeCos, degreeSin, rotatedRgb, rotatedWidth, rotatedHeight);
        return rotatedRgb;
    }

    public static void rotate(int[] sourceRgbData, int width, int height, int referenceX, int referenceY, int backgroundColor, double degreeCos, double degreeSin, int[] rotatedRGB, int rotatedWidth, int rotatedHeight) {
        ImageUtil.rotate(sourceRgbData, width, height, referenceX, referenceY, backgroundColor, degreeCos, degreeSin, rotatedRGB, rotatedWidth, rotatedHeight, 255);
    }

    public static void rotate(int[] sourceRgbData, int width, int height, int referenceX, int referenceY, int backgroundColor, double degreeCos, double degreeSin, int[] rotatedRGB, int rotatedWidth, int rotatedHeight, int opacity) {
        int y;
        int alpha = opacity << 24;
        int halfOfWidth = width / 2;
        int halfOfHeight = height / 2;
        int halfOfRotatedHeight = rotatedHeight / 2;
        int halfOfRotatedWidth = rotatedWidth / 2;
        int degCos = (int)(1024.0 * degreeCos);
        int degSin = (int)(1024.0 * degreeSin);
        int rotatedHeightMinus1 = rotatedHeight - 1;
        int rgbDataLen = sourceRgbData.length - 1;
        int maxWidth = width - 1;
        int[] yMinusRefYTimesDegSin = new int[rotatedHeight];
        int[] yMinusRefYTimesDegCos = new int[rotatedHeight];
        for (y = 0; y < rotatedHeight; ++y) {
            yMinusRefYTimesDegSin[y] = halfOfWidth + ((y - halfOfRotatedHeight) * degSin >> 10);
            yMinusRefYTimesDegCos[y] = halfOfHeight + ((y - halfOfRotatedHeight) * degCos >> 10);
        }
        int x = -1;
        while (++x < rotatedWidth) {
            int xMinusRefXTimesDegCosXPlusHalfWidth = (x - halfOfRotatedWidth) * degCos >> 10;
            int xMinusRefXTimesDegSinXMinusHalfOfHeight = (x - halfOfRotatedWidth) * degSin >> 10;
            y = -1;
            while (++y < rotatedHeightMinus1) {
                int newY;
                int sourcePos;
                int newX = xMinusRefXTimesDegCosXPlusHalfWidth + yMinusRefYTimesDegSin[y];
                if (newX < 0 || newX > maxWidth || (sourcePos = newX + (newY = yMinusRefYTimesDegCos[y] - xMinusRefXTimesDegSinXMinusHalfOfHeight) * width) < 0 || sourcePos > rgbDataLen) continue;
                int sourcePixel = sourceRgbData[sourcePos];
                if (opacity != 255) {
                    sourcePixel = sourcePixel & 0xFFFFFF | alpha;
                }
                rotatedRGB[x + y * rotatedWidth] = sourcePixel;
            }
        }
    }

    public static int getRotatedHeight(int degree, int width, int heigth, double degreeCos, double degreeSin) {
        long maxY;
        if (degree == -90 || degree == 90 || degree == 270 || degree == -270) {
            return width;
        }
        if (degree == 360 || degree == 180 || degree == 0) {
            return heigth;
        }
        long pointY1 = MathUtil.round(0.0 * degreeSin + 0.0 * degreeCos);
        long pointY2 = MathUtil.round((double)width * degreeSin + 0.0 * degreeCos);
        long pointY3 = MathUtil.round(0.0 * degreeSin + (double)heigth * degreeCos);
        long pointY4 = MathUtil.round((double)width * degreeSin + (double)heigth * degreeCos);
        long minY = pointY1;
        if (pointY2 < minY) {
            minY = pointY2;
        }
        if (pointY3 < minY) {
            minY = pointY3;
        }
        if (pointY4 < minY) {
            minY = pointY4;
        }
        if (pointY2 > (maxY = pointY1)) {
            maxY = pointY2;
        }
        if (pointY3 > maxY) {
            maxY = pointY3;
        }
        if (pointY4 > maxY) {
            maxY = pointY4;
        }
        return (int)(maxY - minY);
    }

    public static int getRotatedWidth(int degree, int width, int heigth, double degreeCos, double degreeSin) {
        long maxX;
        if (degree == -90 || degree == 90 || degree == 270 || degree == -270) {
            return heigth;
        }
        if (degree == 360 || degree == 180 || degree == 0) {
            return width;
        }
        long pointX1 = 0L;
        long pointX2 = MathUtil.round((double)width * degreeCos);
        long pointX3 = MathUtil.round((double)(-heigth) * degreeSin);
        long pointX4 = MathUtil.round((double)width * degreeCos - (double)heigth * degreeSin);
        long minX = pointX1;
        if (pointX2 < minX) {
            minX = pointX2;
        }
        if (pointX3 < minX) {
            minX = pointX3;
        }
        if (pointX4 < minX) {
            minX = pointX4;
        }
        if (pointX2 > (maxX = pointX1)) {
            maxX = pointX2;
        }
        if (pointX3 > maxX) {
            maxX = pointX3;
        }
        if (pointX4 > maxX) {
            maxX = pointX4;
        }
        return (int)(maxX - minX);
    }

    public static void rotateSimple(int[] source, int[] target, int w, int h, int degrees) {
        if (degrees == 90) {
            for (int row = 0; row < h; ++row) {
                for (int col = 0; col < w; ++col) {
                    target[col * h + (h - 1 - row)] = source[row * w + col];
                }
            }
        } else if (degrees == 180) {
            for (int row = 0; row < h; ++row) {
                for (int col = 0; col < w; ++col) {
                    target[(h - 1 - row) * w + (w - 1 - col)] = source[row * w + col];
                }
            }
        } else if (degrees == 270) {
            for (int row = 0; row < h; ++row) {
                for (int col = 0; col < w; ++col) {
                    target[(w - 1 - col) * h + row] = source[row * w + col];
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static int[] scale(int opacity, int[] rgbData, int newWidth, int newHeight, int oldWidth, int oldHeight) {
        int[] newrgbData = new int[newWidth * newHeight];
        ImageUtil.scale(opacity, rgbData, newWidth, newHeight, oldWidth, oldHeight, newrgbData);
        return newrgbData;
    }

    public static int[] scale(int[] rgbData, int newWidth, int newHeight, int oldWidth, int oldHeight) {
        int[] newRgbData = new int[newWidth * newHeight];
        ImageUtil.scale(rgbData, newWidth, newHeight, oldWidth, oldHeight, newRgbData);
        return newRgbData;
    }

    public static int[] scale(int[] rgbData, int newWidth, int newHeight, int oldWidth, int oldHeight, boolean keepAspectRatio) {
        int[] newRgbData;
        block6: {
            int[] tmpRgbData = newRgbData = new int[newWidth * newHeight];
            int tmpWidth = newWidth;
            int tmpHeight = newHeight;
            if (keepAspectRatio) {
                tmpWidth = Math.min(newWidth, oldWidth * newHeight / oldHeight);
                tmpHeight = Math.min(newHeight, oldHeight * newWidth / oldWidth);
                boolean bl = keepAspectRatio = tmpWidth != newWidth || tmpHeight != newHeight;
                if (keepAspectRatio) {
                    tmpRgbData = new int[tmpWidth * tmpHeight];
                }
            }
            ImageUtil.scale(rgbData, tmpWidth, tmpHeight, oldWidth, oldHeight, tmpRgbData);
            if (!keepAspectRatio) break block6;
            if (tmpWidth < newWidth) {
                for (int row = 0; row < tmpHeight; ++row) {
                    int startTmp = row * tmpWidth;
                    int startNew = row * newWidth + (newWidth - tmpWidth) / 2;
                    System.arraycopy(tmpRgbData, startTmp, newRgbData, startNew, tmpWidth);
                }
            } else {
                int startRowIndex = newWidth * (newHeight - tmpHeight) / 2;
                for (int row = 0; row < tmpHeight; ++row) {
                    int startTmp = row * tmpWidth;
                    int startNew = startTmp + startRowIndex;
                    System.arraycopy(tmpRgbData, startTmp, newRgbData, startNew, tmpWidth);
                }
            }
        }
        return newRgbData;
    }

    public static int[] stretchVertical(int[] argbArray, int topStrechFactor, int bottomStrechFactor, int width, int heigth) {
        int biggerWidth;
        int procentualScalingHeight;
        int newWidthTop = width * topStrechFactor / 100;
        int newWidthBottom = width * bottomStrechFactor / 100;
        if (newWidthTop < newWidthBottom) {
            procentualScalingHeight = (newWidthBottom - newWidthTop) / heigth;
            biggerWidth = newWidthBottom;
        } else {
            procentualScalingHeight = (newWidthTop - newWidthBottom) / heigth;
            biggerWidth = newWidthTop;
        }
        int[] newArgbArray = new int[biggerWidth * heigth];
        return ImageUtil.stretchVertical(argbArray, newWidthTop, newWidthBottom, biggerWidth, width, heigth, procentualScalingHeight, newArgbArray);
    }

    public static int[] stretchVertical(int[] argbArray, int newWidthTop, int newWidthBottom, int biggerWidth, int width, int heigth, int procentualScalingHeight, int[] newArgbArray) {
        if (procentualScalingHeight == 0) {
            ++procentualScalingHeight;
        }
        int length = newArgbArray.length;
        int oldLength = argbArray.length;
        int insideCurrentY = 0;
        int insideCurrentX = 0;
        int outsideCurrentX = 0;
        int sum1 = (biggerWidth - newWidthTop) / 2;
        int sum2 = biggerWidth - (biggerWidth - newWidthTop) / 2;
        for (int i = 0; i < length; ++i) {
            if ((outsideCurrentX = (outsideCurrentX + 1) % biggerWidth) == 0) {
                if (newWidthTop < newWidthBottom) {
                    sum1 = (biggerWidth - (newWidthTop += procentualScalingHeight)) / 2;
                    sum2 = biggerWidth - (biggerWidth - newWidthTop) / 2;
                } else if (newWidthTop > newWidthBottom) {
                    sum1 = (biggerWidth - (newWidthTop -= procentualScalingHeight)) / 2;
                    sum2 = biggerWidth - (biggerWidth - newWidthTop) / 2;
                }
                ++insideCurrentY;
                insideCurrentX = 0;
            }
            if (outsideCurrentX >= sum1 && outsideCurrentX < sum2) {
                insideCurrentX = (insideCurrentX + 1) % newWidthTop;
                newArgbArray[i] = argbArray[ImageUtil.scaledPixel(oldLength, width, heigth, newWidthTop, heigth, insideCurrentX, insideCurrentY)];
                continue;
            }
            newArgbArray[i] = 0;
        }
        return newArgbArray;
    }

    public static int scaledPixel(int oldLength, int oldWidth, int oldHeigth, int newWidth, int newHeigth, int currentX, int currentY) {
        int horizontalScaleFactorPercent = newWidth * 100 / oldWidth;
        int verticalShrinkFactorPercent = newHeigth * 100 / oldHeigth;
        int targetArrayIndex = currentX * 100 / horizontalScaleFactorPercent + oldWidth * (currentY * 100 / verticalShrinkFactorPercent);
        if (targetArrayIndex >= oldLength) {
            targetArrayIndex = oldLength - 1;
        }
        if (targetArrayIndex < 0) {
            targetArrayIndex = 0;
        }
        return targetArrayIndex;
    }

    public static int[] stretchHorizontal(int[] argbArray, int leftStrechFactor, int rightStrechFactor, int width, int heigth) {
        int biggerHeigth;
        int procentualScalingWidth;
        int newHeigthLeft = heigth * leftStrechFactor / 100;
        int newHeigthRight = heigth * rightStrechFactor / 100;
        if (newHeigthLeft < newHeigthRight) {
            procentualScalingWidth = (newHeigthRight - newHeigthLeft) / width;
            biggerHeigth = newHeigthRight;
        } else {
            procentualScalingWidth = (newHeigthLeft - newHeigthRight) / width;
            biggerHeigth = newHeigthLeft;
        }
        int[] newArgbArray = new int[biggerHeigth * width];
        return ImageUtil.stretchHorizontal(argbArray, newHeigthLeft, newHeigthRight, biggerHeigth, width, heigth, procentualScalingWidth, newArgbArray);
    }

    public static int[] stretchHorizontal(int[] argbArray, int newLeftHeigth, int newRigthHeigth, int biggerHeigth, int width, int heigth, int procentualScalingHeight, int[] newArgbArray) {
        if (procentualScalingHeight == 0) {
            ++procentualScalingHeight;
        }
        int length = newArgbArray.length;
        int oldLength = argbArray.length;
        int idX = 0;
        int idY = 0;
        int x = 0;
        int y = 0;
        int whereIamAt = 0;
        int newHeigth = newLeftHeigth;
        int startColumn = (biggerHeigth - newHeigth) / 2;
        int endColumn = biggerHeigth - (biggerHeigth - newHeigth) / 2;
        for (int i = 0; i < length; ++i) {
            if (startColumn <= idY && endColumn >= idY) {
                newArgbArray[whereIamAt] = argbArray[ImageUtil.scaledPixel(oldLength, width, heigth, width, newHeigth, x, y)];
                y = (y + 1) % newHeigth;
            } else {
                newArgbArray[whereIamAt] = 0;
            }
            idY = (idY + 1) % biggerHeigth;
            whereIamAt = idX + idY * width;
            if (idY != 0) continue;
            ++idX;
            ++x;
            y = 0;
            if (newLeftHeigth < newRigthHeigth) {
                newHeigth += procentualScalingHeight;
            } else if (newLeftHeigth > newRigthHeigth) {
                newHeigth -= procentualScalingHeight;
            }
            startColumn = (biggerHeigth - newHeigth) / 2;
            endColumn = biggerHeigth - (biggerHeigth - newHeigth) / 2;
        }
        return newArgbArray;
    }

    public static void scale(int[] rgbData, int newWidth, int newHeight, int oldWidth, int oldHeight, int[] newRgbData) {
        int pixelRatioWidth = 1024 * oldWidth / newWidth;
        int pixelRatioHeight = 1024 * oldHeight / newHeight;
        int destOffset = 0;
        for (int y = 0; y < newHeight; ++y) {
            int dy = (pixelRatioHeight * y >> 10) * oldWidth;
            int srcOffset = 0;
            for (int x = 0; x < newWidth; ++x) {
                newRgbData[destOffset + x] = rgbData[dy + (srcOffset >> 10)];
                srcOffset += pixelRatioWidth;
            }
            destOffset += newWidth;
        }
    }

    public static void scale(int opacity, int[] rgbData, int newWidth, int newHeight, int oldWidth, int oldHeight, int[] newRgbData) {
        int currentX = 0;
        int currentY = 0;
        int oldLenght = rgbData.length;
        int newLength = newRgbData.length;
        int verticalShrinkFactorPercent = newHeight * 100 / oldHeight;
        int horizontalScaleFactorPercent = newWidth * 100 / oldWidth;
        int alpha = opacity << 24;
        for (int i = 0; i < newLength; ++i) {
            int pixelAlpha;
            int targetArrayIndex;
            if ((currentX = (currentX + 1) % newWidth) == 0) {
                ++currentY;
            }
            if ((targetArrayIndex = currentX * 100 / horizontalScaleFactorPercent + oldWidth * (currentY * 100 / verticalShrinkFactorPercent)) >= oldLenght) {
                targetArrayIndex = oldLenght - 1;
            }
            if (targetArrayIndex < 0) {
                targetArrayIndex = 0;
            }
            int pixel = rgbData[targetArrayIndex];
            if (opacity != 255 && (pixelAlpha = (pixel & 0xFF000000) >>> 24) > opacity) {
                pixel = pixel & 0xFFFFFF | alpha;
            }
            newRgbData[i] = pixel;
        }
    }

    public static void setTransparency(int transparency, int[] data) {
        transparency <<= 24;
        for (int i = 0; i < data.length; ++i) {
            data[i] = data[i] & 0xFFFFFF | transparency;
        }
    }

    public static void setTransparencyOnlyForOpaque(int transparency, int[] data) {
        transparency <<= 24;
        for (int i = 0; i < data.length; ++i) {
            int pixel = data[i];
            if ((pixel & 0xFF000000) == 0) continue;
            data[i] = pixel & 0xFFFFFF | transparency;
        }
    }

    public static void setTransparencyOnlyForOpaque(int transparency, int[] data, boolean onlyForPixelsWithGreaterAlphas) {
        int alpha = transparency << 24;
        for (int i = 0; i < data.length; ++i) {
            int pixel = data[i];
            int pixelApha = (pixel & 0xFF000000) >>> 24;
            if (pixelApha <= transparency && (onlyForPixelsWithGreaterAlphas || pixelApha == 0)) continue;
            data[i] = pixel & 0xFFFFFF | alpha;
        }
    }

    public static int getDeviceColor(int color2) {
        Image imageBuffer = Image.createImage(1, 1);
        Graphics graphicsBuffer = imageBuffer.getGraphics();
        graphicsBuffer.setColor(color2);
        graphicsBuffer.fillRect(0, 0, 1, 1);
        int[] rgbData = new int[1];
        imageBuffer.getRGB(rgbData, 0, 1, 0, 0, 1, 1);
        return rgbData[0];
    }

    public static RgbImage animateColorByHSL(RgbImage sourceImg, int H, int S, int L, int permille) {
        int tH = FP.round(FP.mul(FP.div(FP.intToFix(H), FP.intToFix(1000)), FP.intToFix(permille)));
        int tS = FP.round(FP.mul(FP.div(FP.intToFix(S), FP.intToFix(1000)), FP.intToFix(permille)));
        int tL = FP.round(FP.mul(FP.div(FP.intToFix(L), FP.intToFix(1000)), FP.intToFix(permille)));
        return ImageUtil.changeColorByHSL(sourceImg, tH, tS, tL);
    }

    public static RgbImage changeColorByHSL(RgbImage sourceImg, int H, int S, int L) {
        return ImageUtil.changeColorByHSL(sourceImg, H, S, L, 100);
    }

    public static RgbImage changeColorByHSL(RgbImage sourceImg, int H, int S, int L, int alpha) {
        if (null == sourceImg || null == sourceImg.getRgbData() || sourceImg.getRgbData().length == 0) {
            return null;
        }
        int[] sourceRGB = sourceImg.getRgbData();
        int[] outPutRGB = new int[sourceRGB.length];
        int tH = H > 360 || H < -360 ? H % 360 : H;
        int tS = S > 100 || S < -100 ? S % 100 : S;
        int tL = L > 100 || L < -100 ? L % 100 : L;
        int alphaMask = Math.abs(alpha > 100 || alpha < -100 ? alpha % 100 : alpha);
        tH = FP.clamp(FP.intToFix(tH), 23592960);
        tS = FP.clamp(FP.intToFix(tS), FP.intToFix(100));
        tL = FP.clamp(FP.intToFix(tL), FP.intToFix(100));
        alphaMask = FP.round(FP.mul(FP.intToFix(alphaMask), FP.div(FP.intToFix(255), FP.intToFix(100))));
        alphaMask = 0xFF000000 & alphaMask << 24;
        IntHashMap ihm = new IntHashMap();
        try {
            int[] rgb = new int[3];
            int[] hsl = new int[3];
            int argb = 0;
            int argbOutput = 0;
            int cMax_fix = FP.intToFix(255);
            int i = sourceRGB.length;
            while (--i >= 0) {
                argb = sourceRGB[i];
                if (null == ihm.get(argb)) {
                    rgb[0] = FP.clamp(FP.intToFix(argb >> 16 & 0xFF), cMax_fix);
                    rgb[1] = FP.clamp(FP.intToFix(argb >> 8 & 0xFF), cMax_fix);
                    rgb[2] = FP.clamp(FP.intToFix(argb & 0xFF), cMax_fix);
                    ImageUtil.RGBtoHSL(rgb, 0, hsl, 0);
                    hsl[0] = hsl[0] + tH;
                    hsl[1] = hsl[1] + tS;
                    hsl[2] = hsl[2] + tL;
                    if (hsl[0] > 65536) {
                        hsl[0] = hsl[0] - 65536;
                    }
                    if (hsl[0] < 0) {
                        hsl[0] = hsl[0] + 65536;
                    }
                    if (hsl[1] > 65536) {
                        hsl[1] = 65536;
                    }
                    if (hsl[1] < 0) {
                        hsl[1] = 0;
                    }
                    if (hsl[2] > 65536) {
                        hsl[2] = 65536;
                    }
                    if (hsl[2] < 0) {
                        hsl[2] = 0;
                    }
                    ImageUtil.HSLtoRGB(hsl, 0, rgb, 0);
                    outPutRGB[i] = argbOutput = alphaMask | (FP.round(FP.mul(rgb[0], cMax_fix)) & 0xFF) << 16 | (FP.round(FP.mul(rgb[1], cMax_fix)) & 0xFF) << 8 | FP.round(FP.mul(rgb[2], cMax_fix));
                    ihm.put(argb, new Integer(argbOutput));
                    continue;
                }
                outPutRGB[i] = (Integer)ihm.get(argb);
            }
        }
        catch (Throwable t) {
            Debug.debug("error", "de.enough.polish.util.ImageUtil", 1647, (Object)"Error adjusting RgbImage colorspace: ", t.getMessage());
            Debug.debug("error", "de.enough.polish.util.ImageUtil", 1648, t);
            ihm = null;
            outPutRGB = null;
            System.gc();
            return sourceImg;
        }
        return new RgbImage(outPutRGB, sourceImg.getWidth());
    }

    public static void RGBtoHSL(int[] RGB_fix, int rgbIndice, int[] HSL_fix, int hslIndice) {
        int S_fix;
        int H_fix = 0;
        int R_fix = RGB_fix[rgbIndice];
        int G_fix = RGB_fix[rgbIndice + 1];
        int B_fix = RGB_fix[rgbIndice + 2];
        int colorMax_fix = FP.max(R_fix, FP.max(G_fix, B_fix));
        int colorMin_fix = FP.min(R_fix, FP.min(G_fix, B_fix));
        int colorDelta = colorMax_fix - colorMin_fix;
        int L_fix = colorMin_fix + colorMax_fix >> 1;
        if (colorDelta == 0) {
            H_fix = 0;
            S_fix = 0;
        } else {
            S_fix = L_fix < 32768 ? FP.div(colorDelta, colorMax_fix + colorMin_fix) : FP.div(colorDelta, FP.intToFix(2) - colorMax_fix - colorMin_fix);
            int six_fix = FP.intToFix(6);
            int deltaHalf = colorDelta >> 1;
            int tR_fix = FP.div(FP.div(colorMax_fix - R_fix, six_fix) + deltaHalf, colorDelta);
            int tG_fix = FP.div(FP.div(colorMax_fix - G_fix, six_fix) + deltaHalf, colorDelta);
            int tB_fix = FP.div(FP.div(colorMax_fix - B_fix, six_fix) + deltaHalf, colorDelta);
            if (R_fix == colorMax_fix) {
                H_fix = tB_fix - tG_fix;
            } else if (G_fix == colorMax_fix) {
                H_fix = FP.div(65536, FP.intToFix(3)) + tR_fix - tB_fix;
            } else if (B_fix == colorMax_fix) {
                H_fix = FP.div(FP.intToFix(2), FP.intToFix(3)) + tG_fix - tR_fix;
            }
            if (H_fix < 0) {
                H_fix += 65536;
            }
            if (H_fix > 65536) {
                H_fix -= 65536;
            }
        }
        HSL_fix[hslIndice] = H_fix;
        HSL_fix[hslIndice + 1] = S_fix;
        HSL_fix[hslIndice + 2] = L_fix;
    }

    public static void HSLtoRGB(int[] HSL_fix, int hslIndice, int[] RGB_fix, int rgbIndice) {
        int L_fix = HSL_fix[hslIndice + 2];
        if (L_fix == 0) {
            RGB_fix[rgbIndice] = L_fix;
            RGB_fix[rgbIndice + 1] = L_fix;
            RGB_fix[rgbIndice + 2] = L_fix;
        } else {
            int H_fix = HSL_fix[hslIndice];
            int S_fix = HSL_fix[hslIndice + 1];
            int v2_fix = L_fix < 32768 ? FP.mul(L_fix, 65536 + S_fix) : L_fix + S_fix - FP.mul(L_fix, S_fix);
            int v1_fix = (L_fix << 1) - v2_fix;
            int onethird_fix = FP.div(65536, FP.intToFix(3));
            RGB_fix[rgbIndice] = ImageUtil.HuetoRGB(v1_fix, v2_fix, H_fix + onethird_fix);
            RGB_fix[rgbIndice + 1] = ImageUtil.HuetoRGB(v1_fix, v2_fix, H_fix);
            RGB_fix[rgbIndice + 2] = ImageUtil.HuetoRGB(v1_fix, v2_fix, H_fix - onethird_fix);
        }
    }

    private static int HuetoRGB(int v1_fix, int v2_fix, int H_fix) {
        if (H_fix < 0) {
            H_fix += 65536;
        }
        if (H_fix > 65536) {
            H_fix -= 65536;
        }
        if (FP.mul(FP.intToFix(6), H_fix) < 65536) {
            return FP.mul(FP.mul(v1_fix + (v2_fix - v1_fix), FP.intToFix(6)), H_fix);
        }
        if (H_fix << 1 < 65536) {
            return v2_fix;
        }
        if (FP.mul(FP.intToFix(3), H_fix) < FP.intToFix(2)) {
            return FP.mul(v1_fix + (v2_fix - v1_fix), FP.mul(FP.div(FP.intToFix(2), FP.intToFix(3)) - H_fix, FP.intToFix(6)));
        }
        return v1_fix;
    }

    public static RgbImage animateColorBalance(RgbImage sourceImg, int R, int G, int B, int permille) {
        int tR = FP.round(FP.mul(FP.div(FP.intToFix(R), FP.intToFix(1000)), FP.intToFix(permille)));
        int tG = FP.round(FP.mul(FP.div(FP.intToFix(G), FP.intToFix(1000)), FP.intToFix(permille)));
        int tB = FP.round(FP.mul(FP.div(FP.intToFix(B), FP.intToFix(1000)), FP.intToFix(permille)));
        return ImageUtil.changeColorByHSL(sourceImg, tR, tG, tB);
    }

    public static RgbImage changeColorBalance(RgbImage sourceImg, int R, int G, int B) {
        return ImageUtil.changeColorBalance(sourceImg, R, G, B, 100);
    }

    public static RgbImage changeColorBalance(RgbImage sourceImg, int R, int G, int B, int alpha) {
        if (null == sourceImg || null == sourceImg.getRgbData() || sourceImg.getRgbData().length == 0) {
            return null;
        }
        int[] sourceRGB = sourceImg.getRgbData();
        int[] outPutRGB = new int[sourceRGB.length];
        int tR = R > 100 || R < -100 ? R % 100 : R;
        int tG = G > 100 || G < -100 ? G % 100 : G;
        int tB = B > 100 || B < -100 ? B % 100 : B;
        int alphaMask = Math.abs(alpha > 100 || alpha < -100 ? alpha % 100 : alpha);
        alphaMask = FP.round(FP.mul(FP.intToFix(alphaMask), FP.div(FP.intToFix(255), FP.intToFix(100))));
        alphaMask = 0xFF000000 & alphaMask << 24;
        try {
            int[] rgb = new int[3];
            int[] newRgb = new int[3];
            int argb = 0;
            int cMax = 255;
            int i = sourceRGB.length;
            while (--i >= 0) {
                argb = sourceRGB[i];
                rgb[0] = argb >> 16 & 0xFF;
                rgb[1] = argb >> 8 & 0xFF;
                rgb[2] = argb & 0xFF;
                newRgb[0] = rgb[0] + tR;
                newRgb[1] = rgb[1] + tG;
                newRgb[2] = rgb[2] + tB;
                if (newRgb[0] > cMax) {
                    newRgb[0] = cMax;
                }
                if (newRgb[0] < 0) {
                    newRgb[0] = 0;
                }
                if (newRgb[1] > cMax) {
                    newRgb[1] = cMax;
                }
                if (newRgb[1] < 0) {
                    newRgb[1] = 0;
                }
                if (newRgb[2] > cMax) {
                    newRgb[2] = cMax;
                }
                if (newRgb[2] < 0) {
                    newRgb[2] = 0;
                }
                outPutRGB[i] = alphaMask | (newRgb[0] & 0xFF) << 16 | (newRgb[1] & 0xFF) << 8 | newRgb[2];
            }
        }
        catch (Throwable t) {
            Debug.debug("error", "de.enough.polish.util.ImageUtil", 1926, (Object)"Error balancing RgbImage: ", t.getMessage());
            Debug.debug("error", "de.enough.polish.util.ImageUtil", 1927, t);
        }
        return new RgbImage(outPutRGB, sourceImg.getWidth());
    }

    public static RgbImage changeColorToGrayScale(RgbImage rgbImg) {
        RgbImage gray = null;
        if (null != rgbImg) {
            int[] copy = rgbImg.copyRgbData();
            int i = copy.length;
            while (--i >= 0) {
                copy[i] = ImageUtil.pixelToGrayScale(copy[i]);
            }
            gray = new RgbImage(copy, rgbImg.getWidth());
        }
        return gray;
    }

    private static int pixelToGrayScale(int pixel) {
        int L_fix = FP.mul(FP.intToFix((byte)(pixel >> 16)), 19595) + FP.mul(FP.intToFix((byte)(pixel >> 8)), 38469) + FP.mul(FP.intToFix((byte)pixel), 7471);
        byte grayValue = (byte)(FP.fixToInt(L_fix) & 0xFF);
        return pixel & 0xFF000000 | grayValue << 16 | grayValue << 8 | grayValue;
    }

    public static void drawRgbImageOntoOther(RgbImage target, RgbImage other, int x, int y) {
        ImageUtil.drawRgbImageOntoOther(target, other, x, y, 0, 0, target.getWidth(), target.getHeight());
    }

    public static void drawRgbImageOntoOther(RgbImage target, RgbImage other, int x, int y, int clipX, int clipY, int clipW, int clipH) {
        int localClipH;
        int localClipW;
        int localClipY;
        int localClipX;
        int subX = 0;
        int subY = 0;
        if (x >= clipX + clipW || y >= clipY + clipH || x + other.getWidth() < clipX || y + other.getHeight() < clipY) {
            return;
        }
        if (x + other.getWidth() < clipX + clipW && x > clipX && y + other.getHeight() < clipY + clipH && y > clipY) {
            localClipX = x;
            localClipY = y;
            localClipW = other.getWidth();
            localClipH = other.getHeight();
        } else {
            int width = other.getWidth();
            int height = other.getHeight();
            if (x < clipX) {
                subX = clipX - x;
                localClipX = clipX;
            } else {
                localClipX = x;
            }
            if (y < clipY) {
                subY = clipY - y;
                localClipY = clipY;
            } else {
                localClipY = y;
            }
            localClipW = x + width > clipX + clipW ? clipX + clipW - x - subX : width - subX;
            localClipH = y + height > clipY + clipH ? clipY + clipH - y - subY : height - subY;
        }
        int[] croppedOther = ImageUtil.cropImage(other, subX, subY, localClipW, localClipH);
        int sourceOffset = localClipY * target.getWidth() + localClipX;
        int targetOffset = 0;
        int[] argbSource = target.getRgbData();
        for (int i = 0; i < localClipH; ++i) {
            for (int j = 0; j < localClipW; ++j) {
                argbSource[sourceOffset + j] = ImageUtil.combineColors(argbSource, sourceOffset + j, croppedOther, targetOffset + j);
            }
            sourceOffset += target.getWidth();
            targetOffset += localClipW;
        }
    }

    private static int combineColors(int[] argbSource, int sourceIndex, int[] argbOverlay, int overlayIndex) {
        int source = argbSource[sourceIndex];
        int over = argbOverlay[overlayIndex];
        if (source == 0) {
            return over;
        }
        if (over == 0) {
            return source;
        }
        if ((0xFF & over >> 24) == 255) {
            return over;
        }
        int alphaOver_fix = FP.clamp(FP.intToFix(0xFF & over >> 24), FP.intToFix(255));
        int alphaResult = ImageUtil.overOperator(0xFF & source >> 24, 0xFF & over >> 24, alphaOver_fix);
        int redResult = ImageUtil.overOperator(0xFF & source >> 16, 0xFF & over >> 16, alphaOver_fix);
        int greenResult = ImageUtil.overOperator(0xFF & source >> 8, 0xFF & over >> 8, alphaOver_fix);
        int blueResult = ImageUtil.overOperator(0xFF & source, 0xFF & over, alphaOver_fix);
        return alphaResult << 24 | redResult << 16 | greenResult << 8 | blueResult;
    }

    private static int overOperator(int channelSource, int channelOver, int alpha_fix) {
        return FP.fixToInt(FP.mul(FP.intToFix(channelSource), 65536 - alpha_fix) + FP.mul(FP.intToFix(channelOver), alpha_fix));
    }

    private static int[] cropImage(RgbImage rgbImg, int x, int y, int width, int height) {
        if (x == 0 && y == 0 && rgbImg.getWidth() == width && rgbImg.getHeight() == height) {
            return rgbImg.getRgbData();
        }
        int sourceOffset = y * rgbImg.getWidth() + x;
        int targetOffset = 0;
        int[] sourceArgb = rgbImg.getRgbData();
        int[] newArgb = new int[width * height];
        int i = height;
        while (--i >= 0) {
            System.arraycopy(sourceArgb, sourceOffset, newArgb, targetOffset, width);
            sourceOffset += rgbImg.getWidth();
            targetOffset += width;
        }
        return newArgb;
    }

    public static void clipRgbImageCirkular(RgbImage rgbImg, int circX, int circY, int circWidth, int circHeight, boolean invert) {
        Image img = Image.createImage(rgbImg.getWidth(), rgbImg.getHeight());
        Graphics g = img.getGraphics();
        g.setColor(-1);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        g.setColor(0);
        g.fillArc(circX - (circWidth >> 1), circY - (circHeight >> 1), circWidth, circHeight, 0, 360);
        int[] maskRgb = new int[img.getWidth() * img.getHeight()];
        img.getRGB(maskRgb, 0, img.getWidth(), 0, 0, img.getWidth(), img.getHeight());
        RgbImage mask = new RgbImage(maskRgb, img.getWidth());
        ImageUtil.applyMaskOntoRgbImage(rgbImg, mask, invert);
    }

    public static void applyMaskOntoRgbImage(RgbImage source, RgbImage mask, boolean invert) {
        int[] maskRgb = mask.getRgbData();
        int[] sourceRgb = source.getRgbData();
        int i = maskRgb.length;
        while (--i >= 0) {
            if (invert) {
                sourceRgb[i] = (0xFF & maskRgb[i]) << 24 | 0xFFFFFF & sourceRgb[i];
                continue;
            }
            sourceRgb[i] = 255 - (0xFF & maskRgb[i]) << 24 | 0xFFFFFF & sourceRgb[i];
        }
    }

    public static Image scaleToFit(Image source, int availableWidth, int availableHeight) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        if (sourceWidth > availableWidth || sourceHeight > availableHeight) {
            int[] rgbData = new int[sourceWidth * sourceHeight];
            source.getRGB(rgbData, 0, sourceWidth, 0, 0, sourceWidth, sourceHeight);
            double availableRatio = (double)availableWidth / (double)availableHeight;
            double sourceRatio = (double)sourceWidth / (double)sourceHeight;
            int targetWidth = availableWidth;
            int targetHeight = availableHeight;
            if (availableRatio < sourceRatio) {
                targetHeight = (int)((double)targetWidth / sourceRatio);
            } else {
                targetWidth = (int)((double)targetHeight * sourceRatio);
            }
            int[] newRgbData = new int[targetWidth * targetHeight];
            ImageUtil.scale(rgbData, targetWidth, targetHeight, sourceWidth, sourceHeight, newRgbData);
            return Image.createRGBImage(newRgbData, targetWidth, targetHeight, true);
        }
        return source;
    }

    public static Image scale(Image source, int width, int height) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        if (sourceWidth != width || sourceHeight != height) {
            int[] rgbData = new int[sourceWidth * sourceHeight];
            source.getRGB(rgbData, 0, sourceWidth, 0, 0, sourceWidth, sourceHeight);
            int[] newRgbData = new int[width * height];
            ImageUtil.scale(rgbData, width, height, sourceWidth, sourceHeight, newRgbData);
            return Image.createRGBImage(newRgbData, width, height, true);
        }
        return source;
    }

    public static void applyAlphaOntoRgbImage(RgbImage source, RgbImage alpha) {
        int[] sourceData = source.getRgbData();
        int[] alphaData = alpha.getRgbData();
        for (int index = 0; index < sourceData.length; ++index) {
            sourceData[index] = 0xFFFFFF & sourceData[index] | alphaData[index] & 0xFF000000;
        }
    }

    public static int getPixelColor(Image image, int x, int y) {
        RgbImage rgbImage = new RgbImage(image, true);
        return ImageUtil.getPixelColor(rgbImage, x, y);
    }

    public static int getPixelColor(RgbImage rgbImage, int x, int y) {
        int[] rgbData = rgbImage.getRgbData();
        int offset = y * rgbImage.getWidth() + x;
        if (offset < rgbData.length) {
            return rgbData[offset];
        }
        throw new IllegalArgumentException("offset is out of the image bounds");
    }
}

