/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.io.Externalizable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BooleanStack
implements Externalizable {
    private boolean[] storedObjects;
    private int growthFactor;
    private int size;

    public BooleanStack() {
        this(10, 75);
    }

    public BooleanStack(int initialCapacity) {
        this(initialCapacity, 75);
    }

    public BooleanStack(int initialCapacity, int growthFactor) {
        this.storedObjects = new boolean[initialCapacity];
        this.growthFactor = growthFactor;
    }

    public void push(boolean element) {
        if (this.size >= this.storedObjects.length) {
            this.increaseCapacity();
        }
        this.storedObjects[this.size] = element;
        ++this.size;
    }

    public boolean peek() {
        if (this.size == 0) {
            return false;
        }
        return this.storedObjects[this.size - 1];
    }

    public boolean pop() {
        --this.size;
        return this.storedObjects[this.size];
    }

    public boolean empty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int search(boolean element) {
        boolean[] array = this.getInternalArray();
        int index = this.size - 1;
        int position = 1;
        while (index >= 0) {
            if (array[index] == element) {
                return position;
            }
            --index;
            ++position;
        }
        return -1;
    }

    private void increaseCapacity() {
        int currentCapacity = this.storedObjects.length;
        int newCapacity = currentCapacity + currentCapacity * this.growthFactor / 100;
        if (newCapacity == currentCapacity) {
            ++newCapacity;
        }
        boolean[] newStore = new boolean[newCapacity];
        System.arraycopy(this.storedObjects, 0, newStore, 0, this.size);
        this.storedObjects = newStore;
    }

    public boolean[] getInternalArray() {
        return this.storedObjects;
    }

    public void read(DataInputStream in) throws IOException {
        int storeSize = in.readInt();
        int growFactor = in.readInt();
        boolean[] store = new boolean[storeSize];
        for (int i = 0; i < store.length; ++i) {
            store[i] = in.readBoolean();
        }
        this.storedObjects = store;
        this.size = storeSize;
        this.growthFactor = growFactor;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.growthFactor);
        for (int i = 0; i < this.size; ++i) {
            boolean o = this.storedObjects[i];
            out.writeBoolean(o);
        }
    }
}

