/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class VerticalGradientTextEffect
extends TextEffect {
    private int[] colors;
    private String lastText;
    private static final int CLEAR_COLOR = -16776925;
    private int[] rgbBuffer;
    private boolean useTransparency;

    public VerticalGradientTextEffect() {
        this.isTextSensitive = true;
    }

    public VerticalGradientTextEffect(int startColor, int endColor, int steps) {
        this.colors = DrawUtil.getGradient(startColor, endColor, steps);
    }

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        if (this.colors == null) {
            g.drawString(text, x, y, orientation);
            return;
        }
        Font font = g.getFont();
        int height = font.getHeight();
        int width = font.stringWidth(text);
        int startX = this.getLeftX(x, orientation, width);
        int startY = this.getTopY(y, orientation, height, font.getBaselinePosition());
        if (this.rgbBuffer == null || text != this.lastText || this.rgbBuffer.length != width * height) {
            Image midp2ImageBuffer = Image.createImage(width, height);
            Graphics bufferG = midp2ImageBuffer.getGraphics();
            bufferG.setColor(-16776925);
            bufferG.fillRect(0, 0, width + 1, height + 1);
            int[] clearColorArray = new int[1];
            midp2ImageBuffer.getRGB(clearColorArray, 0, 1, 0, 0, 1, 1);
            int clearColor = clearColorArray[0];
            bufferG.setFont(font);
            int j = 0;
            boolean increase = true;
            int maxJ = this.colors.length - 1;
            for (int i = 0; i < height; ++i) {
                int color2 = this.colors[j];
                bufferG.setClip(0, i, width, 1);
                bufferG.setColor(color2);
                bufferG.drawString(text, 0, 0, 20);
                if (increase) {
                    if (++j < maxJ) continue;
                    increase = false;
                    continue;
                }
                if (--j > 0) continue;
                increase = true;
            }
            int[] localRgbBuffer = new int[width * height];
            midp2ImageBuffer.getRGB(localRgbBuffer, 0, width, 0, 0, width, height);
            for (int i = 0; i < localRgbBuffer.length; ++i) {
                int color3 = localRgbBuffer[i];
                if (color3 != clearColor) continue;
                localRgbBuffer[i] = 0;
            }
            this.rgbBuffer = localRgbBuffer;
            DrawUtil.drawRgb(localRgbBuffer, startX, startY, width, height, true, g);
            this.lastText = text;
        } else {
            DrawUtil.drawRgb(this.rgbBuffer, startX, startY, width, height, true, g);
        }
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
        boolean styleDefined = false;
        int startColor = -1;
        int endColor = -16777216;
        Font font = style.getFont();
        if (font == null) {
            font = Font.getDefaultFont();
        }
        int steps = font.getHeight();
        if (styleDefined || this.colors == null) {
            this.colors = DrawUtil.getGradient(startColor, endColor, steps);
        }
        if (styleDefined || resetStyle) {
            this.useTransparency = (startColor & 0xFF000000) != 0 || (endColor & 0xFF000000) != 0;
            this.lastText = null;
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.colors = new int[n2];
            n = 0;
            while (n < n2) {
                this.colors[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.lastText = (String)Serializer.deserialize(dataInputStream);
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.rgbBuffer = new int[n2];
            n = 0;
            while (n < n2) {
                this.rgbBuffer[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.useTransparency = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        if (this.colors == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.colors.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.colors[n]);
                ++n;
            }
        }
        Serializer.serialize(this.lastText, dataOutputStream);
        if (this.rgbBuffer == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.rgbBuffer.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.rgbBuffer[n]);
                ++n;
            }
        }
        dataOutputStream.writeBoolean(this.useTransparency);
    }
}

