/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.TextEffect;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TypeWriterTextEffect
extends TextEffect {
    private String lastText;
    private String shownText;
    private boolean animationRunning;
    private int currentPos;

    public boolean animate() {
        boolean animated = super.animate();
        String text = this.lastText;
        if (!this.animationRunning || text == null) {
            return animated;
        }
        ++this.currentPos;
        if (this.currentPos > text.length()) {
            this.animationRunning = false;
            this.shownText = null;
        } else {
            this.shownText = text.substring(0, this.currentPos);
        }
        return true;
    }

    public void hideNotify() {
        this.lastText = null;
        this.shownText = null;
        this.currentPos = 0;
    }

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        if (text != this.lastText) {
            this.lastText = text;
            this.animationRunning = true;
            this.currentPos = 0;
            this.shownText = "";
        }
        String shownTextPart = this.shownText;
        if (!this.animationRunning || shownTextPart == null) {
            g.drawString(text, x, y, orientation);
        } else {
            Font font = g.getFont();
            x = this.getLeftX(x, orientation, font.stringWidth(text));
            y = this.getTopY(y, orientation, font.getHeight(), font.getBaselinePosition());
            g.drawString(shownTextPart, x, y, 20);
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.animationRunning = dataInputStream.readBoolean();
        this.currentPos = dataInputStream.readInt();
        this.lastText = (String)Serializer.deserialize(dataInputStream);
        this.shownText = (String)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.animationRunning);
        dataOutputStream.writeInt(this.currentPos);
        Serializer.serialize(this.lastText, dataOutputStream);
        Serializer.serialize(this.shownText, dataOutputStream);
    }
}

