/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.ui.TextEffect;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class SegmentTextEffect
extends TextEffect {
    private int lineColor = 0xFFFFFF;
    private int gap = 3;

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        g.drawString(text, x, y, orientation);
        Font font = g.getFont();
        int width = font.stringWidth(text);
        int height = font.getHeight();
        int yStart = this.getTopY(y, orientation, height, font.getBaselinePosition());
        int xStart = this.getLeftX(x, orientation, width);
        g.setColor(this.lineColor);
        height -= 2;
        for (int i = yStart + this.gap; i < yStart + height; i += this.gap) {
            g.drawLine(xStart, i, xStart + width, i);
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.gap = dataInputStream.readInt();
        this.lineColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.gap);
        dataOutputStream.writeInt(this.lineColor);
    }
}

