/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.io.Serializer;
import de.enough.polish.io.StringReader;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.ui.containerviews.Midp2ContainerView;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import de.enough.polish.util.TextUtil;
import de.enough.polish.util.WrappedText;
import de.enough.polish.xml.XmlPullParser;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class HtmlTextEffect
extends TextEffect {
    private HtmlTextContainerView containerView;
    private transient Item[] textItems;
    private WrappedText storedWrappedText;

    public HtmlTextEffect() {
        this.isTextSensitive = true;
    }

    public void drawStrings(WrappedText textLines, int textColor, int x, int y, int leftBorder, int rightBorder, int lineHeight, int maxWidth, int layout, Graphics g) {
        if (this.containerView == null) {
            super.drawStrings(textLines, textColor, x, y, leftBorder, rightBorder, lineHeight, maxWidth, layout, g);
        } else {
            if ((layout & 3) == 3) {
                x += (rightBorder - leftBorder - this.containerView.getContentWidth()) / 2;
            } else if ((layout & 3) == 2) {
                x += rightBorder - leftBorder - this.containerView.getContentWidth();
            }
            x = leftBorder;
            this.containerView.paintContent(this.textItems, x, y, leftBorder, rightBorder, g);
        }
    }

    public void wrap(StringItem parent, String htmlText, int textColor, Font meFont, int firstLineWidth, int lineWidth, int maxLines, String maxLinesAppendix, int maxLinesAppendixPosition, WrappedText wrappedText) {
        Item item;
        this.storedWrappedText = wrappedText;
        ArrayList childList = new ArrayList();
        Style baseStyle = this.style.clone(true);
        baseStyle.removeAttribute(88);
        Dimension padding = new Dimension(0);
        baseStyle.addAttribute(-7, padding);
        baseStyle.addAttribute(-8, padding);
        baseStyle.addAttribute(-9, padding);
        baseStyle.addAttribute(-10, padding);
        baseStyle.layout &= 0xFFFFC3FF;
        baseStyle.background = null;
        baseStyle.border = null;
        try {
            XmlPullParser xmlReader = new XmlPullParser(new StringReader(htmlText), false);
            xmlReader.relaxed = true;
            this.parse(xmlReader, baseStyle, childList);
        }
        catch (IOException e) {
            Debug.debug("error", "de.enough.polish.ui.texteffects.HtmlTextEffect", 135, (Object)("Unable to parse text " + htmlText), e);
            super.wrap(parent, htmlText, textColor, meFont, firstLineWidth, lineWidth, maxLines, maxLinesAppendix, maxLinesAppendixPosition, wrappedText);
            return;
        }
        Item[] items = (Item[])childList.toArray(new Item[childList.size()]);
        for (int i = 0; i < items.length; ++i) {
            item = items[i];
            item.getItemWidth(lineWidth, lineWidth, -1);
        }
        HtmlTextContainerView view = new HtmlTextContainerView(wrappedText);
        wrappedText.clear();
        view.initContent(items, firstLineWidth, lineWidth, -1);
        if (view.isInitializationError && firstLineWidth < lineWidth) {
            wrappedText.clear();
            view.resetInitializationError();
            item = items[0];
            item.setInitialized(false);
            item.getItemWidth(lineWidth, lineWidth, -1);
            view.initContent(items, lineWidth, lineWidth, -1);
        }
        this.textItems = items;
        this.containerView = view;
    }

    public int calculateLinesHeight(WrappedText lines, int lineHeight, int paddingVertical) {
        if (this.containerView != null) {
            return this.containerView.getContentHeight();
        }
        return super.calculateLinesHeight(lines, lineHeight, paddingVertical);
    }

    private void parse(XmlPullParser parser, Style nodeStyle, ArrayList childList) {
        while (parser.next() != 1) {
            int type = parser.getType();
            if (type == 2) {
                String name = parser.getName().toLowerCase();
                int addedFontStyle = -1;
                if ("b".equals(name)) {
                    addedFontStyle = 1;
                } else if ("i".equals(name)) {
                    addedFontStyle = 2;
                }
                String styleName = parser.getAttributeValue("class");
                if (styleName == null) {
                    styleName = parser.getAttributeValue("id");
                }
                Style nextNodeStyle = null;
                if (styleName != null && (nextNodeStyle = StyleSheet.getStyle(styleName)) != null) {
                    nextNodeStyle.removeAttribute(-7);
                    nextNodeStyle.removeAttribute(-8);
                    nextNodeStyle.removeAttribute(-10);
                    nextNodeStyle.removeAttribute(-9);
                    nextNodeStyle.addAttribute(-6, new Dimension(0));
                }
                if (nextNodeStyle == null) {
                    nextNodeStyle = nodeStyle;
                }
                if (addedFontStyle != -1) {
                    nextNodeStyle = nextNodeStyle.clone(true);
                    Integer fontStyle = nextNodeStyle.getIntProperty(-14);
                    nextNodeStyle.addAttribute(-14, this.addToFontStyle(addedFontStyle, fontStyle));
                }
                this.parse(parser, nextNodeStyle, childList);
                continue;
            }
            if (type == 4) {
                String text = parser.getText();
                this.addText(text, nodeStyle, childList);
                continue;
            }
            if (type != 3) continue;
            return;
        }
    }

    private Object addToFontStyle(int styleSetting, Integer fontStyle) {
        if (fontStyle == null) {
            return new Integer(styleSetting);
        }
        return new Integer(fontStyle | styleSetting);
    }

    private void addText(String text, Style textStyle, ArrayList childList) {
        String[] texts = TextUtil.split(text, ' ');
        for (int i = 0; i < texts.length; ++i) {
            String chunk = texts[i];
            if (i < texts.length - 1) {
                chunk = chunk + " ";
            }
            childList.add(new StringItem(null, chunk, textStyle));
        }
    }

    public void drawString(String text, int textColor, int x, int y, int anchor, Graphics g) {
        g.drawString(text, x, y, anchor);
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }

    public int getFontHeight() {
        if (this.containerView == null) {
            return super.getFontHeight();
        }
        return this.containerView.getContentHeight() / this.storedWrappedText.size();
    }

    public int stringWidth(String str) {
        if (this.containerView == null) {
            this.wrap(null, str, 0, this.getFont(), Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, null, 0, new WrappedText());
        }
        return this.containerView.getContentWidth();
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.containerView = (HtmlTextContainerView)Serializer.deserialize(dataInputStream);
        this.storedWrappedText = (WrappedText)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.containerView, dataOutputStream);
        Serializer.serialize(this.storedWrappedText, dataOutputStream);
    }

    private static class HtmlTextContainerView
    extends Midp2ContainerView {
        private WrappedText wrappedText;
        private int widthDifference;
        private boolean isFirstLine;
        private boolean isInitializationError;

        public HtmlTextContainerView(WrappedText wrappedText) {
            this.wrappedText = wrappedText;
        }

        public void initContent(Item[] items, int firstLineWidth, int availWidth, int availHeight) {
            this.widthDifference = availWidth - firstLineWidth;
            this.isFirstLine = this.widthDifference != 0;
            super.initContent(items, firstLineWidth, availWidth, availHeight);
        }

        protected void addLineBreak(Item[] items, int currentRowStartIndex, int currentRowEndIndex, int currentRowWidth, int currentRowHeight, int availWidth) {
            StringItem stringItem;
            int numberOfLines;
            StringItem endOfLineItem;
            if (currentRowEndIndex == 0 && items.length > 1 && (endOfLineItem = (StringItem)items[currentRowEndIndex]).getNumberOfLines() > 1) {
                endOfLineItem.setInitialized(false);
                this.isInitializationError = true;
            }
            super.addLineBreak(items, currentRowStartIndex, currentRowEndIndex, currentRowWidth, currentRowHeight, availWidth);
            if (this.isFirstLine) {
                this.isFirstLine = false;
                for (int i = currentRowStartIndex; i <= currentRowEndIndex; ++i) {
                    Item item = items[i];
                    item.relativeX += this.widthDifference;
                }
            }
            this.wrappedText.addLine("", currentRowWidth);
            if (currentRowStartIndex == currentRowEndIndex && (numberOfLines = (stringItem = (StringItem)items[currentRowStartIndex]).getNumberOfLines()) > 1) {
                for (int i = 1; i < numberOfLines; ++i) {
                    this.wrappedText.addLine("", 0);
                }
            }
        }

        public boolean isInitializationError() {
            return this.isInitializationError;
        }

        public void resetInitializationError() {
            this.isInitializationError = false;
        }

        public HtmlTextContainerView() {
        }

        public void read(DataInputStream dataInputStream) throws IOException {
            super.read(dataInputStream);
            this.isFirstLine = dataInputStream.readBoolean();
            this.isInitializationError = dataInputStream.readBoolean();
            this.widthDifference = dataInputStream.readInt();
            this.wrappedText = (WrappedText)Serializer.deserialize(dataInputStream);
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeBoolean(this.isFirstLine);
            dataOutputStream.writeBoolean(this.isInitializationError);
            dataOutputStream.writeInt(this.widthDifference);
            Serializer.serialize(this.wrappedText, dataOutputStream);
        }
    }
}

