/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.splash;

import de.enough.polish.ui.Background;
import de.enough.polish.ui.Canvas;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.ScreenInfo;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.ui.splash.ApplicationInitializer;
import de.enough.polish.util.Debug;
import de.enough.polish.util.TextUtil;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class InitializerSplashScreen
extends Canvas
implements Runnable {
    private final ApplicationInitializer initializer;
    private boolean isInitialized;
    private Displayable nextScreen;
    private final Display display;
    private final Image image;
    private String readyMessage;
    private final int messageColor;
    private final int backgroundColor;
    private String message;
    private Background background;
    private boolean isStarted;

    public InitializerSplashScreen(Display display, Image image, ApplicationInitializer initializer) {
        this(display, image, 0xFFFFFF, null, 0, initializer);
    }

    public InitializerSplashScreen(Display display, Image image, ApplicationInitializer initializer, Style style) {
        this(display, image, 0xFFFFFF, null, 0, initializer, style);
    }

    public InitializerSplashScreen(Display display, Image image, int backgroundColor, String readyMessage, int messageColor, ApplicationInitializer initializer) {
        this.display = display;
        this.image = image;
        this.backgroundColor = backgroundColor;
        this.readyMessage = readyMessage;
        this.messageColor = messageColor;
        this.initializer = initializer;
    }

    public InitializerSplashScreen(Display display, Image image, int backgroundColor, String readyMessage, int messageColor, ApplicationInitializer initializer, Style style) {
        this.display = display;
        this.image = image;
        this.backgroundColor = backgroundColor;
        this.readyMessage = readyMessage;
        this.messageColor = messageColor;
        this.initializer = initializer;
        this.background = style.background;
    }

    public void setMessage(String message) {
        this.message = message;
        this.repaint();
    }

    public void paint(Graphics g) {
        int height = this.getHeight();
        int width = this.getWidth();
        if (this.background != null) {
            this.background.paint(0, 0, width, height, g);
        } else {
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, width, height);
        }
        g.drawImage(this.image, width / 2, height / 2, 3);
        if (this.isInitialized) {
            g.setColor(this.messageColor);
            Font font = Font.getDefaultFont();
            String[] lines = TextUtil.wrap(this.readyMessage, font, width - 10, width - 10);
            int y = height - lines.length * (font.getHeight() + 1);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                g.drawString(line, width / 2, y, 17);
                y += font.getHeight() + 1;
            }
        } else if (this.message != null) {
            g.setColor(this.messageColor);
            Font font = Font.getDefaultFont();
            String[] lines = TextUtil.wrap(this.message, font, width - 10, width - 10);
            int y = height - lines.length * (font.getHeight() + 1);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                g.drawString(line, width / 2, y, 17);
                y += font.getHeight() + 1;
            }
        }
        ScreenInfo.paint(g, 0, width);
    }

    public void run() {
        try {
            Thread.sleep(10L);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.nextScreen = this.initializer.initApp();
            if (this.readyMessage == null && this.nextScreen != null) {
                this.display.setCurrent(this.nextScreen);
                return;
            }
            this.isInitialized = true;
            this.repaint();
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.splash.InitializerSplashScreen", 313, (Object)"Unable to call initApp()", e);
            this.message = "Error: " + e.toString();
            this.repaint();
        }
    }

    public void keyPressed(int keyCode) {
        if (this.isInitialized && this.nextScreen != null) {
            this.display.setCurrent(this.nextScreen);
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
        this.keyPressed(0);
    }

    public void pointerReleased(int x, int y) {
        this.keyReleased(0);
    }

    public void pointerDragged(int x, int y) {
    }

    public void sizeChanged(int width, int height) {
        this.repaint();
    }

    public void showNotify() {
        super.setFullScreenMode(true);
        if (this.isStarted) {
            return;
        }
        UiAccess.showNotify(ScreenInfo.item);
        this.isStarted = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void hideNotify() {
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
        this.repaint();
    }
}

