/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ImageUtil;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SqueezeScreenChangeAnimation
extends ScreenChangeAnimation {
    private int[] scaledRgb;
    private int currentHeight;

    protected void onShow(Style style, Display dsplay, int width, int height, Displayable lstDisplayable, Displayable nxtDisplayable, boolean isForward) {
        if (isForward) {
            this.useLastCanvasRgb = true;
            this.useNextCanvasRgb = false;
        } else {
            this.useLastCanvasRgb = false;
            this.useNextCanvasRgb = true;
        }
        this.scaledRgb = new int[width * height];
        super.onShow(style, dsplay, width, height, lstDisplayable, nxtDisplayable, isForward);
    }

    protected boolean animate(long passedTime, long duration) {
        int h;
        int[] original;
        int endValue;
        int startValue;
        if (passedTime > duration) {
            this.scaledRgb = null;
            return false;
        }
        if (this.isForwardAnimation) {
            startValue = this.screenHeight;
            endValue = 10;
            original = this.lastCanvasRgb;
        } else {
            startValue = 10;
            endValue = this.screenHeight;
            original = this.nextCanvasRgb;
        }
        this.currentHeight = h = this.calculateAnimationPoint(startValue, endValue, passedTime, duration);
        ImageUtil.scale(original, this.screenWidth, h, this.screenWidth, this.screenHeight, this.scaledRgb);
        return true;
    }

    protected void paintAnimation(Graphics g) {
        Image canvasImage = this.isForwardAnimation ? this.nextCanvasImage : this.lastCanvasImage;
        g.drawImage(canvasImage, 0, 0, 20);
        g.drawRGB(this.scaledRgb, 0, this.screenWidth, 0, this.screenHeight - this.currentHeight, this.screenWidth, this.currentHeight, false);
    }
}

