/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;

public class DominoScreenChangeAnimation
extends ScreenChangeAnimation {
    private boolean stillRun = true;
    private int degree = 1;
    private int lstdegree = 89;
    private int row = 0;
    private int currentX = 0;
    private int id = 0;
    private int[] left;
    private int[] right;
    private int[] up;
    private int[] down;
    private int[] rgbData;
    private int[] scaleableHeight;
    private int[] scaleableWidth;
    private int wayForScale;
    private int heightScale;

    public DominoScreenChangeAnimation() {
        this.useLastCanvasRgb = true;
        this.useNextCanvasRgb = true;
    }

    protected void onShow(Style style, Display dsplay, int width, int height, Displayable lstDisplayable, Displayable nxtDisplayable, boolean isForward) {
        int i;
        super.onShow(style, dsplay, width, height, lstDisplayable, nxtDisplayable, isForward);
        this.row = 0;
        this.id = 0;
        this.degree = 1;
        this.lstdegree = 89;
        this.stillRun = true;
        this.wayForScale = width * 100 / 90;
        this.heightScale = (height - height * 12 / 100) * 100 / 90;
        this.left = new int[height];
        this.right = new int[height];
        this.scaleableWidth = new int[height];
        for (i = 0; i < this.scaleableWidth.length; ++i) {
            this.scaleableWidth[i] = width;
            this.left[i] = 0;
            this.right[i] = width;
        }
        this.up = new int[width];
        this.down = new int[width];
        this.scaleableHeight = new int[width];
        for (i = 0; i < this.scaleableHeight.length; ++i) {
            this.scaleableHeight[i] = height;
            this.up[i] = 0;
            this.down[i] = height;
        }
        this.rgbData = new int[width * height];
        System.arraycopy(this.lastCanvasRgb, 0, this.rgbData, 0, this.lastCanvasRgb.length);
    }

    protected boolean animate(long passedTime, long duration) {
        int row = 0;
        int column = 0;
        int length = this.rgbData.length - 1;
        int sW = 0;
        int left = 0;
        int right = this.screenWidth;
        int scalePercentWidth = this.screenWidth;
        for (int i = 0; i < length; ++i) {
            int newI;
            int r;
            if ((row = (row + 1) % this.screenWidth) == 0) {
                left = this.left[++column];
                right = this.right[column];
                sW = this.scaleableWidth[column];
                scalePercentWidth = sW * 100 / this.screenWidth;
            }
            int sH = this.scaleableHeight[row];
            if (left > row || right < row || this.down[row] < column || this.up[row] > column) {
                this.rgbData[i] = this.nextCanvasRgb[i];
                continue;
            }
            int c = column - (this.screenHeight - sH);
            if (c < 1) {
                ++c;
            }
            int scalePercentH = (this.screenHeight - (this.screenHeight - sH)) * 100 / this.screenHeight;
            this.row = left + (this.screenWidth - right) / this.screenWidth;
            if (this.row <= row) {
                r = row - this.row;
                scalePercentWidth = sW * 100 / this.screenWidth;
            } else {
                r = row;
                scalePercentWidth = this.row * 100 / this.screenWidth;
            }
            scalePercentWidth = (this.screenWidth - (this.screenWidth - sW)) * 100 / this.screenWidth;
            if (scalePercentWidth < 1) {
                ++scalePercentWidth;
            }
            if (scalePercentH < 1) {
                ++scalePercentH;
            }
            if ((newI = r * 100 / scalePercentWidth + this.screenWidth * (c * 100 / scalePercentH)) >= length) {
                newI = length;
            }
            if (newI < 0) {
                newI = 0;
            }
            this.rgbData[i] = this.lastCanvasRgb[newI];
        }
        this.cubeEffect();
        if (this.scaleableHeight[0] <= 0) {
            this.stillRun = false;
        }
        return this.stillRun;
    }

    private void cubeEffect() {
        int i = 0;
        while (i < this.scaleableHeight.length) {
            int n = i;
            this.scaleableHeight[n] = this.scaleableHeight[n] - 8;
            int n2 = i++;
            this.down[n2] = this.down[n2] - 8;
        }
        i = 0;
        while (i < this.scaleableWidth.length) {
            int n = i;
            this.scaleableWidth[n] = this.scaleableWidth[n] - 8;
            int n3 = i;
            this.right[n3] = this.right[n3] - 4;
            int n4 = i++;
            this.left[n4] = this.left[n4] + 4;
        }
    }

    public void paintAnimation(Graphics g) {
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        g.drawRGB(this.rgbData, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, false);
        ++this.currentX;
    }
}

