/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;

public class CardScreenChangeAnimation
extends ScreenChangeAnimation {
    private boolean stillRun = true;
    private int degree = 1;
    private int lstdegree = 89;
    private int xSplitPosition = 0;
    private int[] rgbData;
    private int[] scaleableHeights;
    private int scaleableWidth;
    private int wayForScale;
    private int heightScale;

    public CardScreenChangeAnimation() {
        this.useLastCanvasRgb = true;
        this.useNextCanvasRgb = true;
    }

    protected void onShow(Style style, Display dsplay, int width, int height, Displayable lstDisplayable, Displayable nxtDisplayable, boolean isForward) {
        this.xSplitPosition = 0;
        this.degree = 1;
        this.lstdegree = 89;
        this.stillRun = true;
        this.wayForScale = width * 100 / 90;
        this.heightScale = (height - height * 12 / 100) * 100 / 90;
        int size = width * height;
        this.scaleableWidth = width;
        this.scaleableHeights = new int[width];
        for (int i = 0; i < this.scaleableHeights.length; ++i) {
            this.scaleableHeights[i] = height;
        }
        this.rgbData = new int[size];
        System.arraycopy(this.lastCanvasRgb, 0, this.rgbData, 0, size);
        super.onShow(style, dsplay, width, height, lstDisplayable, nxtDisplayable, isForward);
    }

    protected boolean animate(long passedTime, long duration) {
        int currentX = 0;
        int currentY = 0;
        int length = this.rgbData.length;
        for (int i = 0; i < length; ++i) {
            int horizontalScaleFactorPercent;
            int sourceX;
            int currentScalableHeight;
            if ((currentX = (currentX + 1) % this.screenWidth) == 0) {
                ++currentY;
            }
            if ((currentScalableHeight = this.scaleableHeights[currentX]) < currentY || this.screenHeight - currentScalableHeight > currentY) {
                this.rgbData[i] = 0;
                continue;
            }
            int targetY = currentY - (this.screenHeight - currentScalableHeight);
            int verticalShrinkFactorPercent = (this.screenHeight - (this.screenHeight - currentScalableHeight) * 2) * 100 / this.screenHeight;
            if (this.xSplitPosition <= currentX) {
                sourceX = currentX - this.xSplitPosition;
                horizontalScaleFactorPercent = this.scaleableWidth * 100 / this.screenWidth;
            } else {
                sourceX = currentX;
                horizontalScaleFactorPercent = this.xSplitPosition * 100 / this.screenWidth;
            }
            int targetArrayIndex = sourceX * 100 / horizontalScaleFactorPercent + this.screenWidth * (targetY * 100 / verticalShrinkFactorPercent);
            if (targetArrayIndex >= length) {
                targetArrayIndex = length - 1;
            }
            if (targetArrayIndex < 0) {
                targetArrayIndex = 0;
            }
            this.rgbData[i] = this.xSplitPosition > currentX ? this.nextCanvasRgb[targetArrayIndex] : this.lastCanvasRgb[targetArrayIndex];
        }
        this.cubeEffect();
        if (this.lstdegree <= 1) {
            this.stillRun = false;
        }
        return this.stillRun;
    }

    private void cubeEffect() {
        int start;
        int sumScale;
        int scale;
        int difference;
        int endOfHeight;
        this.xSplitPosition = this.screenWidth - this.wayForScale * this.lstdegree / 100;
        if (this.degree < 90) {
            ++this.degree;
            this.scaleableWidth = this.screenWidth - this.xSplitPosition;
            endOfHeight = this.screenHeight - this.heightScale * this.degree;
            difference = this.screenHeight + endOfHeight / 100;
            sumScale = scale = (this.screenHeight - difference) * 100 / this.screenWidth;
            start = this.xSplitPosition + 1;
            int finishAnimationSide = this.screenWidth - 5;
            for (int i = start; i < this.screenWidth; ++i) {
                int newScale;
                if (this.xSplitPosition > finishAnimationSide) {
                    newScale = 0;
                } else {
                    newScale = this.screenHeight - scale / 100;
                    scale += sumScale;
                }
                this.scaleableHeights[i] = newScale;
            }
        }
        if (this.lstdegree > 1) {
            --this.lstdegree;
        }
        endOfHeight = this.screenHeight - this.heightScale * this.lstdegree;
        difference = this.screenHeight + endOfHeight / 100;
        sumScale = scale = (this.screenHeight - difference) * 100 / this.screenWidth;
        for (int i = start = this.xSplitPosition + 1; i > 0; --i) {
            int newScale;
            if (this.xSplitPosition < 9) {
                newScale = 0;
            } else {
                newScale = this.screenHeight - scale / 100;
                scale += sumScale;
            }
            this.scaleableHeights[i] = newScale;
        }
    }

    public void paintAnimation(Graphics g) {
        g.drawRGB(this.rgbData, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, false);
    }
}

